/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.wps20;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.glassfish.jersey.client.ClientRequest;
import org.opengis.cite.wps20.SuiteAttribute;
import org.opengis.cite.wps20.basictests.BasicTests;
import org.opengis.cite.wps20.util.ClientUtils;
import org.opengis.cite.wps20.util.URIUtils;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CommonFixture {
    public static final String ROOT_PKG_PATH = "/org/opengis/cite/wps20/";
    protected Client client;
    protected ClientRequest request;
    protected Response response;
    protected URI ServiceUrl;
    protected String EchoProcessId;
    protected String LITERAL_INPUT_ID;
    protected String LITERAL_OUTPUT_ID;
    protected String COMPLEX_INPUT_ID;
    protected String COMPLEX_OUTPUT_ID;
    protected String GET_CAPABILITIES_REQUEST_TEMPLATE_PATH = "/org/opengis/cite/wps20/examples/GetCapabilities.xml";
    protected String DESCRIBE_PROCESS_REQUEST_TEMPLATE_PATH = "/org/opengis/cite/wps20/examples/DescribeProcess.xml";
    protected String LITERAL_REQUEST_TEMPLATE_PATH = "/org/opengis/cite/wps20/examples/Echo_Process_Literal.xml";
    protected String COMPLEX_REQUEST_TEMPLATE_PATH = "/org/opengis/cite/wps20/examples/Echo_Process_Complex.xml";
    protected String INPUT_VALUE_TRANSMISSION_TEMPLATE_PATH = "/org/opengis/cite/wps20/examples/ValidInputValue.xml";
    protected String INPUT_REFERENCE_TRANSMISSION_TEMPLATE_PATH = "/org/opengis/cite/wps20/examples/ValidInputReference.xml";
    protected String OUTPUT_VALUE_TRANSMISSION_TEMPLATE_PATH = "/org/opengis/cite/wps20/examples/ValidOutputValue.xml";
    protected String OUTPUT_REFERENCE_TRANSMISSION_TEMPLATE_PATH = "/org/opengis/cite/wps20/examples/ValidOutputReference.xml";
    protected String UNIQUE_JOB_IDS_TEMPLATE_PATH = "/org/opengis/cite/wps20/examples/ValidUniqueJobIds.xml";
    protected String GET_STATUS_TEMPLATE_PATH = "/org/opengis/cite/wps20/examples/ValidGetStatus.xml";
    protected String GET_RESULT_TEMPLATE_PATH = "/org/opengis/cite/wps20/examples/ValidGetResult.xml";

    @BeforeClass
    public void initCommonFixture(ITestContext testContext) throws Exception {
        Object EchoProcessIdObj;
        Object ServiceUrlObj;
        Object obj = testContext.getSuite().getAttribute(SuiteAttribute.CLIENT.getName());
        if (null != obj) {
            this.client = (Client)Client.class.cast(obj);
        }
        if (null != (ServiceUrlObj = testContext.getSuite().getAttribute(SuiteAttribute.SERVICE_URL.getName()))) {
            this.ServiceUrl = (URI)URI.class.cast(ServiceUrlObj);
            System.out.println("WPS 2.0 SERVICE URL: " + this.ServiceUrl.toString());
        }
        if (null != (EchoProcessIdObj = testContext.getSuite().getAttribute(SuiteAttribute.ECHO_PROCESS_ID.getName()))) {
            this.EchoProcessId = (String)String.class.cast(EchoProcessIdObj);
            System.out.println("WPS 2.0 ECHO PROCESS ID: " + this.EchoProcessId.toString());
        }
        this.GetEchoProcessInputIdAndOutputId();
    }

    @BeforeMethod
    public void clearMessages() {
        this.request = null;
        this.response = null;
    }

    public void GetEchoProcessInputIdAndOutputId() throws URISyntaxException, SAXException, IOException {
        String SERVICE_URL = this.ServiceUrl.toString();
        String ECHO_PROCESS_ID = this.EchoProcessId;
        LinkedHashMap<String, Object> DP_Parameters = new LinkedHashMap<String, Object>();
        DP_Parameters.put("Service", "WPS");
        DP_Parameters.put("Version", "2.0.0");
        DP_Parameters.put("Request", "DescribeProcess");
        DP_Parameters.put("Identifier", ECHO_PROCESS_ID);
        String responseDescribeProcess = this.GetContentFromGETKVPRequest(SERVICE_URL, DP_Parameters);
        Document responseDescribeProcessDocument = this.TransformXMLStringToXMLDocument(responseDescribeProcess);
        NodeList inputList = responseDescribeProcessDocument.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "Input");
        String literalInputId = "";
        String literalOutputId = "";
        String complexInputId = "";
        String complexOutputId = "";
        for (int i = 0; i < inputList.getLength(); ++i) {
            Element element = (Element)inputList.item(i);
            Element literalInputElement = (Element)element.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "LiteralData").item(0);
            Element dataTypeInputElement = (Element)element.getElementsByTagNameNS("http://www.opengis.net/ows/2.0", "DataType").item(0);
            Element complexInputElement = (Element)element.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "ComplexData").item(0);
            String Id = element.getElementsByTagNameNS("http://www.opengis.net/ows/2.0", "Identifier").item(0).getTextContent();
            if (literalInputElement != null && dataTypeInputElement != null) {
                if (!dataTypeInputElement.getTextContent().toLowerCase().equals("string")) continue;
                literalInputId = Id;
                continue;
            }
            if (complexInputElement == null) continue;
            complexInputId = Id;
        }
        NodeList outputList = responseDescribeProcessDocument.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "Output");
        for (int i = 0; i < outputList.getLength(); ++i) {
            Element element = (Element)outputList.item(i);
            Element literalOutputElement = (Element)element.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "LiteralData").item(0);
            Element dataTypeOutputElement = (Element)element.getElementsByTagNameNS("http://www.opengis.net/ows/2.0", "DataType").item(0);
            Element complexOutputElement = (Element)element.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "ComplexData").item(0);
            String Id = element.getElementsByTagNameNS("http://www.opengis.net/ows/2.0", "Identifier").item(0).getTextContent();
            if (literalOutputElement != null && dataTypeOutputElement != null) {
                if (!dataTypeOutputElement.getTextContent().toLowerCase().equals("string")) continue;
                literalOutputId = Id;
                continue;
            }
            if (complexOutputElement == null) continue;
            complexOutputId = Id;
        }
        this.LITERAL_INPUT_ID = literalInputId;
        this.LITERAL_OUTPUT_ID = literalOutputId;
        this.COMPLEX_INPUT_ID = complexInputId;
        this.COMPLEX_OUTPUT_ID = complexOutputId;
    }

    public Document getResponseEntityAsDocument(Response response, String targetURI) {
        return ClientUtils.getResponseEntityAsDocument(response, targetURI);
    }

    public Response buildGetRequest(URI endpoint, Map<String, String> qryParams, MediaType ... mediaTypes) {
        return ClientUtils.buildGetRequest(endpoint, qryParams, mediaTypes);
    }

    public String GetContentFromPOSTXMLRequest(String any_url, Document xml_doc) {
        StringBuilder sb = new StringBuilder();
        HttpURLConnection urlConn = null;
        InputStreamReader in = null;
        String xml = "";
        try {
            BufferedReader bufferedReader;
            xml = this.TransformXMLDocumentToXMLString(xml_doc);
            System.out.println(xml);
            Transformer tf = TransformerFactory.newInstance().newTransformer();
            tf.setOutputProperty("encoding", "UTF-8");
            tf.setOutputProperty("indent", "yes");
            StringWriter out = new StringWriter();
            tf.transform(new DOMSource(xml_doc), new StreamResult(out));
            byte[] postDataBytes = ((Object)out).toString().getBytes("UTF-8");
            URL url = new URL(any_url);
            urlConn = (HttpURLConnection)url.openConnection();
            urlConn.setRequestMethod("POST");
            urlConn.setRequestProperty("Content-Type", "application/xml");
            urlConn.setRequestProperty("Content-Length", String.valueOf(postDataBytes.length));
            urlConn.setDoOutput(true);
            urlConn.getOutputStream().write(postDataBytes);
            if (urlConn != null) {
                urlConn.setReadTimeout(60000);
            }
            if (urlConn != null && urlConn.getInputStream() != null && (bufferedReader = new BufferedReader(in = new InputStreamReader(urlConn.getInputStream(), Charset.defaultCharset()))) != null) {
                int cp;
                while ((cp = bufferedReader.read()) != -1) {
                    sb.append((char)cp);
                }
                bufferedReader.close();
            }
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
            e.printStackTrace();
            throw new RuntimeException("Exception while calling URL:" + any_url, e);
        }
        return sb.toString();
    }

    public Document TransformXMLStringToXMLDocument(String xmlString) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(xmlString)));
            return doc;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String GetContentFromGETKVPRequest(String any_url, Map<String, Object> params) {
        StringBuilder sb = new StringBuilder();
        HttpURLConnection urlConn = null;
        InputStreamReader in = null;
        try {
            BufferedReader bufferedReader;
            StringBuilder Data = new StringBuilder();
            for (Map.Entry<String, Object> param : params.entrySet()) {
                if (Data.length() != 0) {
                    Data.append('&');
                }
                Data.append(URLEncoder.encode(param.getKey(), "UTF-8"));
                Data.append('=');
                Data.append(URLEncoder.encode(String.valueOf(param.getValue()), "UTF-8"));
            }
            URL url = new URL(any_url + "?" + Data.toString());
            urlConn = (HttpURLConnection)url.openConnection();
            urlConn.setRequestMethod("GET");
            urlConn.setDoOutput(true);
            if (urlConn != null) {
                urlConn.setReadTimeout(60000);
            }
            if (urlConn != null && urlConn.getInputStream() != null && (bufferedReader = new BufferedReader(in = new InputStreamReader(urlConn.getInputStream(), Charset.defaultCharset()))) != null) {
                int cp;
                while ((cp = bufferedReader.read()) != -1) {
                    sb.append((char)cp);
                }
                bufferedReader.close();
            }
            in.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while calling URL:" + any_url, e);
        }
        return sb.toString();
    }

    public Document TransformXMLFileToXMLDocument(String URI2) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new File(URI2));
            return doc;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String TransformXMLDocumentToXMLString(Document xmlDoc) throws Exception {
        Transformer tf = TransformerFactory.newInstance().newTransformer();
        tf.setOutputProperty("encoding", "UTF-8");
        tf.setOutputProperty("indent", "yes");
        StringWriter out = new StringWriter();
        tf.transform(new DOMSource(xmlDoc), new StreamResult(out));
        return ((Object)out).toString();
    }

    public void prettyPrint(Document xmlDoc) throws Exception {
        String str = this.TransformXMLDocumentToXMLString(xmlDoc);
        System.out.println(str);
    }

    public HttpURLConnection GetConnection(String serviceURL) throws IOException {
        URL urlObj = new URL(serviceURL);
        return (HttpURLConnection)urlObj.openConnection();
    }

    public Document GetDocumentTemplate(String templatePath, String processId, String inputId, String outputId) throws URISyntaxException, SAXException, IOException {
        URI uriLiteralRequestTemplate = BasicTests.class.getResource(templatePath).toURI();
        Document SEPDocument = URIUtils.parseURI(uriLiteralRequestTemplate);
        Element requestInputElement = (Element)SEPDocument.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "Input").item(0);
        Element requestOutputElement = (Element)SEPDocument.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "Output").item(0);
        Element requestIdElement = (Element)SEPDocument.getElementsByTagNameNS("http://www.opengis.net/ows/2.0", "Identifier").item(0);
        requestIdElement.setTextContent(processId);
        requestInputElement.setAttribute("id", inputId);
        requestOutputElement.setAttribute("id", outputId);
        return SEPDocument;
    }
}

