/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.wps20;

import jakarta.ws.rs.client.Client;
import java.io.File;
import java.net.URI;
import java.util.Map;
import java.util.logging.Level;
import org.opengis.cite.wps20.SuiteAttribute;
import org.opengis.cite.wps20.TestRunArg;
import org.opengis.cite.wps20.util.ClientUtils;
import org.opengis.cite.wps20.util.TestSuiteLogger;
import org.testng.ISuite;
import org.testng.ISuiteListener;

public class SuiteFixtureListener
implements ISuiteListener {
    public void onStart(ISuite suite) {
        this.processSuiteParameters(suite);
        this.registerClientComponent(suite);
    }

    public void onFinish(ISuite suite) {
        if (null != System.getProperty("deleteSubjectOnFinish")) {
            this.deleteTempFiles(suite);
            System.getProperties().remove("deleteSubjectOnFinish");
        }
    }

    void processSuiteParameters(ISuite suite) {
        Map params = suite.getXmlSuite().getParameters();
        TestSuiteLogger.log(Level.CONFIG, "Suite parameters\n" + params.toString());
        String ServiceUrlParam = (String)params.get(TestRunArg.IUT.toString());
        if (null == ServiceUrlParam || ServiceUrlParam.isEmpty()) {
            throw new IllegalArgumentException("Required test run parameter not found: " + TestRunArg.IUT.toString());
        }
        suite.setAttribute(SuiteAttribute.SERVICE_URL.getName(), (Object)URI.create(ServiceUrlParam));
        String EchoProcessIdParam = (String)params.get(TestRunArg.ECHO_PROCESS_ID.toString());
        if (null == EchoProcessIdParam || EchoProcessIdParam.isEmpty()) {
            throw new IllegalArgumentException("Required test run parameter not found: " + TestRunArg.ECHO_PROCESS_ID.toString());
        }
        String EchoProcessIdRefString = (String)params.get(TestRunArg.ECHO_PROCESS_ID.toString());
        suite.setAttribute(SuiteAttribute.ECHO_PROCESS_ID.getName(), (Object)EchoProcessIdRefString);
        if (TestSuiteLogger.isLoggable(Level.FINE)) {
            StringBuilder logMsg = new StringBuilder("Parsed resource retrieved from ");
            logMsg.append(ServiceUrlParam).append("\n");
            TestSuiteLogger.log(Level.FINE, logMsg.toString());
        }
    }

    void registerClientComponent(ISuite suite) {
        Client client = ClientUtils.buildClient();
        if (null != client) {
            suite.setAttribute(SuiteAttribute.CLIENT.getName(), (Object)client);
        }
    }

    void deleteTempFiles(ISuite suite) {
        if (TestSuiteLogger.isLoggable(Level.CONFIG)) {
            return;
        }
        File testSubjFile = (File)suite.getAttribute(SuiteAttribute.TEST_SUBJ_FILE.getName());
        if (testSubjFile.exists()) {
            testSubjFile.delete();
        }
    }
}

