/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.geomatics;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.geotoolkit.geometry.Envelopes;
import org.geotoolkit.geometry.GeneralEnvelope;
import org.geotoolkit.geometry.jts.JTS;
import org.geotoolkit.geometry.jts.JTSEnvelope2D;
import org.geotoolkit.gml.GeometrytoJTS;
import org.geotoolkit.gml.xml.AbstractGeometry;
import org.geotoolkit.referencing.CRS;
import org.geotoolkit.referencing.crs.DefaultGeographicCRS;
import org.geotoolkit.xml.MarshallerPool;
import org.opengis.cite.geomatics.GeodesyUtils;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Extents {
    private static final String CRSREF_OWS = "crs";
    private static final String CRSREF_GML = "srsName";
    private static final String GML_NS = "http://www.opengis.net/gml/3.2";
    private static final GeometryFactory JTS_GEOM_FACTORY = new GeometryFactory();

    private Extents() {
    }

    public static org.opengis.geometry.Envelope calculateEnvelope(NodeList geomNodes) throws JAXBException {
        Unmarshaller unmarshaller = null;
        try {
            MarshallerPool pool = new MarshallerPool("org.geotoolkit.gml.xml.v321");
            unmarshaller = pool.acquireUnmarshaller();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        Envelope envelope = new Envelope();
        CoordinateReferenceSystem crs = null;
        for (int i = 0; i < geomNodes.getLength(); ++i) {
            Geometry jtsGeom;
            Node node = geomNodes.item(i);
            JAXBElement result = (JAXBElement)unmarshaller.unmarshal(node);
            AbstractGeometry gmlGeom = (AbstractGeometry)result.getValue();
            String srsName = gmlGeom.getSrsName();
            if (srsName.startsWith("http")) {
                gmlGeom.setSrsName(GeodesyUtils.convertSRSNameToURN(srsName));
            }
            crs = gmlGeom.getCoordinateReferenceSystem();
            try {
                jtsGeom = GeometrytoJTS.toJTS((AbstractGeometry)gmlGeom);
            }
            catch (FactoryException e) {
                throw new RuntimeException(e);
            }
            envelope.expandToInclude(jtsGeom.getEnvelopeInternal());
        }
        return new JTSEnvelope2D(envelope, crs);
    }

    public static Document envelopeAsGML(org.opengis.geometry.Envelope envelope) {
        Document doc;
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        Element gmlEnv = doc.createElementNS(GML_NS, "gml:Envelope");
        doc.appendChild(gmlEnv);
        gmlEnv.setAttribute(CRSREF_GML, GeodesyUtils.getCRSIdentifier(envelope.getCoordinateReferenceSystem()));
        DecimalFormat df = new DecimalFormat("#.##");
        df.setRoundingMode(RoundingMode.DOWN);
        StringBuffer lowerCoord = new StringBuffer();
        StringBuffer upperCoord = new StringBuffer();
        for (int i = 0; i < envelope.getDimension(); ++i) {
            lowerCoord.append(df.format(envelope.getMinimum(i)));
            upperCoord.append(df.format(envelope.getMaximum(i)));
            if (i >= envelope.getDimension() - 1) continue;
            lowerCoord.append(' ');
            upperCoord.append(' ');
        }
        Element lowerCorner = doc.createElementNS(GML_NS, "gml:lowerCorner");
        lowerCorner.setTextContent(lowerCoord.toString());
        gmlEnv.appendChild(lowerCorner);
        Element upperCorner = doc.createElementNS(GML_NS, "gml:upperCorner");
        upperCorner.setTextContent(upperCoord.toString());
        gmlEnv.appendChild(upperCorner);
        return doc;
    }

    public static Polygon envelopeAsPolygon(org.opengis.geometry.Envelope envelope) {
        DirectPosition lowerCorner = envelope.getLowerCorner();
        DirectPosition upperCorner = envelope.getUpperCorner();
        LinearRing ring = JTS_GEOM_FACTORY.createLinearRing(new Coordinate[]{new Coordinate(lowerCorner.getOrdinate(0), lowerCorner.getOrdinate(1)), new Coordinate(upperCorner.getOrdinate(0), lowerCorner.getOrdinate(1)), new Coordinate(upperCorner.getOrdinate(0), upperCorner.getOrdinate(1)), new Coordinate(lowerCorner.getOrdinate(0), upperCorner.getOrdinate(1)), new Coordinate(lowerCorner.getOrdinate(0), lowerCorner.getOrdinate(1))});
        Polygon polygon = JTS_GEOM_FACTORY.createPolygon(ring);
        JTS.setCRS((Geometry)polygon, (CoordinateReferenceSystem)envelope.getCoordinateReferenceSystem());
        return polygon;
    }

    public static org.opengis.geometry.Envelope coalesceBoundingBoxes(List<Node> bboxNodes) throws FactoryException, TransformException {
        GeneralEnvelope totalExtent = null;
        for (Node bboxNode : bboxNodes) {
            org.opengis.geometry.Envelope nextEnv = Extents.createEnvelope(bboxNode);
            if (null == totalExtent) {
                totalExtent = (GeneralEnvelope)nextEnv;
                continue;
            }
            CoordinateReferenceSystem crs = nextEnv.getCoordinateReferenceSystem();
            if (!crs.equals(totalExtent.getCoordinateReferenceSystem())) {
                nextEnv = Envelopes.transform((org.opengis.geometry.Envelope)nextEnv, (CoordinateReferenceSystem)totalExtent.getCoordinateReferenceSystem());
            }
            totalExtent.add(nextEnv);
        }
        return totalExtent;
    }

    public static org.opengis.geometry.Envelope createEnvelope(Node envelopeNode) throws FactoryException {
        String crsRef;
        Element envElem = Document.class.isInstance(envelopeNode) ? ((Document)Document.class.cast(envelopeNode)).getDocumentElement() : (Element)Element.class.cast(envelopeNode);
        DefaultGeographicCRS crs = null;
        String string = crsRef = envElem.hasAttribute(CRSREF_OWS) ? envElem.getAttribute(CRSREF_OWS) : envElem.getAttribute(CRSREF_GML);
        if (crsRef.isEmpty() || crsRef.equals("urn:ogc:def:crs:OGC:1.3:CRS84")) {
            crs = DefaultGeographicCRS.WGS84;
        } else {
            String id = GeodesyUtils.getAbbreviatedCRSIdentifier(crsRef);
            crs = CRS.decode((String)id);
        }
        GeneralEnvelope env = new GeneralEnvelope((CoordinateReferenceSystem)crs);
        String namespaceURI = envElem.getNamespaceURI();
        String lowerCornerName = namespaceURI.equals(GML_NS) ? "lowerCorner" : "LowerCorner";
        String[] lowerCoords = envElem.getElementsByTagNameNS(namespaceURI, lowerCornerName).item(0).getTextContent().trim().split("\\s");
        String upperCornerName = namespaceURI.equals(GML_NS) ? "upperCorner" : "UpperCorner";
        String[] upperCoords = envElem.getElementsByTagNameNS(namespaceURI, upperCornerName).item(0).getTextContent().trim().split("\\s");
        int dim = lowerCoords.length;
        double[] coords = new double[dim * 2];
        for (int i = 0; i < dim; ++i) {
            coords[i] = Double.parseDouble(lowerCoords[i]);
            coords[i + dim] = Double.parseDouble(upperCoords[i]);
        }
        env.setEnvelope(coords);
        return env;
    }

    public static String envelopeToString(org.opengis.geometry.Envelope envelope) {
        StringBuilder kvp = new StringBuilder();
        double[] lowerCorner = envelope.getLowerCorner().getCoordinate();
        for (int i = 0; i < lowerCorner.length; ++i) {
            kvp.append(lowerCorner[i]).append(',');
        }
        double[] upperCorner = envelope.getUpperCorner().getCoordinate();
        for (int i = 0; i < upperCorner.length; ++i) {
            kvp.append(upperCorner[i]).append(',');
        }
        CoordinateReferenceSystem crs = envelope.getCoordinateReferenceSystem();
        if (!crs.equals(DefaultGeographicCRS.WGS84)) {
            kvp.append(GeodesyUtils.getCRSIdentifier(crs));
        } else {
            kvp.deleteCharAt(kvp.lastIndexOf(","));
        }
        return kvp.toString();
    }
}

