/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.geomatics.gml;

import com.vividsolutions.jts.algorithm.ConvexHull;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import java.net.URI;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.NamespaceContext;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.geotoolkit.geometry.GeneralDirectPosition;
import org.geotoolkit.geometry.jts.JTS;
import org.geotoolkit.gml.xml.AbstractCurveSegment;
import org.geotoolkit.gml.xml.AbstractGeometry;
import org.geotoolkit.gml.xml.Curve;
import org.geotoolkit.gml.xml.v321.AngleType;
import org.geotoolkit.gml.xml.v321.ArcByCenterPointType;
import org.geotoolkit.gml.xml.v321.LengthType;
import org.geotoolkit.referencing.CRS;
import org.geotoolkit.temporal.factory.DefaultTemporalFactory;
import org.geotoolkit.temporal.object.DefaultPosition;
import org.geotoolkit.xml.MarshallerPool;
import org.opengis.cite.geomatics.GeodesyUtils;
import org.opengis.cite.geomatics.gml.CurveCoordinateListFactory;
import org.opengis.cite.geomatics.gml.GeometryCoordinateList;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.temporal.Instant;
import org.opengis.temporal.Position;
import org.opengis.temporal.TemporalGeometricPrimitive;
import org.opengis.util.FactoryException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GmlUtils {
    public static final String SRS_NAME = "srsName";
    public static final String GML_NS = "http://www.opengis.net/gml/3.2";
    static final int TOTAL_ARC_POINTS = 5;
    private static final Unmarshaller GML_UNMARSHALLER = GmlUtils.initGmlUnmarshaller();

    private static Unmarshaller initGmlUnmarshaller() {
        Unmarshaller unmarshaller = null;
        try {
            MarshallerPool pool = new MarshallerPool("org.geotoolkit.gml.xml.v321");
            unmarshaller = pool.acquireUnmarshaller();
        }
        catch (JAXBException je) {
            throw new RuntimeException(je);
        }
        return unmarshaller;
    }

    public static void inferPointsOnArc(AbstractCurveSegment segment, CoordinateReferenceSystem crs, List<Coordinate> coordList) {
        ArcByCenterPointType arc = (ArcByCenterPointType)segment;
        List centerCoords = null != arc.getPos() ? arc.getPos().getValue() : arc.getPosList().getValue();
        GeneralDirectPosition center = new GeneralDirectPosition(crs);
        center.setLocation(new double[]{(Double)centerCoords.get(0), (Double)centerCoords.get(1)});
        AngleType startAngle = arc.getStartAngle();
        AngleType endAngle = arc.getEndAngle();
        if (null == startAngle) {
            startAngle = new AngleType();
            startAngle.setValue(0.0);
            endAngle = new AngleType();
            endAngle.setValue(360.0);
        }
        if (endAngle.getValue() == 0.0) {
            endAngle.setValue(360.0);
        }
        LengthType radius = arc.getRadius();
        double radiusInMeters = GmlUtils.lengthInMeters(radius);
        DirectPosition startPos = GeodesyUtils.calculateDestination((org.opengis.geometry.coordinate.Position)center, startAngle.getValue(), radiusInMeters);
        coordList.add(new Coordinate(startPos.getOrdinate(0), startPos.getOrdinate(1)));
        double delta = (endAngle.getValue() - startAngle.getValue()) / 4.0;
        for (int i = 1; i < 4; ++i) {
            double angle = startAngle.getValue() + delta * (double)i;
            DirectPosition arcPos = GeodesyUtils.calculateDestination((org.opengis.geometry.coordinate.Position)center, angle, radiusInMeters);
            coordList.add(new Coordinate(arcPos.getOrdinate(0), arcPos.getOrdinate(1)));
        }
        DirectPosition endPos = GeodesyUtils.calculateDestination((org.opengis.geometry.coordinate.Position)center, endAngle.getValue(), radiusInMeters);
        coordList.add(new Coordinate(endPos.getOrdinate(0), endPos.getOrdinate(1)));
    }

    public static Geometry computeConvexHull(AbstractGeometry gmlGeom) {
        GeometryCoordinateList coordSet = new GeometryCoordinateList();
        Coordinate[] pointSet = coordSet.getCoordinateList(gmlGeom);
        ConvexHull hull = new ConvexHull(pointSet, new GeometryFactory());
        return hull.getConvexHull();
    }

    public static void setSrsNameOnCollectionMembers(Node ... geometryNodes) {
        for (Node geomNode : geometryNodes) {
            NodeList members;
            Element geom = (Element)geomNode;
            String geomType = geom.getLocalName();
            String srsName = geom.getAttribute(SRS_NAME);
            if (!geomType.startsWith("Multi") || srsName.isEmpty()) continue;
            String memberType = geomType.substring(5).toLowerCase();
            String expr = String.format("gml:%sMember/* | gml:%<sMembers/*", memberType);
            XPath xpath = XPathFactory.newInstance().newXPath();
            xpath.setNamespaceContext(new GmlNamespaceContext());
            try {
                members = (NodeList)xpath.evaluate(expr, geom, XPathConstants.NODESET);
            }
            catch (XPathExpressionException xpe) {
                throw new RuntimeException(xpe);
            }
            for (int i = 0; i < members.getLength(); ++i) {
                Element member = (Element)members.item(i);
                if (!member.getAttribute(SRS_NAME).isEmpty()) continue;
                member.setAttribute(SRS_NAME, srsName);
            }
        }
    }

    public static double lengthInMeters(LengthType length) {
        double lengthInMeters;
        String symbol;
        String uom = length.getUom();
        String string = symbol = uom.indexOf(35) >= 0 ? uom.substring(uom.indexOf(35) + 1) : uom;
        if (symbol.equals("m")) {
            lengthInMeters = length.getValue();
        } else if (symbol.equals("km")) {
            lengthInMeters = length.getValue() * 1000.0;
        } else if (symbol.equals("M") | symbol.equals("NM") | symbol.equals("[nmi_i]")) {
            lengthInMeters = length.getValue() * 1852.0;
        } else if (symbol.equals("mi")) {
            lengthInMeters = length.getValue() * 1609.34;
        } else {
            throw new RuntimeException("Unrecognized unit of length: " + uom);
        }
        return lengthInMeters;
    }

    public static void extractCoordinatesFromPosList(List<Double> tupleList, int crsDim, List<Coordinate> coords) {
        if (null == tupleList || tupleList.isEmpty()) {
            return;
        }
        Double[] values = tupleList.toArray(new Double[0]);
        for (int i = 0; i < values.length; i += crsDim) {
            coords.add(new Coordinate(values[i].doubleValue(), values[i + 1].doubleValue()));
        }
    }

    public static int minCurveSegmentLength(String segmentTypeName) {
        int minLength = 2;
        if (segmentTypeName.endsWith("ByCenterPoint")) {
            minLength = 1;
        } else if (segmentTypeName.equals("ArcString") || segmentTypeName.equals("Arc") || segmentTypeName.equals("Circle")) {
            minLength = 3;
        }
        return minLength;
    }

    public static String findCRSReference(Element geom) {
        String srsName;
        String expr = "./ancestor-or-self::*[@srsName][1]/@srsName";
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            srsName = (String)xpath.evaluate(expr, geom, XPathConstants.STRING);
            if (srsName.isEmpty()) {
                NodeNamespaceContext nsContext = new NodeNamespaceContext(geom);
                String gmlPrefix = nsContext.getPrefix(GML_NS);
                expr = String.format("./ancestor::*[%s:boundedBy][1]/%1$s:boundedBy/%1$s:Envelope/@srsName", gmlPrefix);
                xpath.setNamespaceContext(nsContext);
                srsName = (String)xpath.evaluate(expr, geom, XPathConstants.STRING);
            }
        }
        catch (XPathExpressionException xpe) {
            throw new RuntimeException(xpe);
        }
        if (!srsName.isEmpty()) {
            geom.setAttribute(SRS_NAME, srsName);
        }
        return srsName;
    }

    public static boolean hasChildElement(Element elem, String namespace, String localName) {
        return elem.getElementsByTagNameNS(namespace, localName).getLength() > 0;
    }

    public static AbstractGeometry unmarshalGMLGeometry(URI uriRef) throws JAXBException {
        if (!uriRef.isAbsolute()) {
            throw new IllegalArgumentException("Not an absolute URI: " + uriRef);
        }
        StreamSource source = new StreamSource(uriRef.toString());
        return GmlUtils.unmarshalGMLGeometry(source);
    }

    public static AbstractGeometry unmarshalGMLGeometry(Source source) throws JAXBException {
        JAXBElement gmlGeom = (JAXBElement)GML_UNMARSHALLER.unmarshal(source);
        return (AbstractGeometry)gmlGeom.getValue();
    }

    public static LineString buildLineString(Curve gmlCurve) {
        CurveCoordinateListFactory coordFactory = new CurveCoordinateListFactory();
        List<Coordinate> coordList = coordFactory.createCoordinateList((AbstractGeometry)gmlCurve);
        GeodesyUtils.removeConsecutiveDuplicates(coordList, 1);
        Coordinate[] coords = coordList.toArray(new Coordinate[coordList.size()]);
        GeometryFactory jtsFactory = new GeometryFactory();
        LineString line = jtsFactory.createLineString(coords);
        CoordinateReferenceSystem crs = null;
        try {
            crs = CRS.decode((String)GeodesyUtils.convertSRSNameToURN(gmlCurve.getSrsName()));
            JTS.setCRS((Geometry)line, (CoordinateReferenceSystem)crs);
        }
        catch (FactoryException e) {
            throw new RuntimeException(e.getMessage());
        }
        return line;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TemporalGeometricPrimitive gmlToTemporalGeometricPrimitive(Element gmlTime) {
        ArrayList<ZonedDateTime> instants = new ArrayList<ZonedDateTime>();
        String frame = gmlTime.getAttribute("frame");
        if (gmlTime.getLocalName().equals("TimeInstant")) {
            Element timePosition = (Element)gmlTime.getElementsByTagNameNS(GML_NS, "timePosition").item(0);
            if (!timePosition.getAttribute("frame").isEmpty()) {
                frame = timePosition.getAttribute("frame");
            }
            if (!frame.isEmpty()) {
                if (!frame.contains("8601")) throw new RuntimeException("Unsupported temporal reference frame: " + frame);
            }
            try {
                instants.add(ZonedDateTime.parse(timePosition.getTextContent(), DateTimeFormatter.ISO_DATE_TIME));
            }
            catch (DateTimeParseException dateTimeParseException) {}
        } else {
            Element beginPosition = (Element)gmlTime.getElementsByTagNameNS(GML_NS, "beginPosition").item(0);
            instants.add(ZonedDateTime.parse(beginPosition.getTextContent(), DateTimeFormatter.ISO_DATE_TIME));
            Element endPosition = (Element)gmlTime.getElementsByTagNameNS(GML_NS, "endPosition").item(0);
            instants.add(ZonedDateTime.parse(endPosition.getTextContent(), DateTimeFormatter.ISO_DATE_TIME));
        }
        DefaultTemporalFactory tmFactory = new DefaultTemporalFactory();
        Instant timePrimitive = null;
        if (instants.size() == 1) {
            return tmFactory.createInstant((Position)new DefaultPosition(Date.from(((ZonedDateTime)instants.get(0)).toInstant())));
        }
        Instant beginInstant = tmFactory.createInstant((Position)new DefaultPosition(Date.from(((ZonedDateTime)instants.get(0)).toInstant())));
        Instant endInstant = tmFactory.createInstant((Position)new DefaultPosition(Date.from(((ZonedDateTime)instants.get(1)).toInstant())));
        return tmFactory.createPeriod(beginInstant, endInstant);
    }

    public static class NodeNamespaceContext
    implements NamespaceContext {
        private Node sourceNode;

        public NodeNamespaceContext(Node node) {
            this.sourceNode = node;
        }

        @Override
        public String getNamespaceURI(String prefix) {
            if (prefix.equals("")) {
                return this.sourceNode.lookupNamespaceURI(null);
            }
            return this.sourceNode.lookupNamespaceURI(prefix);
        }

        @Override
        public String getPrefix(String namespaceURI) {
            return this.sourceNode.lookupPrefix(namespaceURI);
        }

        @Override
        public Iterator<String> getPrefixes(String namespaceURI) {
            return null;
        }
    }

    public static class GmlNamespaceContext
    implements NamespaceContext {
        @Override
        public String getNamespaceURI(String prefix) {
            String nsName = prefix.equals("gml") ? GmlUtils.GML_NS : "";
            return nsName;
        }

        @Override
        public String getPrefix(String namespaceURI) {
            String prefix = null;
            if (namespaceURI.equals(GmlUtils.GML_NS)) {
                prefix = "gml";
            }
            return prefix;
        }

        @Override
        public Iterator<String> getPrefixes(String namespaceURI) {
            return null;
        }
    }
}

