/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing;

import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.text.Format;
import javax.measure.unit.NonSI;
import org.geotoolkit.geometry.DirectPosition2D;
import org.geotoolkit.geometry.TransformedDirectPosition;
import org.geotoolkit.io.TableWriter;
import org.geotoolkit.measure.Angle;
import org.geotoolkit.measure.CoordinateFormat;
import org.geotoolkit.measure.Latitude;
import org.geotoolkit.measure.Longitude;
import org.geotoolkit.referencing.CRS;
import org.geotoolkit.referencing.crs.DefaultGeographicCRS;
import org.geotoolkit.referencing.cs.DefaultEllipsoidalCS;
import org.geotoolkit.referencing.datum.DefaultEllipsoid;
import org.geotoolkit.referencing.datum.DefaultGeodeticDatum;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Vocabulary;
import org.geotoolkit.util.NullArgumentException;
import org.geotoolkit.util.logging.Logging;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.coordinate.Position;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.operation.TransformException;

public class GeodeticCalculator {
    private static final double TOLERANCE_0 = 5.0E-15;
    private static final double TOLERANCE_1 = 5.0E-14;
    private static final double TOLERANCE_2 = 5.0E-13;
    private static final double TOLERANCE_3 = 0.007;
    private static final double TOLERANCE_CHECK = 1.0E-8;
    private final TransformedDirectPosition userToGeodetic;
    private CoordinateReferenceSystem coordinateReferenceSystem;
    private GeographicCRS geographicCRS;
    private final Ellipsoid ellipsoid;
    private final double semiMajorAxis;
    private final double semiMinorAxis;
    private final double eccentricitySquared;
    private final double maxOrthodromicDistance;
    private final double A;
    private final double B;
    private final double C;
    private final double D;
    private final double E;
    private final double F;
    private final double fo;
    private final double f;
    private final double f2;
    private final double f3;
    private final double f4;
    private final double T1;
    private final double T2;
    private final double T4;
    private final double T6;
    private final double a01;
    private final double a02;
    private final double a03;
    private final double a21;
    private final double a22;
    private final double a23;
    private final double a42;
    private final double a43;
    private final double a63;
    private double lat1;
    private double long1;
    private double lat2;
    private double long2;
    private double distance;
    private double azimuth;
    private boolean destinationValid;
    private boolean directionValid;
    private boolean antipodal;

    public GeodeticCalculator() {
        this(DefaultEllipsoid.WGS84);
    }

    public GeodeticCalculator(Ellipsoid ellipsoid) {
        this(ellipsoid, null);
    }

    public GeodeticCalculator(CoordinateReferenceSystem coordinateReferenceSystem) {
        this(CRS.getEllipsoid(coordinateReferenceSystem), coordinateReferenceSystem);
    }

    private GeodeticCalculator(Ellipsoid ellipsoid, CoordinateReferenceSystem coordinateReferenceSystem) {
        if (ellipsoid == null) {
            throw new NullArgumentException(Errors.format((int)172, (Object)"ellipsoid"));
        }
        this.ellipsoid = ellipsoid;
        this.semiMajorAxis = ellipsoid.getSemiMajorAxis();
        this.semiMinorAxis = ellipsoid.getSemiMinorAxis();
        if (coordinateReferenceSystem != null) {
            this.coordinateReferenceSystem = coordinateReferenceSystem;
            this.geographicCRS = GeodeticCalculator.getGeographicCRS(coordinateReferenceSystem);
            this.userToGeodetic = new TransformedDirectPosition(coordinateReferenceSystem, this.geographicCRS, null);
        } else {
            this.userToGeodetic = null;
        }
        this.f = (this.semiMajorAxis - this.semiMinorAxis) / this.semiMajorAxis;
        this.fo = 1.0 - this.f;
        this.f2 = this.f * this.f;
        this.f3 = this.f * this.f2;
        this.f4 = this.f * this.f3;
        double d = this.eccentricitySquared = this.f * (2.0 - this.f);
        double d2 = d * d;
        double d3 = d2 * d;
        double d4 = d3 * d;
        double d5 = d4 * d;
        this.A = 1.0 + 0.75 * d + 0.703125 * d2 + 0.68359375 * d3 + 0.67291259765625 * d4 + 0.6661834716796875 * d5;
        this.B = 0.75 * d + 0.9375 * d2 + 1.025390625 * d3 + 1.07666015625 * d4 + 1.1103057861328125 * d5;
        this.C = 0.234375 * d2 + 0.41015625 * d3 + 0.538330078125 * d4 + 0.63446044921875 * d5;
        this.D = 0.068359375 * d3 + 0.15380859375 * d4 + 0.23792266845703125 * d5;
        this.E = 0.01922607421875 * d4 + 0.0528717041015625 * d5;
        this.F = 0.00528717041015625 * d5;
        this.maxOrthodromicDistance = this.semiMajorAxis * (1.0 - d) * Math.PI * this.A - 1.0;
        this.T1 = 1.0;
        this.T2 = -0.25 * this.f * (1.0 + this.f + this.f2);
        this.T4 = 0.1875 * this.f2 * (1.0 + 2.25 * this.f);
        this.T6 = 0.1953125 * this.f3;
        double d6 = this.f3 * (1.0 + 2.25 * this.f);
        this.a01 = -this.f2 * (1.0 + this.f + this.f2) / 4.0;
        this.a02 = 0.1875 * d6;
        this.a03 = -0.1953125 * this.f4;
        this.a21 = -this.a01;
        this.a22 = -0.25 * d6;
        this.a23 = 0.29296875 * this.f4;
        this.a42 = 0.03125 * d6;
        this.a43 = 0.05859375 * this.f4;
        this.a63 = 5.0 * this.f4 / 768.0;
    }

    private static GeographicCRS getGeographicCRS(CoordinateReferenceSystem coordinateReferenceSystem) {
        IdentifiedObject identifiedObject;
        if (coordinateReferenceSystem instanceof GeographicCRS && (identifiedObject = coordinateReferenceSystem.getCoordinateSystem()).getDimension() == 2 && GeodeticCalculator.isStandard(identifiedObject.getAxis(0), AxisDirection.EAST) && GeodeticCalculator.isStandard(identifiedObject.getAxis(1), AxisDirection.NORTH)) {
            return (GeographicCRS)coordinateReferenceSystem;
        }
        identifiedObject = CRS.getDatum(coordinateReferenceSystem);
        if (identifiedObject instanceof GeodeticDatum) {
            return new DefaultGeographicCRS("Geodetic", (GeodeticDatum)identifiedObject, (EllipsoidalCS)DefaultEllipsoidalCS.GEODETIC_2D);
        }
        if (coordinateReferenceSystem instanceof CompoundCRS) {
            for (CoordinateReferenceSystem coordinateReferenceSystem2 : ((CompoundCRS)coordinateReferenceSystem).getComponents()) {
                GeographicCRS geographicCRS = GeodeticCalculator.getGeographicCRS(coordinateReferenceSystem2);
                if (geographicCRS == null) continue;
                return geographicCRS;
            }
        }
        throw new IllegalArgumentException(Errors.format((int)77));
    }

    private static boolean isStandard(CoordinateSystemAxis coordinateSystemAxis, AxisDirection axisDirection) {
        return axisDirection.equals(coordinateSystemAxis.getDirection()) && NonSI.DEGREE_ANGLE.equals(coordinateSystemAxis.getUnit());
    }

    private static double castToAngleRange(double d) {
        return d - Math.PI * 2 * Math.floor(d / (Math.PI * 2) + 0.5);
    }

    private static double checkLatitude(double d) throws IllegalArgumentException {
        if (d >= -90.0 && d <= 90.0) {
            return Math.toRadians(d);
        }
        throw new IllegalArgumentException(Errors.format((int)103, (Object)new Latitude(d)));
    }

    private static double checkLongitude(double d) throws IllegalArgumentException {
        if (d >= -180.0 && d <= 180.0) {
            return Math.toRadians(d);
        }
        throw new IllegalArgumentException(Errors.format((int)106, (Object)new Longitude(d)));
    }

    private static double checkAzimuth(double d) throws IllegalArgumentException {
        if (d >= -180.0 && d <= 180.0) {
            return Math.toRadians(d);
        }
        throw new IllegalArgumentException(Errors.format((int)4, (Object)new Longitude(d)));
    }

    private void checkOrthodromicDistance(double d) throws IllegalArgumentException {
        if (!(d >= 0.0) || !(d <= this.maxOrthodromicDistance)) {
            throw new IllegalArgumentException(Errors.format((int)52, (Object)d, (Object)0.0, (Object)this.maxOrthodromicDistance, this.ellipsoid.getAxisUnit()));
        }
    }

    private static void checkNumberOfPoints(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException(Errors.format((int)73, (Object)"numberOfPoints", (Object)n));
        }
    }

    private String getNoConvergenceErrorMessage() {
        CoordinateFormat coordinateFormat = new CoordinateFormat();
        return Errors.format((int)153, (Object)GeodeticCalculator.format(coordinateFormat, this.long1, this.lat1), (Object)GeodeticCalculator.format(coordinateFormat, this.long2, this.lat2));
    }

    private static String format(Format format, double d, double d2) {
        return format.format(new DirectPosition2D(Math.toDegrees(d), Math.toDegrees(d2)));
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        if (this.coordinateReferenceSystem == null) {
            this.coordinateReferenceSystem = this.getGeographicCRS();
        }
        return this.coordinateReferenceSystem;
    }

    public GeographicCRS getGeographicCRS() {
        if (this.geographicCRS == null) {
            String string = Vocabulary.format((int)121);
            this.geographicCRS = new DefaultGeographicCRS(string, (GeodeticDatum)new DefaultGeodeticDatum(string, this.getEllipsoid()), (EllipsoidalCS)DefaultEllipsoidalCS.GEODETIC_2D);
        }
        return this.geographicCRS;
    }

    public Ellipsoid getEllipsoid() {
        return this.ellipsoid;
    }

    public void setStartingGeographicPoint(double d, double d2) throws IllegalArgumentException {
        d = GeodeticCalculator.checkLongitude(d);
        d2 = GeodeticCalculator.checkLatitude(d2);
        this.long1 = d;
        this.lat1 = d2;
        this.destinationValid = false;
        this.directionValid = false;
    }

    public void setStartingGeographicPoint(Point2D point2D) throws IllegalArgumentException {
        this.setStartingGeographicPoint(point2D.getX(), point2D.getY());
    }

    public void setStartingPosition(Position position) throws TransformException {
        DirectPosition directPosition = position.getDirectPosition();
        if (this.userToGeodetic != null) {
            this.userToGeodetic.transform(directPosition);
            directPosition = this.userToGeodetic;
        }
        this.setStartingGeographicPoint(directPosition.getOrdinate(0), directPosition.getOrdinate(1));
    }

    public Point2D getStartingGeographicPoint() {
        return new Point2D.Double(Math.toDegrees(this.long1), Math.toDegrees(this.lat1));
    }

    public DirectPosition getStartingPosition() throws TransformException {
        DirectPosition directPosition = this.userToGeodetic;
        if (directPosition == null) {
            directPosition = new DirectPosition2D();
        }
        directPosition.setOrdinate(0, Math.toDegrees(this.long1));
        directPosition.setOrdinate(1, Math.toDegrees(this.lat1));
        if (this.userToGeodetic != null) {
            directPosition = this.userToGeodetic.inverseTransform();
        }
        return directPosition;
    }

    public void setDestinationGeographicPoint(double d, double d2) throws IllegalArgumentException {
        d = GeodeticCalculator.checkLongitude(d);
        d2 = GeodeticCalculator.checkLatitude(d2);
        this.long2 = d;
        this.lat2 = d2;
        this.destinationValid = true;
        this.directionValid = false;
    }

    public void setDestinationGeographicPoint(Point2D point2D) throws IllegalArgumentException {
        this.setDestinationGeographicPoint(point2D.getX(), point2D.getY());
    }

    public void setDestinationPosition(Position position) throws TransformException {
        DirectPosition directPosition = position.getDirectPosition();
        if (this.userToGeodetic != null) {
            this.userToGeodetic.transform(directPosition);
            directPosition = this.userToGeodetic;
        }
        this.setDestinationGeographicPoint(directPosition.getOrdinate(0), directPosition.getOrdinate(1));
    }

    public Point2D getDestinationGeographicPoint() throws IllegalStateException {
        if (!this.destinationValid) {
            this.computeDestinationPoint();
        }
        return new Point2D.Double(Math.toDegrees(this.long2), Math.toDegrees(this.lat2));
    }

    public DirectPosition getDestinationPosition() throws TransformException {
        DirectPosition directPosition;
        if (!this.destinationValid) {
            this.computeDestinationPoint();
        }
        if ((directPosition = this.userToGeodetic) == null) {
            directPosition = new DirectPosition2D();
        }
        directPosition.setOrdinate(0, Math.toDegrees(this.long2));
        directPosition.setOrdinate(1, Math.toDegrees(this.lat2));
        if (this.userToGeodetic != null) {
            directPosition = this.userToGeodetic.inverseTransform();
        }
        return directPosition;
    }

    public void setDirection(double d, double d2) throws IllegalArgumentException {
        d = GeodeticCalculator.checkAzimuth(d);
        this.checkOrthodromicDistance(d2);
        this.azimuth = d;
        this.distance = d2;
        this.destinationValid = false;
        this.directionValid = true;
    }

    public double getAzimuth() throws IllegalStateException {
        if (!this.directionValid) {
            this.computeDirection();
            if (this.antipodal) {
                Logging.getLogger(GeodeticCalculator.class).warning("Azimuth is inaccurate for antipodal points.");
            }
        }
        return Math.toDegrees(this.azimuth);
    }

    public double getOrthodromicDistance() throws IllegalStateException {
        if (!this.directionValid) {
            this.computeDirection();
            if (this.antipodal) {
                if (this.ellipsoid instanceof DefaultEllipsoid) {
                    return ((DefaultEllipsoid)this.ellipsoid).orthodromicDistance(Math.toDegrees(this.long1), Math.toDegrees(this.lat1), Math.toDegrees(this.long2), Math.toDegrees(this.lat2));
                }
            } else assert (this.checkOrthodromicDistance()) : this;
        }
        return this.distance;
    }

    private boolean checkOrthodromicDistance() {
        if (this.ellipsoid instanceof DefaultEllipsoid) {
            DefaultEllipsoid defaultEllipsoid = (DefaultEllipsoid)this.ellipsoid;
            double d = defaultEllipsoid.orthodromicDistance(Math.toDegrees(this.long1), Math.toDegrees(this.lat1), Math.toDegrees(this.long2), Math.toDegrees(this.lat2));
            return (d = Math.abs(this.distance - d)) <= (this.distance + 1.0) * 1.0E-8;
        }
        return true;
    }

    private void computeDestinationPoint() throws IllegalStateException {
        double d;
        double d2;
        double d3;
        double d4;
        if (!this.directionValid) {
            throw new IllegalStateException(Errors.format((int)50));
        }
        double d5 = this.lat1;
        double d6 = this.long1;
        double d7 = this.azimuth;
        double d8 = this.distance;
        double d9 = this.fo * Math.sin(d5) / Math.cos(d5);
        double d10 = Math.sin(d7);
        double d11 = Math.cos(d7);
        double d12 = d11 != 0.0 ? Math.atan2(d9, d11) * 2.0 : 0.0;
        double d13 = 1.0 / Math.sqrt(d9 * d9 + 1.0);
        double d14 = d9 * d13;
        double d15 = d13 * d10;
        double d16 = 1.0 - d15 * d15;
        double d17 = Math.sqrt((1.0 / this.fo / this.fo - 1.0) * d16 + 1.0) + 1.0;
        d17 = (d17 - 2.0) / d17;
        double d18 = 1.0 - d17;
        d18 = (d17 * d17 / 4.0 + 1.0) / d18;
        double d19 = (0.375 * d17 * d17 - 1.0) * d17;
        double d20 = d9 = d8 / this.fo / this.semiMajorAxis / d18;
        do {
            d4 = Math.sin(d20);
            d2 = Math.cos(d20);
            d3 = Math.cos(d12 + d20);
            d = d3 * d3 * 2.0 - 1.0;
            d18 = d20;
            d17 = d * d2;
            d20 = d + d - 1.0;
        } while (Math.abs((d20 = (((d4 * d4 * 4.0 - 3.0) * d20 * d3 * d19 / 6.0 + d17) * d19 / 4.0 - d3) * d4 * d19 + d9) - d18) > 5.0E-14);
        d12 = d13 * d2 * d11 - d14 * d4;
        d18 = this.fo * Math.hypot(d15, d12);
        d19 = d14 * d2 + d13 * d4 * d11;
        this.lat2 = Math.atan2(d19, d18);
        d18 = d13 * d2 - d14 * d4 * d11;
        d17 = Math.atan2(d4 * d10, d18);
        d18 = ((-3.0 * d16 + 4.0) * this.f + 4.0) * d16 * this.f / 16.0;
        d19 = ((d * d2 * d18 + d3) * d4 * d18 + d20) * d15;
        this.long2 = d6 + d17 - (1.0 - d18) * d19 * this.f;
        this.long2 = GeodeticCalculator.castToAngleRange(this.long2);
        this.destinationValid = true;
    }

    public double getMeridianArcLength(double d, double d2) {
        return this.getMeridianArcLengthRadians(GeodeticCalculator.checkLatitude(d), GeodeticCalculator.checkLatitude(d2));
    }

    private double getMeridianArcLengthRadians(double d, double d2) {
        double d3 = Math.abs(d);
        double d4 = Math.abs(d2);
        double d5 = d2 - d;
        if (d3 > 5.0E-15 || d4 <= 1.5707963267948915 || d4 >= 1.5707963267949017) {
            double d6 = Math.sin(d2 * 2.0) - Math.sin(d * 2.0);
            double d7 = Math.sin(d2 * 4.0) - Math.sin(d * 4.0);
            double d8 = Math.sin(d2 * 6.0) - Math.sin(d * 6.0);
            double d9 = Math.sin(d2 * 8.0) - Math.sin(d * 8.0);
            double d10 = Math.sin(d2 * 10.0) - Math.sin(d * 10.0);
            d4 = -d6 * this.B / 2.0 + d7 * this.C / 4.0 - d8 * this.D / 6.0 + d9 * this.E / 8.0 - d10 * this.F / 10.0;
        }
        d3 = d5 * this.A;
        return Math.abs(this.semiMajorAxis * (1.0 - this.eccentricitySquared) * (d3 + d4));
    }

    private void computeDirection() throws IllegalStateException {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        double d9;
        double d10;
        double d11;
        double d12;
        double d13;
        double d14;
        double d15;
        double d16;
        double d17;
        double d18;
        double d19;
        double d20;
        if (!this.destinationValid) {
            throw new IllegalStateException(Errors.format((int)49));
        }
        double d21 = this.long1;
        double d22 = this.lat1;
        double d23 = this.long2;
        double d24 = this.lat2;
        double d25 = GeodeticCalculator.castToAngleRange(d23 - d21);
        double d26 = Math.abs(d25);
        if (d26 < 5.0E-14) {
            this.distance = this.getMeridianArcLengthRadians(d22, d24);
            this.azimuth = d24 > d22 ? 0.0 : Math.PI;
            this.directionValid = true;
            this.antipodal = false;
            return;
        }
        this.antipodal = Math.PI - d26 < 0.014 && Math.abs(d22 + d24) < 0.014;
        double d27 = this.eccentricitySquared / (1.0 - this.eccentricitySquared);
        double d28 = Math.PI * this.fo;
        if (d26 >= d28 && d22 < 0.007 && d22 > -0.007 && d24 < 0.007 && d24 > -0.007) {
            double d29;
            double d30;
            double d31;
            double d32;
            double d33;
            double d34 = (Math.PI - d26) / (Math.PI * this.f);
            double d35 = Math.asin(d34);
            int n = 0;
            do {
                if (++n > 8) {
                    throw new ArithmeticException(this.getNoConvergenceErrorMessage());
                }
                d33 = Math.cos(d35);
                d31 = d33 * d33;
                d30 = this.T1 + this.T2 * d31 + this.T4 * d31 * d31 + this.T6 * d31 * d31 * d31;
                d29 = d34 / d30;
                d33 = Math.asin(d29);
                d32 = d35;
                d35 = d33;
            } while (Math.abs(d33 - d32) >= 5.0E-13);
            d31 = d25 < 0.0 ? Math.PI * 2 - d33 : d33;
            this.azimuth = GeodeticCalculator.castToAngleRange(d31);
            d33 = Math.cos(d31);
            d29 = d27 * d33 * d33;
            double d36 = d29 * d29;
            double d37 = d36 * d29;
            double d38 = d37 * d29;
            double d39 = 1.0 + 0.25 * d29 + 0.046875 * d36 + 0.01953125 * d37 + -0.01068115234375 * d38;
            d33 = Math.sin(d31);
            double d40 = this.semiMajorAxis * Math.PI * (1.0 - this.f * Math.abs(d33) * d30 - d39 * this.fo);
            this.distance = this.semiMajorAxis * d26 - d40;
            this.directionValid = true;
            return;
        }
        double d41 = Math.atan(this.fo * Math.sin(d22) / Math.cos(d22));
        double d42 = Math.atan(this.fo * Math.sin(d24) / Math.cos(d24));
        double d43 = Math.sin(d41);
        double d44 = Math.cos(d41);
        double d45 = Math.sin(d42);
        double d46 = Math.cos(d42);
        double d47 = d25;
        int n = 0;
        do {
            if (++n > 12) {
                throw new ArithmeticException(this.getNoConvergenceErrorMessage());
            }
            d19 = Math.cos(d47);
            d18 = Math.sin(d47);
            d17 = d43 * d45 + d44 * d46 * d19;
            d16 = Math.hypot(d18 * d46, d45 * d44 - d43 * d46 * d19);
            d15 = Math.atan2(d16, d17);
            d14 = d44 * d46 * d18 / d16;
            d13 = 1.0 - d14 * d14;
            d12 = d13 * d13;
            d11 = d13 * d12;
            d10 = this.f + this.a01 * d13 + this.a02 * d12 + this.a03 * d11;
            d9 = this.a21 * d13 + this.a22 * d12 + this.a23 * d11;
            d8 = this.a42 * d12 + this.a43 * d11;
            d7 = this.a63 * d11;
            d6 = 0.0;
            if (d13 > 5.0E-15) {
                d6 = -2.0 * d43 * d45 / d13;
            }
            d5 = d17 + d6;
            d4 = 2.0 * d5 * d5 - 1.0;
            d3 = d5 * (4.0 * d5 * d5 - 3.0);
            d2 = 2.0 * d16 * d17;
            d = d16 * (3.0 - 4.0 * d16 * d16);
            double d48 = d14 * (d10 * d15 + d9 * d16 * d5 + d8 * d2 * d4 + d7 * d * d3);
            double d49 = d25 + d48;
            d20 = Math.abs(d49 - d47);
            d47 = d25 + d48;
        } while (d20 >= 5.0E-14);
        d17 = d27 * d13;
        d12 = 1.0 + d17 * (0.25 + d17 * (-0.046875 + d17 * (0.01953125 - d17 * 0.01068115234375)));
        d11 = d17 * (-0.25 + d17 * (0.0625 + d17 * (-0.029296875 + d17 * 0.01708984375)));
        d10 = d17 * d17 * (-0.0078125 + d17 * (0.005859375 - d17 * 0.0042724609375));
        d9 = d17 * d17 * d17 * (-6.510416666666666E-4 + d17 * 8.138020833333334E-4);
        this.distance = this.semiMinorAxis * (d12 * d15 + d11 * d16 * d5 + d10 * d2 * d4 + d9 * d * d3);
        double d50 = d8 = d25 < 0.0 ? 4.71238898038469 : 1.5707963267948966;
        if (Math.abs(d43) >= 5.0E-15 || Math.abs(d45) >= 5.0E-15) {
            d7 = d18 * d46 / (d45 * d44 - d19 * d43 * d46);
            d6 = d14 / d44;
            d8 = Math.atan2(d6, d6 / d7);
        }
        this.azimuth = GeodeticCalculator.castToAngleRange(d8);
        this.directionValid = true;
    }

    public Shape getGeodeticCurve(int n) {
        GeodeticCalculator.checkNumberOfPoints(n);
        if (!this.directionValid) {
            this.computeDirection();
        }
        if (!this.destinationValid) {
            this.computeDestinationPoint();
        }
        double d = this.long2;
        double d2 = this.lat2;
        double d3 = this.distance;
        double d4 = d3 / (double)n;
        GeneralPath generalPath = new GeneralPath(0, n + 1);
        generalPath.moveTo((float)Math.toDegrees(this.long1), (float)Math.toDegrees(this.lat1));
        for (int i = 1; i < n; ++i) {
            this.distance = (double)i * d4;
            this.computeDestinationPoint();
            generalPath.lineTo((float)Math.toDegrees(this.long2), (float)Math.toDegrees(this.lat2));
        }
        this.long2 = d;
        this.lat2 = d2;
        this.distance = d3;
        generalPath.lineTo((float)Math.toDegrees(d), (float)Math.toDegrees(d2));
        return generalPath;
    }

    public Shape getGeodeticCurve() {
        return this.getGeodeticCurve(10);
    }

    private Shape getLoxodromicCurve() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        Vocabulary vocabulary = Vocabulary.getResources(null);
        TableWriter tableWriter = new TableWriter(null, " ");
        if (this.coordinateReferenceSystem != null) {
            tableWriter.write(vocabulary.getLabel(49));
            tableWriter.nextColumn();
            tableWriter.write(this.coordinateReferenceSystem.getName().getCode());
            tableWriter.nextLine();
        }
        if (this.ellipsoid != null) {
            tableWriter.write(vocabulary.getLabel(90));
            tableWriter.nextColumn();
            tableWriter.write(this.ellipsoid.getName().getCode());
            tableWriter.nextLine();
        }
        CoordinateFormat coordinateFormat = new CoordinateFormat();
        Format format = coordinateFormat.getFormat(0);
        tableWriter.write(vocabulary.getLabel(274));
        tableWriter.nextColumn();
        tableWriter.write(GeodeticCalculator.format(coordinateFormat, this.long1, this.lat1));
        tableWriter.nextLine();
        if (this.destinationValid) {
            tableWriter.write(vocabulary.getLabel(290));
            tableWriter.nextColumn();
            tableWriter.write(GeodeticCalculator.format(coordinateFormat, this.long2, this.lat2));
            tableWriter.nextLine();
        }
        if (this.directionValid) {
            tableWriter.write(vocabulary.getLabel(16));
            tableWriter.nextColumn();
            tableWriter.write(format.format(new Angle(Math.toDegrees(this.azimuth))));
            tableWriter.nextLine();
        }
        if (this.directionValid) {
            tableWriter.write(vocabulary.getLabel(218));
            tableWriter.nextColumn();
            tableWriter.write(format.format(this.distance));
            if (this.ellipsoid != null) {
                tableWriter.write(32);
                tableWriter.write(this.ellipsoid.getAxisUnit().toString());
            }
            tableWriter.nextLine();
        }
        return tableWriter.toString();
    }
}

