/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.xml;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.geotoolkit.lang.Static;
import org.geotoolkit.xml.MarshallerPool;

public final class XML
extends Static {
    public static final String LOCALE = "org.geotoolkit.xml.locale";
    public static final String TIMEZONE = "org.geotoolkit.xml.timezone";
    public static final String SCHEMAS = "org.geotoolkit.xml.schemas";
    public static final String GML_VERSION = "org.geotoolkit.gml.version";
    public static final String LINKER = "org.geotoolkit.xml.linker";
    public static final String CONVERTERS = "org.geotoolkit.xml.converters";
    public static final String STRING_SUBSTITUTES = "org.geotoolkit.xml.stringSubstitutes";
    private static final MarshallerPool POOL;

    private XML() {
    }

    public static String marshal(Object object) throws JAXBException {
        StringWriter stringWriter = new StringWriter();
        Marshaller marshaller = POOL.acquireMarshaller();
        marshaller.marshal(object, (Writer)stringWriter);
        POOL.release(marshaller);
        return stringWriter.toString();
    }

    public static void marshal(Object object, OutputStream outputStream) throws JAXBException {
        Marshaller marshaller = POOL.acquireMarshaller();
        marshaller.marshal(object, outputStream);
        POOL.release(marshaller);
    }

    public static void marshal(Object object, File file) throws JAXBException {
        Marshaller marshaller = POOL.acquireMarshaller();
        marshaller.marshal(object, file);
        POOL.release(marshaller);
    }

    public static Object unmarshal(String string) throws JAXBException {
        StringReader stringReader = new StringReader(string);
        Unmarshaller unmarshaller = POOL.acquireUnmarshaller();
        Object object = unmarshaller.unmarshal((Reader)stringReader);
        POOL.release(unmarshaller);
        return object;
    }

    public static Object unmarshal(InputStream inputStream) throws JAXBException {
        Unmarshaller unmarshaller = POOL.acquireUnmarshaller();
        Object object = unmarshaller.unmarshal(inputStream);
        POOL.release(unmarshaller);
        return object;
    }

    public static Object unmarshal(File file) throws JAXBException {
        Unmarshaller unmarshaller = POOL.acquireUnmarshaller();
        Object object = unmarshaller.unmarshal(file);
        POOL.release(unmarshaller);
        return object;
    }

    static {
        try {
            POOL = new MarshallerPool(MarshallerPool.defaultClassesToBeBound());
        }
        catch (JAXBException jAXBException) {
            throw new ExceptionInInitializerError(jAXBException);
        }
    }
}

