/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.sql;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.geotoolkit.internal.sql.Dialect;
import org.geotoolkit.resources.Loggings;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.converter.Classes;
import org.geotoolkit.util.logging.Logging;

public class DefaultDataSource
implements DataSource {
    public static final Logger LOGGER = Logging.getLogger("org.geotoolkit.sql");
    private static final Set<String> DRIVERS = new HashSet<String>();
    public final String url;

    public DefaultDataSource(String string) {
        ArgumentChecks.ensureNonNull("url", string);
        this.url = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Connection log(Connection connection, Class<?> clazz) throws SQLException {
        if (LOGGER.isLoggable(Level.CONFIG)) {
            boolean bl;
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            String string = databaseMetaData.getDriverName();
            Object object = DRIVERS;
            synchronized (object) {
                bl = DRIVERS.add(string);
            }
            if (bl) {
                object = Loggings.format(Level.CONFIG, 31, string, databaseMetaData.getDriverMajorVersion(), databaseMetaData.getDriverMinorVersion());
                ((LogRecord)object).setLoggerName(LOGGER.getName());
                ((LogRecord)object).setSourceClassName(clazz.getName());
                ((LogRecord)object).setSourceMethodName("getConnection");
                LOGGER.log((LogRecord)object);
            }
        }
        return connection;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return DefaultDataSource.log(DriverManager.getConnection(this.url), DefaultDataSource.class);
    }

    @Override
    public Connection getConnection(String string, String string2) throws SQLException {
        return DefaultDataSource.log(DriverManager.getConnection(this.url, string, string2), DefaultDataSource.class);
    }

    @Override
    public PrintWriter getLogWriter() {
        return DriverManager.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) {
        DriverManager.setLogWriter(printWriter);
    }

    @Override
    public int getLoginTimeout() {
        return DriverManager.getLoginTimeout();
    }

    @Override
    public void setLoginTimeout(int n) {
        DriverManager.setLoginTimeout(n);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw new SQLException();
    }

    public void shutdown() {
        Dialect dialect = Dialect.forURL(this.url);
        if (dialect != null) {
            try {
                dialect.shutdown(null, this.url, false);
            }
            catch (SQLException sQLException) {
                Logging.unexpectedException(LOGGER, DefaultDataSource.class, "shutdown", sQLException);
            }
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass() == this.getClass()) {
            DefaultDataSource defaultDataSource = (DefaultDataSource)object;
            return Utilities.equals(this.url, defaultDataSource.url);
        }
        return false;
    }

    public int hashCode() {
        return this.url.hashCode() ^ 0x13FF13DB;
    }

    public String toString() {
        return Classes.getShortClassName(this) + "[\"" + this.url + "\"]";
    }

    @Override
    public Logger getParentLogger() {
        return LOGGER;
    }
}

