/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.overlay;

import com.vividsolutions.jts.algorithm.PointLocator;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geomgraph.Label;
import com.vividsolutions.jts.geomgraph.Node;
import com.vividsolutions.jts.operation.overlay.OverlayOp;
import java.util.ArrayList;
import java.util.List;

public class PointBuilder {
    private OverlayOp op;
    private GeometryFactory geometryFactory;
    private List resultPointList = new ArrayList();

    public PointBuilder(OverlayOp op, GeometryFactory geometryFactory, PointLocator ptLocator) {
        this.op = op;
        this.geometryFactory = geometryFactory;
    }

    public List build(int opCode) {
        this.extractNonCoveredResultNodes(opCode);
        return this.resultPointList;
    }

    private void extractNonCoveredResultNodes(int opCode) {
        for (Node n : this.op.getGraph().getNodes()) {
            Label label;
            if (n.isInResult() || n.isIncidentEdgeInResult() || n.getEdges().getDegree() != 0 && opCode != 1 || !OverlayOp.isResultOfOp(label = n.getLabel(), opCode)) continue;
            this.filterCoveredNodeToPoint(n);
        }
    }

    private void filterCoveredNodeToPoint(Node n) {
        Coordinate coord = n.getCoordinate();
        if (!this.op.isCoveredByLA(coord)) {
            Point pt = this.geometryFactory.createPoint(coord);
            this.resultPointList.add(pt);
        }
    }
}

