/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.factory;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.measure.unit.Unit;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.factory.FactoryRegistryException;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.referencing.IdentifiedObjects;
import org.geotoolkit.referencing.cs.DefaultCoordinateSystemAxis;
import org.geotoolkit.referencing.factory.AuthorityFactoryAdapter;
import org.geotoolkit.referencing.factory.DirectAuthorityFactory;
import org.geotoolkit.referencing.factory.ReferencingFactoryContainer;
import org.geotoolkit.referencing.operation.DefiningConversion;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.collection.BackingStoreException;
import org.geotoolkit.util.collection.WeakHashSet;
import org.geotoolkit.util.collection.XCollections;
import org.geotoolkit.util.converter.Classes;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ImageCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AffineCS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.CylindricalCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.LinearCS;
import org.opengis.referencing.cs.PolarCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.UserDefinedCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.ImageDatum;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.util.FactoryException;

@ThreadSafe
public class TransformedAuthorityFactory
extends AuthorityFactoryAdapter {
    private static final DefaultCoordinateSystemAxis[] RENAMEABLE = new DefaultCoordinateSystemAxis[]{DefaultCoordinateSystemAxis.NORTHING, DefaultCoordinateSystemAxis.SOUTHING, DefaultCoordinateSystemAxis.EASTING, DefaultCoordinateSystemAxis.WESTING};
    private transient CoordinateOperationFactory opFactory;
    private final WeakHashSet<IdentifiedObject> pool = WeakHashSet.newInstance(IdentifiedObject.class);
    private transient ReferencingFactoryContainer factories;

    protected TransformedAuthorityFactory(AuthorityFactory authorityFactory) {
        super(authorityFactory);
    }

    protected TransformedAuthorityFactory(CRSAuthorityFactory cRSAuthorityFactory, CSAuthorityFactory cSAuthorityFactory, DatumAuthorityFactory datumAuthorityFactory, CoordinateOperationAuthorityFactory coordinateOperationAuthorityFactory) {
        super(cRSAuthorityFactory, cSAuthorityFactory, datumAuthorityFactory, coordinateOperationAuthorityFactory);
    }

    protected TransformedAuthorityFactory(String string, Hints hints) throws FactoryRegistryException {
        super(string, hints);
    }

    private ReferencingFactoryContainer getFactoryContainer(boolean bl) {
        this.ensureInitialized();
        AuthorityFactory authorityFactory = this.getFactory(bl ? 0 : 1);
        if (authorityFactory instanceof DirectAuthorityFactory) {
            return ((DirectAuthorityFactory)authorityFactory).factories;
        }
        ReferencingFactoryContainer referencingFactoryContainer = this.factories;
        if (referencingFactoryContainer == null) {
            this.factories = referencingFactoryContainer = ReferencingFactoryContainer.instance(this.dependencyHints());
        }
        return referencingFactoryContainer;
    }

    @Override
    protected Unit<?> replace(Unit<?> unit) throws FactoryException {
        return super.replace(unit);
    }

    protected AxisDirection replace(AxisDirection axisDirection) throws FactoryException {
        return axisDirection;
    }

    @Override
    protected CoordinateSystemAxis replace(CoordinateSystemAxis object) throws FactoryException {
        Object object2;
        Object object3;
        boolean bl;
        AxisDirection axisDirection = object.getDirection();
        AxisDirection axisDirection2 = this.replace(axisDirection);
        Unit<?> unit = object.getUnit();
        Unit<?> unit2 = this.replace(unit);
        boolean bl2 = bl = !axisDirection.equals(axisDirection2);
        if (bl) {
            object3 = object.getName().getCode();
            block0: for (int i = 0; i < RENAMEABLE.length; ++i) {
                if (!RENAMEABLE[i].nameMatches((String)object3)) continue;
                for (i = 0; i < RENAMEABLE.length; ++i) {
                    object2 = RENAMEABLE[i];
                    if (!axisDirection2.equals(object2.getDirection())) continue;
                    object = object2;
                    unit = object.getUnit();
                    bl = false;
                    break block0;
                }
                break;
            }
        }
        if (bl || !unit.equals(unit2)) {
            object3 = this.getFactoryContainer(false);
            CSFactory cSFactory = ((ReferencingFactoryContainer)object3).getCSFactory();
            object2 = this.getProperties((IdentifiedObject)object);
            object = cSFactory.createCoordinateSystemAxis((Map<String, ?>)object2, object.getAbbreviation(), axisDirection2, unit2);
            object = (CoordinateSystemAxis)this.pool.unique(object);
        }
        return object;
    }

    protected CoordinateSystem replace(CoordinateSystem coordinateSystem) throws FactoryException {
        int n;
        int n2 = coordinateSystem.getDimension();
        CoordinateSystemAxis[] coordinateSystemAxisArray = new CoordinateSystemAxis[n2];
        for (n = 0; n < n2; ++n) {
            coordinateSystemAxisArray[n] = this.replace(coordinateSystem.getAxis(n));
        }
        if (this instanceof Comparator) {
            Arrays.sort(coordinateSystemAxisArray, (Comparator)((Object)this));
        }
        for (n = 0; n < n2; ++n) {
            if (coordinateSystemAxisArray[n].equals(coordinateSystem.getAxis(n))) continue;
            Class<?> clazz = coordinateSystem.getClass();
            CoordinateSystem coordinateSystem2 = this.createCS(clazz, this.getProperties(coordinateSystem), coordinateSystemAxisArray);
            assert (Classes.implementSameInterfaces(clazz, coordinateSystem2.getClass(), CoordinateSystem.class));
            return (CoordinateSystem)this.pool.unique((Object)coordinateSystem2);
        }
        return coordinateSystem;
    }

    protected Datum replace(Datum datum) throws FactoryException {
        return super.replace(datum);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected CoordinateReferenceSystem replace(CoordinateReferenceSystem coordinateReferenceSystem) throws FactoryException {
        void var7_31;
        boolean bl;
        Datum datum;
        Datum datum2;
        CoordinateSystem coordinateSystem = coordinateReferenceSystem.getCoordinateSystem();
        CoordinateSystem coordinateSystem2 = this.replace(coordinateSystem);
        if (coordinateReferenceSystem instanceof SingleCRS) {
            datum2 = ((SingleCRS)coordinateReferenceSystem).getDatum();
            datum = this.replace(datum2);
        } else {
            datum2 = null;
            datum = null;
        }
        boolean bl2 = bl = Utilities.equals((Object)coordinateSystem2, (Object)coordinateSystem) && Utilities.equals((Object)datum, (Object)datum2);
        if (coordinateReferenceSystem instanceof GeneralDerivedCRS) {
            GeneralDerivedCRS generalDerivedCRS = (GeneralDerivedCRS)coordinateReferenceSystem;
            CoordinateReferenceSystem coordinateReferenceSystem2 = generalDerivedCRS.getBaseCRS();
            CoordinateReferenceSystem coordinateReferenceSystem3 = this.replace(coordinateReferenceSystem2);
            if (bl && Utilities.equals((Object)coordinateReferenceSystem3, (Object)coordinateReferenceSystem2)) {
                return coordinateReferenceSystem;
            }
            Map<String, ?> map = this.getProperties(coordinateReferenceSystem);
            ReferencingFactoryContainer referencingFactoryContainer = this.getFactoryContainer(true);
            CRSFactory cRSFactory = referencingFactoryContainer.getCRSFactory();
            Conversion conversion = generalDerivedCRS.getConversionFromBase();
            conversion = new DefiningConversion(this.getProperties(conversion), conversion.getMethod(), conversion.getParameterValues());
            if (!(coordinateReferenceSystem instanceof ProjectedCRS)) throw new FactoryException(Errors.format((int)238, (Object)coordinateReferenceSystem.getName().getCode()));
            ProjectedCRS projectedCRS = cRSFactory.createProjectedCRS(map, (GeographicCRS)coordinateReferenceSystem3, conversion, (CartesianCS)coordinateSystem2);
            return (CoordinateReferenceSystem)this.pool.unique((Object)var7_31);
        } else {
            if (bl) {
                return coordinateReferenceSystem;
            }
            Map<String, ?> map = this.getProperties(coordinateReferenceSystem);
            ReferencingFactoryContainer referencingFactoryContainer = this.getFactoryContainer(true);
            CRSFactory cRSFactory = referencingFactoryContainer.getCRSFactory();
            if (coordinateReferenceSystem instanceof GeographicCRS) {
                GeographicCRS geographicCRS = cRSFactory.createGeographicCRS(map, (GeodeticDatum)datum, (EllipsoidalCS)coordinateSystem2);
                return (CoordinateReferenceSystem)this.pool.unique((Object)var7_31);
            } else if (coordinateReferenceSystem instanceof GeocentricCRS) {
                GeodeticDatum geodeticDatum = (GeodeticDatum)datum;
                if (coordinateSystem2 instanceof CartesianCS) {
                    GeocentricCRS geocentricCRS = cRSFactory.createGeocentricCRS(map, geodeticDatum, (CartesianCS)coordinateSystem2);
                    return (CoordinateReferenceSystem)this.pool.unique((Object)var7_31);
                } else {
                    GeocentricCRS geocentricCRS = cRSFactory.createGeocentricCRS(map, geodeticDatum, (SphericalCS)coordinateSystem2);
                }
                return (CoordinateReferenceSystem)this.pool.unique((Object)var7_31);
            } else if (coordinateReferenceSystem instanceof VerticalCRS) {
                VerticalCRS verticalCRS = cRSFactory.createVerticalCRS(map, (VerticalDatum)datum, (VerticalCS)coordinateSystem2);
                return (CoordinateReferenceSystem)this.pool.unique((Object)var7_31);
            } else if (coordinateReferenceSystem instanceof TemporalCRS) {
                TemporalCRS temporalCRS = cRSFactory.createTemporalCRS(map, (TemporalDatum)datum, (TimeCS)coordinateSystem2);
                return (CoordinateReferenceSystem)this.pool.unique((Object)var7_31);
            } else if (coordinateReferenceSystem instanceof ImageCRS) {
                ImageCRS imageCRS = cRSFactory.createImageCRS(map, (ImageDatum)datum, (AffineCS)coordinateSystem2);
                return (CoordinateReferenceSystem)this.pool.unique((Object)var7_31);
            } else if (coordinateReferenceSystem instanceof EngineeringCRS) {
                EngineeringCRS engineeringCRS = cRSFactory.createEngineeringCRS(map, (EngineeringDatum)datum, coordinateSystem2);
                return (CoordinateReferenceSystem)this.pool.unique((Object)var7_31);
            } else {
                if (!(coordinateReferenceSystem instanceof CompoundCRS)) throw new FactoryException(Errors.format((int)238, (Object)coordinateReferenceSystem.getName().getCode()));
                List<CoordinateReferenceSystem> list = ((CompoundCRS)coordinateReferenceSystem).getComponents();
                CoordinateReferenceSystem[] coordinateReferenceSystemArray = new CoordinateReferenceSystem[list.size()];
                for (int i = 0; i < coordinateReferenceSystemArray.length; ++i) {
                    coordinateReferenceSystemArray[i] = this.replace(list.get(i));
                }
                CompoundCRS compoundCRS = cRSFactory.createCompoundCRS(map, coordinateReferenceSystemArray);
            }
        }
        return (CoordinateReferenceSystem)this.pool.unique((Object)var7_31);
    }

    protected CoordinateOperation replace(CoordinateOperation coordinateOperation) throws FactoryException {
        CoordinateReferenceSystem coordinateReferenceSystem;
        CoordinateReferenceSystem coordinateReferenceSystem2 = coordinateOperation.getSourceCRS();
        CoordinateReferenceSystem coordinateReferenceSystem3 = coordinateOperation.getTargetCRS();
        CoordinateReferenceSystem coordinateReferenceSystem4 = coordinateReferenceSystem2 != null ? this.replace(coordinateReferenceSystem2) : null;
        CoordinateReferenceSystem coordinateReferenceSystem5 = coordinateReferenceSystem = coordinateReferenceSystem3 != null ? this.replace(coordinateReferenceSystem3) : null;
        if (Utilities.equals((Object)coordinateReferenceSystem2, (Object)coordinateReferenceSystem4) && Utilities.equals((Object)coordinateReferenceSystem3, (Object)coordinateReferenceSystem)) {
            return coordinateOperation;
        }
        if (this.opFactory == null) {
            this.opFactory = this.getCoordinateOperationFactory();
        }
        return (CoordinateOperation)this.pool.unique((Object)this.opFactory.createOperation(coordinateReferenceSystem4, coordinateReferenceSystem));
    }

    private CoordinateSystem createCS(Class<? extends CoordinateSystem> clazz, Map<String, ?> map, CoordinateSystemAxis[] coordinateSystemAxisArray) throws FactoryException {
        int n = coordinateSystemAxisArray.length;
        ReferencingFactoryContainer referencingFactoryContainer = this.getFactoryContainer(false);
        CSFactory cSFactory = referencingFactoryContainer.getCSFactory();
        if (CartesianCS.class.isAssignableFrom(clazz)) {
            switch (n) {
                case 2: {
                    return cSFactory.createCartesianCS(map, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1]);
                }
                case 3: {
                    return cSFactory.createCartesianCS(map, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1], coordinateSystemAxisArray[2]);
                }
            }
        } else if (EllipsoidalCS.class.isAssignableFrom(clazz)) {
            switch (n) {
                case 2: {
                    return cSFactory.createEllipsoidalCS(map, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1]);
                }
                case 3: {
                    return cSFactory.createEllipsoidalCS(map, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1], coordinateSystemAxisArray[2]);
                }
            }
        } else if (SphericalCS.class.isAssignableFrom(clazz)) {
            switch (n) {
                case 3: {
                    return cSFactory.createSphericalCS(map, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1], coordinateSystemAxisArray[2]);
                }
            }
        } else if (CylindricalCS.class.isAssignableFrom(clazz)) {
            switch (n) {
                case 3: {
                    return cSFactory.createCylindricalCS(map, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1], coordinateSystemAxisArray[2]);
                }
            }
        } else if (PolarCS.class.isAssignableFrom(clazz)) {
            switch (n) {
                case 2: {
                    return cSFactory.createPolarCS(map, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1]);
                }
            }
        } else if (VerticalCS.class.isAssignableFrom(clazz)) {
            switch (n) {
                case 1: {
                    return cSFactory.createVerticalCS(map, coordinateSystemAxisArray[0]);
                }
            }
        } else if (TimeCS.class.isAssignableFrom(clazz)) {
            switch (n) {
                case 1: {
                    return cSFactory.createTimeCS(map, coordinateSystemAxisArray[0]);
                }
            }
        } else if (LinearCS.class.isAssignableFrom(clazz)) {
            switch (n) {
                case 1: {
                    return cSFactory.createLinearCS(map, coordinateSystemAxisArray[0]);
                }
            }
        } else if (UserDefinedCS.class.isAssignableFrom(clazz)) {
            switch (n) {
                case 2: {
                    return cSFactory.createUserDefinedCS(map, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1]);
                }
                case 3: {
                    return cSFactory.createUserDefinedCS(map, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1], coordinateSystemAxisArray[2]);
                }
            }
        }
        throw new FactoryException(Errors.format((int)237, clazz));
    }

    private Map<String, ?> getProperties(IdentifiedObject identifiedObject) {
        Citation citation = this.getAuthority();
        if (!Utilities.equals((Object)citation, (Object)identifiedObject.getName().getAuthority())) {
            return IdentifiedObjects.getProperties(identifiedObject, citation);
        }
        return IdentifiedObjects.getProperties(identifiedObject);
    }

    @Override
    public Set<CoordinateOperation> createFromCoordinateReferenceSystemCodes(String string, String string2) throws FactoryException {
        Set<CoordinateOperation> set = super.createFromCoordinateReferenceSystemCodes(string, string2);
        LinkedHashSet<CoordinateOperation> linkedHashSet = new LinkedHashSet<CoordinateOperation>(XCollections.hashMapCapacity((int)set.size()));
        Iterator<CoordinateOperation> iterator = set.iterator();
        while (iterator.hasNext()) {
            CoordinateOperation coordinateOperation;
            try {
                coordinateOperation = iterator.next();
            }
            catch (BackingStoreException backingStoreException) {
                throw (FactoryException)backingStoreException.unwrapOrRethrow(FactoryException.class);
            }
            linkedHashSet.add(this.replace(coordinateOperation));
        }
        return linkedHashSet;
    }

    @Override
    protected void dispose(boolean bl) {
        this.pool.clear();
        super.dispose(bl);
    }
}

