/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.factory.web;

import java.util.Locale;
import org.geotoolkit.referencing.IdentifiedObjects;
import org.geotoolkit.referencing.factory.AbstractAuthorityFactory;
import org.geotoolkit.referencing.factory.IdentifiedObjectFinder;
import org.geotoolkit.referencing.factory.web.URN_Type;
import org.geotoolkit.util.ComparisonMode;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.FactoryException;

class FinderAdapter
extends IdentifiedObjectFinder {
    private final IdentifiedObjectFinder finder;

    FinderAdapter(AbstractAuthorityFactory abstractAuthorityFactory, Class<? extends IdentifiedObject> clazz) throws FactoryException {
        super(abstractAuthorityFactory, clazz);
        this.finder = abstractAuthorityFactory.getIdentifiedObjectFinder(clazz);
    }

    @Override
    public void setComparisonMode(ComparisonMode comparisonMode) {
        this.finder.setComparisonMode(comparisonMode);
        super.setComparisonMode(comparisonMode);
    }

    @Override
    public final void setFullScanAllowed(boolean bl) {
        this.finder.setFullScanAllowed(bl);
        super.setFullScanAllowed(bl);
    }

    @Override
    public final IdentifiedObject find(IdentifiedObject identifiedObject) throws FactoryException {
        return this.finder.find(identifiedObject);
    }

    @Override
    public final String findIdentifier(IdentifiedObject identifiedObject) throws FactoryException {
        ReferenceIdentifier referenceIdentifier;
        IdentifiedObject identifiedObject2 = this.find(identifiedObject);
        if (identifiedObject2 != null && ((referenceIdentifier = IdentifiedObjects.getIdentifier(identifiedObject, null)) != null || (referenceIdentifier = identifiedObject.getName()) != null)) {
            String string = referenceIdentifier.getCode();
            String string2 = referenceIdentifier.getCodeSpace();
            if (string != null && string2 != null) {
                string2 = string2.toLowerCase(Locale.US);
                return this.path(identifiedObject, referenceIdentifier, string2).append(string).toString();
            }
        }
        return null;
    }

    StringBuilder path(IdentifiedObject identifiedObject, ReferenceIdentifier referenceIdentifier, String string) {
        URN_Type uRN_Type = URN_Type.getInstance(identifiedObject.getClass());
        StringBuilder stringBuilder = new StringBuilder("urn:ogc:def:").append(uRN_Type).append(':').append(string).append(':');
        String string2 = referenceIdentifier.getVersion();
        if (string2 != null) {
            stringBuilder.append(string2).append(':');
        }
        return stringBuilder;
    }
}

