/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.metadata;

import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.geotoolkit.metadata.KeyNamePolicy;
import org.geotoolkit.metadata.MetadataMap;
import org.geotoolkit.metadata.NullValuePolicy;
import org.geotoolkit.metadata.PropertyAccessor;
import org.geotoolkit.metadata.ValueRestriction;

final class RestrictionMap
extends MetadataMap<ValueRestriction> {
    final NullValuePolicy content;
    private final Object metadata;

    RestrictionMap(PropertyAccessor propertyAccessor, Object object, NullValuePolicy nullValuePolicy, KeyNamePolicy keyNamePolicy) {
        super(propertyAccessor, keyNamePolicy);
        this.metadata = object;
        this.content = nullValuePolicy;
    }

    final ValueRestriction restriction(int n) {
        ValueRestriction valueRestriction = this.accessor.restriction(n);
        if (valueRestriction != null && this.metadata != null) {
            valueRestriction = valueRestriction.violation(this.accessor.get(n, this.metadata));
        }
        return valueRestriction;
    }

    @Override
    public int size() {
        int n = this.accessor.count();
        if (this.content == NullValuePolicy.ALL) {
            return n;
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (this.restriction(i) == null) continue;
            ++n2;
        }
        return n2;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.get(object) != null;
    }

    @Override
    public ValueRestriction get(Object object) {
        if (object instanceof String) {
            return this.restriction(this.accessor.indexOf((String)object));
        }
        return null;
    }

    @Override
    final Iterator<Map.Entry<String, ValueRestriction>> iterator() {
        return new Iter();
    }

    private final class Iter
    extends MetadataMap.Iter {
        private Map.Entry<String, ValueRestriction> next;
        private int index;
        private boolean hasNext;

        Iter() {
            super(RestrictionMap.this);
        }

        @Override
        public boolean hasNext() {
            if (this.hasNext) {
                return true;
            }
            int n = RestrictionMap.this.accessor.count();
            while (this.index < n) {
                boolean bl;
                int n2;
                ++this.index;
                ValueRestriction valueRestriction = RestrictionMap.this.restriction(n2);
                switch (RestrictionMap.this.content) {
                    case ALL: {
                        bl = false;
                        break;
                    }
                    case NON_EMPTY: 
                    case NON_NULL: {
                        bl = valueRestriction == null;
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)RestrictionMap.this.content);
                    }
                }
                if (bl) continue;
                this.next = new AbstractMap.SimpleEntry<String, ValueRestriction>(RestrictionMap.this.accessor.name(n2, RestrictionMap.this.keyNames), valueRestriction);
                this.hasNext = true;
                return true;
            }
            this.next = null;
            return false;
        }

        @Override
        public Map.Entry<String, ValueRestriction> next() {
            if (this.hasNext()) {
                this.hasNext = false;
                return this.next;
            }
            throw new NoSuchElementException();
        }
    }
}

