/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing;

import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.geotoolkit.geometry.GeneralEnvelope;
import org.geotoolkit.internal.referencing.CRSUtilities;
import org.geotoolkit.referencing.CRS;
import org.geotoolkit.referencing.IdentifiedObjects;
import org.geotoolkit.referencing.SequenceValueTransform1D;
import org.geotoolkit.referencing.crs.DefaultCompoundCRS;
import org.geotoolkit.referencing.crs.DefaultTemporalCRS;
import org.geotoolkit.referencing.crs.DefaultVerticalCRS;
import org.geotoolkit.referencing.operation.transform.ConcatenatedTransform;
import org.geotoolkit.referencing.operation.transform.LinearTransform1D;
import org.geotoolkit.referencing.operation.transform.PassThroughTransform;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public final class ReferencingUtilities {
    private ReferencingUtilities() {
    }

    public static Envelope transform(Envelope env, CoordinateReferenceSystem targetCRS) throws TransformException {
        try {
            return CRS.transform((Envelope)env, (CoordinateReferenceSystem)targetCRS);
        }
        catch (TransformException ex) {
            CoordinateReferenceSystem sourceCRS = env.getCoordinateReferenceSystem();
            GeneralEnvelope result = new GeneralEnvelope(targetCRS);
            List<CoordinateReferenceSystem> sourceParts = ReferencingUtilities.decompose(sourceCRS);
            List<CoordinateReferenceSystem> targetParts = ReferencingUtilities.decompose(targetCRS);
            int sourceAxeIndex = 0;
            for (CoordinateReferenceSystem sourcePart : sourceParts) {
                int sourcePartDimension = sourcePart.getCoordinateSystem().getDimension();
                int targetAxeIndex = 0;
                for (CoordinateReferenceSystem targetPart : targetParts) {
                    int targetPartDimension = targetPart.getCoordinateSystem().getDimension();
                    try {
                        MathTransform trs = CRS.findMathTransform((CoordinateReferenceSystem)sourcePart, (CoordinateReferenceSystem)targetPart, (boolean)true);
                        GeneralEnvelope partSource = new GeneralEnvelope(sourcePart);
                        for (int i = 0; i < sourcePartDimension; ++i) {
                            partSource.setRange(i, env.getMinimum(sourceAxeIndex + i), env.getMaximum(sourceAxeIndex + i));
                        }
                        GeneralEnvelope partResult = CRS.transform((MathTransform)trs, (Envelope)partSource);
                        for (int i = 0; i < targetPartDimension; ++i) {
                            result.setRange(targetAxeIndex + i, partResult.getMinimum(i), partResult.getMaximum(i));
                        }
                        break;
                    }
                    catch (FactoryException ex2) {
                        targetAxeIndex += targetPartDimension;
                    }
                }
                sourceAxeIndex += sourcePartDimension;
            }
            return result;
        }
    }

    public static GeneralEnvelope combine(Envelope bounds, Date[] temporal, Double[] elevation) throws TransformException {
        CoordinateReferenceSystem crs = bounds.getCoordinateReferenceSystem();
        Rectangle2D.Double rect = new Rectangle2D.Double(bounds.getMinimum(0), bounds.getMinimum(1), bounds.getSpan(0), bounds.getSpan(1));
        return ReferencingUtilities.combine(crs, rect, temporal, elevation);
    }

    public static GeneralEnvelope combine(CoordinateReferenceSystem crs, Rectangle2D bounds, Date[] temporal, Double[] elevation) throws TransformException {
        GeneralEnvelope env;
        CoordinateReferenceSystem crs2D = CRSUtilities.getCRS2D((CoordinateReferenceSystem)crs);
        TemporalCRS temporalDim = null;
        VerticalCRS verticalDim = null;
        if (temporal != null && (temporal[0] != null || temporal[1] != null) && (temporalDim = CRS.getTemporalCRS((CoordinateReferenceSystem)crs)) == null) {
            temporalDim = DefaultTemporalCRS.JAVA;
        }
        if (elevation != null && (elevation[0] != null || elevation[1] != null) && (verticalDim = CRS.getVerticalCRS((CoordinateReferenceSystem)crs)) == null) {
            verticalDim = DefaultVerticalCRS.ELLIPSOIDAL_HEIGHT;
        }
        if (temporalDim != null && verticalDim != null) {
            double[] coords;
            MathTransform trs;
            crs = new DefaultCompoundCRS(crs2D.getName().getCode() + "/" + verticalDim.getName().getCode() + "/" + temporalDim.getName().getCode(), new CoordinateReferenceSystem[]{crs2D, verticalDim, temporalDim});
            env = new GeneralEnvelope(crs);
            env.setRange(0, bounds.getMinX(), bounds.getMaxX());
            env.setRange(1, bounds.getMinY(), bounds.getMaxY());
            try {
                DefaultTemporalCRS realTemporal = DefaultTemporalCRS.JAVA;
                trs = CRS.findMathTransform((CoordinateReferenceSystem)realTemporal, (CoordinateReferenceSystem)temporalDim);
                coords = new double[]{temporal[0] != null ? (double)temporal[0].getTime() : Double.NEGATIVE_INFINITY, temporal[1] != null ? (double)temporal[1].getTime() : Double.POSITIVE_INFINITY};
                trs.transform(coords, 0, coords, 0, 2);
                env.setRange(3, coords[0], coords[1]);
            }
            catch (FactoryException ex) {
                throw new TransformException(ex.getMessage(), ex);
            }
            try {
                DefaultVerticalCRS realElevation = DefaultVerticalCRS.ELLIPSOIDAL_HEIGHT;
                trs = CRS.findMathTransform((CoordinateReferenceSystem)realElevation, (CoordinateReferenceSystem)verticalDim);
                coords = new double[]{elevation[0] != null ? elevation[0] : Double.NEGATIVE_INFINITY, elevation[1] != null ? elevation[1] : Double.POSITIVE_INFINITY};
                trs.transform(coords, 0, coords, 0, 2);
                env.setRange(2, coords[0], coords[1]);
            }
            catch (FactoryException ex) {
                throw new TransformException(ex.getMessage(), ex);
            }
        }
        if (temporalDim != null) {
            crs = new DefaultCompoundCRS(crs2D.getName().getCode() + "/" + temporalDim.getName().getCode(), new CoordinateReferenceSystem[]{crs2D, temporalDim});
            env = new GeneralEnvelope(crs);
            env.setRange(0, bounds.getMinX(), bounds.getMaxX());
            env.setRange(1, bounds.getMinY(), bounds.getMaxY());
            try {
                DefaultTemporalCRS realTemporal = DefaultTemporalCRS.JAVA;
                MathTransform trs = CRS.findMathTransform((CoordinateReferenceSystem)realTemporal, (CoordinateReferenceSystem)temporalDim);
                double[] coords = new double[]{temporal[0] != null ? (double)temporal[0].getTime() : Double.NEGATIVE_INFINITY, temporal[1] != null ? (double)temporal[1].getTime() : Double.POSITIVE_INFINITY};
                trs.transform(coords, 0, coords, 0, 2);
                env.setRange(2, coords[0], coords[1]);
            }
            catch (FactoryException ex) {
                throw new TransformException(ex.getMessage(), ex);
            }
        } else if (verticalDim != null) {
            crs = new DefaultCompoundCRS(crs2D.getName().getCode() + "/" + verticalDim.getName().getCode(), new CoordinateReferenceSystem[]{crs2D, verticalDim});
            env = new GeneralEnvelope(crs);
            env.setRange(0, bounds.getMinX(), bounds.getMaxX());
            env.setRange(1, bounds.getMinY(), bounds.getMaxY());
            try {
                DefaultVerticalCRS realElevation = DefaultVerticalCRS.ELLIPSOIDAL_HEIGHT;
                MathTransform trs = CRS.findMathTransform((CoordinateReferenceSystem)realElevation, (CoordinateReferenceSystem)verticalDim);
                double[] coords = new double[]{elevation[0] != null ? elevation[0] : Double.NEGATIVE_INFINITY, elevation[1] != null ? elevation[1] : Double.POSITIVE_INFINITY};
                trs.transform(coords, 0, coords, 0, 2);
                env.setRange(2, coords[0], coords[1]);
            }
            catch (FactoryException ex) {
                throw new TransformException(ex.getMessage(), ex);
            }
        } else {
            crs = crs2D;
            env = new GeneralEnvelope(crs);
            env.setRange(0, bounds.getMinX(), bounds.getMaxX());
            env.setRange(1, bounds.getMinY(), bounds.getMaxY());
        }
        return env;
    }

    public static CoordinateReferenceSystem change2DComponent(CoordinateReferenceSystem originalCRS, CoordinateReferenceSystem crs2D) throws TransformException {
        CoordinateReferenceSystem targetCRS;
        if (crs2D.getCoordinateSystem().getDimension() != 2) {
            throw new IllegalArgumentException("Expected a 2D CRS");
        }
        if (originalCRS instanceof CompoundCRS) {
            CompoundCRS ccrs = (CompoundCRS)originalCRS;
            CoordinateReferenceSystem part2D = CRSUtilities.getCRS2D((CoordinateReferenceSystem)originalCRS);
            ArrayList<CoordinateReferenceSystem> lst = new ArrayList<CoordinateReferenceSystem>();
            StringBuilder sb = new StringBuilder();
            for (CoordinateReferenceSystem c : ccrs.getComponents()) {
                if (c.equals(part2D)) {
                    lst.add(crs2D);
                    sb.append(crs2D.getName().toString()).append(' ');
                    continue;
                }
                lst.add(c);
                sb.append(c.getName().toString()).append(' ');
            }
            targetCRS = new DefaultCompoundCRS(sb.toString(), lst.toArray(new CoordinateReferenceSystem[lst.size()]));
        } else if (originalCRS.getCoordinateSystem().getDimension() == 2) {
            targetCRS = crs2D;
        } else {
            throw new UnsupportedOperationException("How do we change the 2D component of a CRS if it's not a CompoundCRS ?");
        }
        return targetCRS;
    }

    public static Envelope transform2DCRS(Envelope env, CoordinateReferenceSystem crs2D) throws TransformException {
        CoordinateReferenceSystem originalCRS = env.getCoordinateReferenceSystem();
        CoordinateReferenceSystem targetCRS = ReferencingUtilities.change2DComponent(originalCRS, crs2D);
        return CRS.transform((Envelope)env, (CoordinateReferenceSystem)targetCRS);
    }

    public static Envelope setLongitudeFirst(Envelope env) throws TransformException, FactoryException {
        if (env == null) {
            return env;
        }
        CoordinateReferenceSystem crs = env.getCoordinateReferenceSystem();
        CoordinateReferenceSystem flipped = ReferencingUtilities.setLongitudeFirst(crs);
        return CRS.transform((Envelope)env, (CoordinateReferenceSystem)flipped);
    }

    public static CoordinateReferenceSystem setLongitudeFirst(CoordinateReferenceSystem crs) throws FactoryException {
        if (crs instanceof SingleCRS) {
            SingleCRS singlecrs = (SingleCRS)crs;
            CoordinateSystem cs = singlecrs.getCoordinateSystem();
            int dimension = cs.getDimension();
            if (dimension <= 1) {
                return crs;
            }
            int eastAxis = -1;
            for (int i = 0; i < dimension; ++i) {
                AxisDirection firstAxis = cs.getAxis(i).getDirection();
                if (firstAxis != AxisDirection.EAST && firstAxis != AxisDirection.WEST) continue;
                eastAxis = i;
                break;
            }
            if (eastAxis == 0) {
                return singlecrs;
            }
            String id = IdentifiedObjects.lookupIdentifier((IdentifiedObject)singlecrs, (boolean)true);
            if (id != null) {
                return CRS.decode((String)id, (boolean)true);
            }
            throw new FactoryException("Failed to create flipped axis for crs : " + singlecrs);
        }
        if (crs instanceof CompoundCRS) {
            CompoundCRS compoundcrs = (CompoundCRS)crs;
            List<CoordinateReferenceSystem> components = compoundcrs.getComponents();
            int size = components.size();
            CoordinateReferenceSystem[] parts = new CoordinateReferenceSystem[size];
            boolean changed = false;
            for (int i = 0; i < size; ++i) {
                CoordinateReferenceSystem orig = components.get(i);
                parts[i] = ReferencingUtilities.setLongitudeFirst(orig);
                if (parts[i].equals(orig)) continue;
                changed = true;
            }
            if (changed) {
                return new DefaultCompoundCRS(compoundcrs.getName().getCode(), parts);
            }
            return crs;
        }
        return crs;
    }

    public static AffineTransform toAffine(Dimension rect, Envelope env) {
        double minx = env.getMinimum(0);
        double maxy = env.getMaximum(1);
        double scaleX = env.getSpan(0) / (double)rect.width;
        double scaleY = -env.getSpan(1) / (double)rect.height;
        return new AffineTransform(scaleX, 0.0, 0.0, scaleY, minx, maxy);
    }

    public static MathTransform toTransform(MathTransform base, double[] ... values) {
        MathTransform result = PassThroughTransform.create((int)0, (MathTransform)base, (int)values.length);
        int baseDim = base.getSourceDimensions();
        for (int i = 0; i < values.length; ++i) {
            double[] array = values[i];
            Object axistrs = array.length == 0 ? LinearTransform1D.create((double)1.0, (double)0.0) : (array.length == 1 ? LinearTransform1D.create((double)1.0, (double)array[0]) : SequenceValueTransform1D.create(array));
            MathTransform mask = PassThroughTransform.create((int)(baseDim + i), (MathTransform)axistrs, (int)(values.length - i - 1));
            result = ConcatenatedTransform.create((MathTransform)result, (MathTransform)mask);
        }
        return result;
    }

    public static List<CoordinateReferenceSystem> decompose(CoordinateReferenceSystem crs) {
        ArrayList<CoordinateReferenceSystem> lst = new ArrayList<CoordinateReferenceSystem>();
        ReferencingUtilities.decompose(crs, lst);
        return lst;
    }

    private static void decompose(CoordinateReferenceSystem crs, List<CoordinateReferenceSystem> lst) {
        if (crs instanceof CompoundCRS) {
            List<CoordinateReferenceSystem> parts = ((CompoundCRS)crs).getComponents();
            for (CoordinateReferenceSystem part : parts) {
                ReferencingUtilities.decompose(part, lst);
            }
        } else {
            lst.add(crs);
        }
    }
}

