/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.geomatics.gml;

import com.vividsolutions.jts.geom.Coordinate;
import java.util.List;
import org.geotoolkit.gml.xml.AbstractGeometry;
import org.geotoolkit.gml.xml.v321.AbstractCurveType;
import org.geotoolkit.gml.xml.v321.AbstractSurfaceType;
import org.geotoolkit.gml.xml.v321.PointType;
import org.opengis.cite.geomatics.gml.CoordinateListFactory;
import org.opengis.cite.geomatics.gml.GeometryType;

public class GeometryCoordinateList {
    public Coordinate[] getCoordinateList(AbstractGeometry gmlGeometry) {
        GeometryType geomType;
        if (AbstractCurveType.class.isInstance(gmlGeometry)) {
            geomType = GeometryType.CURVE;
        } else if (PointType.class.isInstance(gmlGeometry)) {
            geomType = GeometryType.POINT;
        } else if (AbstractSurfaceType.class.isInstance(gmlGeometry)) {
            geomType = GeometryType.SURFACE;
        } else {
            throw new RuntimeException("Unsupported geometry type: " + gmlGeometry.getClass().getName());
        }
        CoordinateListFactory factory = geomType.getCoordinateSetFactory();
        List<Coordinate> coordSet = factory.createCoordinateList(gmlGeometry);
        return coordSet.toArray(new Coordinate[0]);
    }
}

