/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util;

import java.io.Serializable;
import javax.measure.unit.Unit;
import net.jcip.annotations.Immutable;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.collection.CheckedContainer;
import org.geotoolkit.util.converter.Numbers;

@Immutable
public class Range<T extends Comparable<? super T>>
implements CheckedContainer<T>,
Serializable {
    private static final long serialVersionUID = -5393896130562660517L;
    final Class<T> elementClass;
    final T minValue;
    final T maxValue;
    private final boolean isMinIncluded;
    private final boolean isMaxIncluded;

    public Range(Class<T> clazz, T t) {
        this(clazz, t, true, t, true);
    }

    public Range(Class<T> clazz, T t, T t2) {
        this(clazz, t, true, t2, true);
    }

    public Range(Class<T> clazz, T t, boolean bl, T t2, boolean bl2) {
        ArgumentChecks.ensureNonNull("elementClass", clazz);
        this.elementClass = clazz;
        this.minValue = t;
        this.maxValue = t2;
        this.isMinIncluded = bl && t != null;
        this.isMaxIncluded = bl2 && t2 != null;
        this.checkElementClass();
        if (t != null) {
            this.ensureCompatible(t.getClass());
        }
        if (t2 != null) {
            this.ensureCompatible(t2.getClass());
        }
    }

    Range<T> create(T t, boolean bl, T t2, boolean bl2) {
        return new Range<T>(this.elementClass, t, bl, t2, bl2);
    }

    private Range<? extends T> ensureCompatible(Range<?> range) throws IllegalArgumentException {
        ArgumentChecks.ensureNonNull("range", range);
        this.ensureCompatible(range.elementClass);
        return range;
    }

    private void ensureCompatible(Class<?> clazz) throws IllegalArgumentException {
        if (!this.elementClass.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(Errors.format(76, clazz, this.elementClass));
        }
    }

    void checkElementClass() throws IllegalArgumentException {
        if (!Comparable.class.isAssignableFrom(this.elementClass)) {
            throw new IllegalArgumentException(Errors.format(76, this.elementClass, Comparable.class));
        }
    }

    Range<T>[] newArray(int n) {
        return new Range[n];
    }

    @Override
    public Class<T> getElementType() {
        return this.elementClass;
    }

    public T getMinValue() {
        return this.minValue;
    }

    public boolean isMinIncluded() {
        return this.isMinIncluded;
    }

    public T getMaxValue() {
        return this.maxValue;
    }

    public boolean isMaxIncluded() {
        return this.isMaxIncluded;
    }

    public boolean isEmpty() {
        if (this.minValue == null || this.maxValue == null) {
            return false;
        }
        int n = this.minValue.compareTo(this.maxValue);
        if (n < 0) {
            return false;
        }
        return n != 0 || !this.isMinIncluded || !this.isMaxIncluded;
    }

    public boolean contains(Comparable<?> comparable) throws IllegalArgumentException {
        if (comparable == null) {
            return false;
        }
        this.ensureCompatible(comparable.getClass());
        Comparable<?> comparable2 = comparable;
        return this.containsNC(comparable2);
    }

    final boolean containsNC(T t) {
        int n;
        if (!(this.minValue == null || (n = this.minValue.compareTo(t)) < 0 || n == 0 && this.isMinIncluded)) {
            return false;
        }
        return this.maxValue == null || (n = this.maxValue.compareTo(t)) > 0 || n == 0 && this.isMaxIncluded;
    }

    public boolean contains(Range<?> range) throws IllegalArgumentException {
        return this.containsNC(this.ensureCompatible(range));
    }

    final boolean containsNC(Range<? extends T> range) {
        return !(this.minValue != null && this.compareMinTo(range.minValue, range.isMinIncluded ? 0 : 1) > 0 || this.maxValue != null && this.compareMaxTo(range.maxValue, range.isMaxIncluded ? 0 : -1) < 0);
    }

    public boolean intersects(Range<?> range) throws IllegalArgumentException {
        return this.intersectsNC(this.ensureCompatible(range));
    }

    final boolean intersectsNC(Range<? extends T> range) {
        return this.compareMinTo(range.maxValue, range.isMaxIncluded ? 0 : -1) <= 0 && this.compareMaxTo(range.minValue, range.isMinIncluded ? 0 : 1) >= 0;
    }

    public Range<?> intersect(Range<?> range) throws IllegalArgumentException {
        return this.intersectNC(this.ensureCompatible(range));
    }

    final Range<? extends T> intersectNC(Range<? extends T> range) throws IllegalArgumentException {
        Range<T> range2 = this.compareMinTo(range.minValue, range.isMinIncluded ? 0 : 1) < 0 ? range : this;
        Range<T> range3 = this.compareMaxTo(range.maxValue, range.isMaxIncluded ? 0 : -1) > 0 ? range : this;
        Range<T> range4 = range2 == range3 ? range2 : this.create(range2.minValue, range2.isMinIncluded, range3.maxValue, range3.isMaxIncluded);
        assert (range4.isEmpty() == !this.intersects(range)) : range4;
        return range4;
    }

    public Range<?>[] subtract(Range<?> range) throws IllegalArgumentException {
        return this.subtractNC(this.ensureCompatible(range));
    }

    final Range<T>[] subtractNC(Range<? extends T> range) throws IllegalArgumentException {
        Range<T> range2;
        if (!this.intersects(range)) {
            range2 = this;
        } else {
            boolean bl;
            boolean bl2 = this.compareMinTo(range.minValue, range.isMinIncluded ? 0 : 1) >= 0;
            boolean bl3 = bl = this.compareMaxTo(range.maxValue, range.isMaxIncluded ? 0 : -1) <= 0;
            if (bl2) {
                if (bl) {
                    assert (range.contains(this)) : range;
                    return this.newArray(0);
                }
                range2 = this.create(range.maxValue, !range.isMaxIncluded, this.maxValue, this.isMaxIncluded);
            } else {
                if (!bl) {
                    Range<T>[] rangeArray = this.newArray(2);
                    rangeArray[0] = this.create(this.minValue, this.isMinIncluded, range.minValue, !range.isMinIncluded);
                    rangeArray[1] = this.create(range.maxValue, !range.isMaxIncluded, this.maxValue, this.isMaxIncluded);
                    return rangeArray;
                }
                range2 = this.create(this.minValue, this.isMinIncluded, range.minValue, !range.isMinIncluded);
            }
        }
        assert (this.contains(range2)) : range2;
        assert (!range2.intersects(range)) : range2;
        Range<T>[] rangeArray = this.newArray(1);
        rangeArray[0] = range2;
        return rangeArray;
    }

    public Range<?> union(Range<?> range) throws IllegalArgumentException {
        return this.unionNC(this.ensureCompatible(range));
    }

    final Range<?> unionNC(Range<? extends T> range) throws IllegalArgumentException {
        Range<T> range2 = this.compareMinTo(range.minValue, range.isMinIncluded ? 0 : 1) > 0 ? range : this;
        Range<T> range3 = this.compareMaxTo(range.maxValue, range.isMaxIncluded ? 0 : -1) < 0 ? range : this;
        Range<T> range4 = range2 == range3 ? range2 : this.create(range2.minValue, range2.isMinIncluded, range3.maxValue, range3.isMaxIncluded);
        assert (range4.contains(range2)) : range2;
        assert (range4.contains(range3)) : range3;
        return range4;
    }

    final int compareMinTo(T t, int n) {
        if (t == null) {
            return n;
        }
        if (this.minValue == null) {
            return -1;
        }
        int n2 = this.minValue.compareTo(t);
        if (n2 == 0) {
            if (this.isMinIncluded) {
                return -n;
            }
            if (n <= 0) {
                return 1;
            }
        }
        return n2;
    }

    final int compareMaxTo(T t, int n) {
        if (t == null) {
            return n;
        }
        if (this.maxValue == null) {
            return 1;
        }
        int n2 = this.maxValue.compareTo(t);
        if (n2 == 0) {
            if (this.isMaxIncluded) {
                return -n;
            }
            if (n >= 0) {
                return -1;
            }
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass() == this.getClass()) {
            Range range = (Range)object;
            if (Utilities.equals(this.elementClass, range.elementClass)) {
                if (this.isEmpty()) {
                    return range.isEmpty();
                }
                return Utilities.equals(this.minValue, range.minValue) && Utilities.equals(this.maxValue, range.maxValue) && this.isMinIncluded == range.isMinIncluded && this.isMaxIncluded == range.isMaxIncluded;
            }
        }
        return false;
    }

    public int hashCode() {
        int n = 511010651;
        if (!this.isEmpty()) {
            n += this.elementClass.hashCode();
            n = Utilities.hash(this.isMaxIncluded, n);
            n = Utilities.hash(this.isMinIncluded, n);
            n = Utilities.hash(this.maxValue, n);
            n = Utilities.hash(this.minValue, n);
        }
        return n;
    }

    Unit<?> getUnits() {
        return null;
    }

    private static boolean isCompact(Comparable<?> comparable, boolean bl) {
        if (comparable == null) {
            return bl;
        }
        long l = ((Number)((Object)comparable)).longValue();
        return l >= 0L && l < 10L;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "[]";
        }
        T t = this.minValue;
        T t2 = this.maxValue;
        if (t != null && t.equals(t2)) {
            String string = t.toString();
            Unit<?> unit = this.getUnits();
            if (unit != null) {
                string = string + ' ' + unit;
            }
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(20);
        stringBuilder.append(this.isMinIncluded ? (char)'[' : '(');
        if (t == null) {
            stringBuilder.append("-\u221e");
        } else {
            stringBuilder.append(t);
        }
        if (Numbers.isInteger(this.elementClass) && Range.isCompact(t, false) && Range.isCompact(t2, true)) {
            stringBuilder.append('\u2026');
        } else {
            stringBuilder.append(" \u2026 ");
        }
        if (t2 == null) {
            stringBuilder.append('\u221e');
        } else {
            stringBuilder.append(t2);
        }
        stringBuilder.append(this.isMaxIncluded ? (char)']' : ')');
        Unit<?> unit = this.getUnits();
        if (unit != null) {
            stringBuilder.append(' ').append(unit);
        }
        return stringBuilder.toString();
    }
}

