/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.factory;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.swing.tree.MutableTreeNode;
import org.geotoolkit.factory.FactoryFinder;
import org.geotoolkit.gui.swing.tree.DefaultMutableTreeNode;
import org.geotoolkit.gui.swing.tree.NamedTreeNode;
import org.geotoolkit.gui.swing.tree.TreeNode;
import org.geotoolkit.gui.swing.tree.Trees;
import org.geotoolkit.internal.io.IOUtilities;
import org.geotoolkit.io.X364;
import org.geotoolkit.lang.Buffered;
import org.geotoolkit.referencing.factory.ReferencingFactory;
import org.geotoolkit.util.collection.XCollections;
import org.geotoolkit.util.converter.Classes;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.util.Factory;

public class FactoryDependencies {
    private static final Class<?>[] TYPES = new Class[]{CRSFactory.class, CRSAuthorityFactory.class, CSFactory.class, CSAuthorityFactory.class, DatumFactory.class, DatumAuthorityFactory.class, CoordinateOperationFactory.class, CoordinateOperationAuthorityFactory.class, Buffered.class, Factory.class};
    private static final String[] TYPE_LABELS = new String[]{"crs", "crs", "cs", "cs", "datum", "datum", "operation", "operation", "buffered", "registered"};
    private static final int FACTORY_COUNT = TYPES.length - 2;
    private final Factory factory;
    private boolean colorEnabled;
    private boolean attributes;
    private boolean abridged;

    public FactoryDependencies(Factory factory) {
        this.factory = factory;
    }

    public boolean isColorEnabled() {
        return this.colorEnabled;
    }

    public void setColorEnabled(boolean bl) {
        this.colorEnabled = bl;
    }

    public boolean isAttributeEnabled() {
        return this.attributes;
    }

    public void setAttributeEnabled(boolean bl) {
        this.attributes = bl;
    }

    public boolean isAbridged() {
        return this.abridged;
    }

    public void setAbridged(boolean bl) {
        this.abridged = bl;
    }

    public void print() {
        PrintWriter printWriter = IOUtilities.standardPrintWriter();
        this.print(printWriter);
        printWriter.flush();
    }

    public void print(PrintWriter printWriter) {
        printWriter.print(Trees.toString((javax.swing.tree.TreeNode)this.asTree()));
    }

    public void print(Appendable appendable) throws IOException {
        appendable.append(Trees.toString((javax.swing.tree.TreeNode)this.asTree()));
    }

    public TreeNode asTree() {
        return this.createTree(this.factory, new IdentityHashMap<Factory, Integer>());
    }

    private org.geotoolkit.gui.swing.tree.MutableTreeNode createTree(Factory factory, Map<Factory, Integer> map) {
        Collection<? super AuthorityFactory> collection;
        int n = FactoryDependencies.intValue(map.get(factory));
        boolean bl = (n & 2) == 0;
        DefaultMutableTreeNode defaultMutableTreeNode = this.createNode(factory, bl);
        map.put(factory, n | 2);
        if (factory instanceof ReferencingFactory && (bl || !this.abridged) && (collection = ((ReferencingFactory)factory).dependencies()) != null) {
            for (AuthorityFactory authorityFactory : collection) {
                DefaultMutableTreeNode defaultMutableTreeNode2;
                if (authorityFactory instanceof Factory) {
                    Factory factory2 = authorityFactory;
                    int n2 = FactoryDependencies.intValue(map.get(factory2));
                    if ((n2 & 1) != 0) continue;
                    map.put(factory2, n2 | 1);
                    defaultMutableTreeNode2 = this.createTree(factory2, map);
                    n2 = FactoryDependencies.intValue(map.get(factory2));
                    map.put(factory2, n2 & 0xFFFFFFFE);
                } else {
                    defaultMutableTreeNode2 = new DefaultMutableTreeNode((Object)authorityFactory, false);
                }
                defaultMutableTreeNode.add((MutableTreeNode)defaultMutableTreeNode2);
            }
        }
        return defaultMutableTreeNode;
    }

    private DefaultMutableTreeNode createNode(Factory factory, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(Classes.getShortClassName((Object)factory)).append('[');
        if (factory instanceof AuthorityFactory) {
            Citation citation = ((AuthorityFactory)factory).getAuthority();
            if (citation != null) {
                Collection<? extends Identifier> collection = citation.getIdentifiers();
                if (!XCollections.isNullOrEmpty(collection)) {
                    boolean bl2 = false;
                    for (Identifier identifier : collection) {
                        if (bl2) {
                            stringBuilder.append(", ");
                        }
                        this.appendIdentifier(stringBuilder, identifier.getCode(), bl);
                        if (bl) {
                            bl2 = true;
                            continue;
                        }
                        break;
                    }
                } else {
                    this.appendIdentifier(stringBuilder, citation.getTitle(), bl);
                }
            }
        } else {
            this.appendColor(stringBuilder, bl ? X364.FOREGROUND_RED : X364.FOREGROUND_YELLOW, "objects");
        }
        stringBuilder.append(']');
        if (!bl) {
            this.appendColor(stringBuilder, X364.FOREGROUND_YELLOW, " \u2026\u2b0f");
        } else if (this.attributes) {
            boolean bl3 = false;
            for (int i = 0; i < TYPES.length; ++i) {
                Class<?> clazz = TYPES[i];
                if (!Annotation.class.isAssignableFrom(clazz) ? !clazz.isInstance(factory) || clazz.equals(Factory.class) && !FactoryFinder.isRegistered((Object)factory) : !factory.getClass().isAnnotationPresent(clazz.asSubclass(Annotation.class))) continue;
                stringBuilder.append(bl3 ? ", " : " (");
                this.appendColor(stringBuilder, i < FACTORY_COUNT ? X364.FOREGROUND_GREEN : X364.FOREGROUND_CYAN, TYPE_LABELS[i]);
                bl3 = true;
            }
            if (bl3) {
                stringBuilder.append(')');
            }
        }
        return new NamedTreeNode((CharSequence)stringBuilder.toString(), (Object)factory);
    }

    private void appendIdentifier(StringBuilder stringBuilder, CharSequence charSequence, boolean bl) {
        this.appendColor(stringBuilder, bl ? X364.FOREGROUND_MAGENTA : X364.FOREGROUND_YELLOW);
        stringBuilder.append('\"').append(charSequence).append('\"');
        this.appendColor(stringBuilder, X364.FOREGROUND_DEFAULT);
    }

    private void appendColor(StringBuilder stringBuilder, X364 x364, String string) {
        this.appendColor(stringBuilder, x364);
        stringBuilder.append(string);
        this.appendColor(stringBuilder, X364.FOREGROUND_DEFAULT);
    }

    private void appendColor(StringBuilder stringBuilder, X364 x364) {
        if (this.colorEnabled) {
            stringBuilder.append(x364.sequence());
        }
    }

    private static int intValue(Integer n) {
        return n != null ? n : 0;
    }

    public String toString() {
        return Trees.toString((javax.swing.tree.TreeNode)this.asTree());
    }
}

