/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.math;

import org.geotoolkit.math.ExtrapolationException;
import org.geotoolkit.math.Table1D;

public class Search1D
extends Table1D {
    protected int klo;
    protected int khi;

    @Override
    public void clear() {
        super.clear();
        this.klo = 0;
        this.khi = 0;
    }

    @Override
    public final double interpolate(double xi) throws ExtrapolationException {
        if (this.locate(xi)) {
            return this.interpolate(xi, false);
        }
        throw new ExtrapolationException(xi);
    }

    @Override
    public final double interpolateAt(int index) throws ExtrapolationException {
        this.locateAt(index);
        return this.interpolate(this.x[index], false);
    }

    /*
     * Exception decompiling
     */
    public final double[] interpolateNaN(double dxStart, double dxStop, double[] yi) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[DOLOOP]], but top level block is 13[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public double[] interpolateNaN(double dxStart, double dxStop) {
        return this.interpolateNaN(dxStart, dxStop, null);
    }

    public final double[] interpolateInPlaceNaN(double dxStart, double dxStop) {
        return this.interpolateNaN(dxStart, dxStop, this.y);
    }

    protected double interpolate(double xi, boolean reuseIndex) throws ExtrapolationException {
        if (this.ignoreYNaN && !reuseIndex) {
            try {
                this.validateIndex(this.y);
            }
            catch (ExtrapolationException extrapole) {
                if (extrapole.index >= 0) {
                    return this.y[extrapole.index];
                }
                extrapole.xi = xi;
                throw extrapole;
            }
        }
        return this.y[Math.abs(this.x[this.klo] - xi) <= Math.abs(this.x[this.khi] - xi) ? this.klo : this.khi];
    }

    public final boolean locate(double xi, int[] index) {
        if (this.locate(xi)) {
            this.copyIndexInto(index);
            if (this.ignoreYNaN) {
                this.validateIndex(index, this.y);
            }
            return true;
        }
        return false;
    }

    private final boolean locate(double xi) {
        this.klo = 0;
        this.khi = this.x.length - 1;
        while (this.klo <= this.khi) {
            double x_klo = this.x[this.klo];
            double x_khi = this.x[this.khi];
            if (x_klo < xi && xi < x_khi) {
                block1: while (this.khi - this.klo > 1) {
                    int k = this.khi + this.klo >> 1;
                    double xk = this.x[k];
                    if (xi < xk) {
                        this.khi = k;
                        continue;
                    }
                    if (xi > xk) {
                        this.klo = k;
                        continue;
                    }
                    if (xi == xk) {
                        this.klo = this.khi = k;
                        break;
                    }
                    int kmax = this.khi - this.klo + 1 >> 1;
                    for (int i = 1; i < kmax; ++i) {
                        int ki = k + i;
                        xk = this.x[ki];
                        if (xi < xk && ki < this.khi) {
                            this.khi = ki;
                            continue block1;
                        }
                        if (xi > xk && ki > this.klo) {
                            this.klo = ki;
                            continue block1;
                        }
                        if (xi == xk) {
                            this.klo = this.khi = ki;
                            break block1;
                        }
                        ki = k - i;
                        xk = this.x[ki];
                        if (xi < xk && ki < this.khi) {
                            this.khi = ki;
                            continue block1;
                        }
                        if (xi > xk && ki > this.klo) {
                            this.klo = ki;
                            continue block1;
                        }
                        if (xi != xk) continue;
                        this.klo = this.khi = ki;
                        break block1;
                    }
                }
                return true;
            }
            if (x_klo > xi && xi > x_khi) {
                block3: while (this.khi - this.klo > 1) {
                    int k = this.khi + this.klo >> 1;
                    double xk = this.x[k];
                    if (xi > xk) {
                        this.khi = k;
                        continue;
                    }
                    if (xi < xk) {
                        this.klo = k;
                        continue;
                    }
                    if (xi == xk) {
                        this.klo = this.khi = k;
                        break;
                    }
                    int kmax = this.khi - this.klo + 1 >> 1;
                    for (int i = 1; i < kmax; ++i) {
                        int ki = k + i;
                        xk = this.x[ki];
                        if (xi > xk && ki < this.khi) {
                            this.khi = ki;
                            continue block3;
                        }
                        if (xi < xk && ki > this.klo) {
                            this.klo = ki;
                            continue block3;
                        }
                        if (xi == xk) {
                            this.klo = this.khi = ki;
                            break block3;
                        }
                        ki = k - i;
                        xk = this.x[ki];
                        if (xi > xk && ki < this.khi) {
                            this.khi = ki;
                            continue block3;
                        }
                        if (xi < xk && ki > this.klo) {
                            this.klo = ki;
                            continue block3;
                        }
                        if (xi != xk) continue;
                        this.klo = this.khi = ki;
                        break block3;
                    }
                }
                return true;
            }
            if (x_klo == xi) {
                this.khi = this.klo;
                return true;
            }
            if (x_khi == xi) {
                this.klo = this.khi;
                return true;
            }
            if (Double.isNaN(xi) || !Double.isNaN(x_klo) && !Double.isNaN(x_khi)) break;
            while (this.klo <= this.khi && Double.isNaN(this.x[this.klo])) {
                ++this.klo;
            }
            while (this.khi >= this.klo && Double.isNaN(this.x[this.khi])) {
                --this.khi;
            }
        }
        return false;
    }

    private final void locateAt(int index) throws ExtrapolationException {
        this.klo = this.khi = index;
        int length = this.x.length;
        do {
            if (++this.khi < length) continue;
            do {
                if (--this.klo >= 0) continue;
                throw new ExtrapolationException();
            } while (Double.isNaN(this.x[this.klo]));
            throw new ExtrapolationException(1, this.klo);
        } while (Double.isNaN(this.x[this.khi]));
        do {
            if (--this.klo >= 0) continue;
            throw new ExtrapolationException(-1, this.khi);
        } while (Double.isNaN(this.x[this.klo]));
    }

    protected final void copyIndexInto(int[] index) {
        block10: {
            int xlength = this.x.length;
            int center = index.length;
            if (center >= 2) {
                int i = center >>= 1;
                if (this.khi != this.klo) {
                    index[--i] = this.klo;
                }
                block0: while (i > 0) {
                    do {
                        if (--this.klo >= 0) continue;
                        System.arraycopy(index, i, index, 0, center -= i);
                        break block0;
                    } while (Double.isNaN(this.x[this.klo]));
                    index[--i] = this.klo;
                }
                i = center;
                index[i++] = this.khi;
                while (i < index.length) {
                    do {
                        if (++this.khi < xlength) continue;
                        int remainder = index.length - i;
                        System.arraycopy(index, 0, index, remainder, i);
                        i = remainder;
                        while (true) {
                            if (--this.klo < 0) {
                                this.throwArrayIndexOutOfBoundsException(index.length);
                            }
                            if (Double.isNaN(this.x[this.klo])) continue;
                            index[--i] = this.klo;
                            if (i <= 0) break;
                        }
                        break block10;
                    } while (Double.isNaN(this.x[this.khi]));
                    index[i++] = this.khi;
                }
            } else if (center > 0) {
                index[0] = this.klo;
            }
        }
    }

    protected final boolean validateIndex(int[] index, double[] y) {
        int j;
        int center;
        boolean hasChanged = false;
        int xlength = this.x.length;
        int i = center = index.length >> 1;
        block0: while (--i >= 0) {
            if (!Double.isNaN(y[index[i]])) continue;
            hasChanged = true;
            j = i;
            while (--j >= 0) {
                if (Double.isNaN(y[index[j]])) continue;
                index[i--] = index[j];
            }
            int klo = index[0];
            while (true) {
                if (--klo < 0) {
                    center -= ++i;
                    System.arraycopy(index, i, index, 0, index.length - i);
                    break block0;
                }
                if (Double.isNaN(this.x[klo]) || Double.isNaN(y[klo])) continue;
                index[i--] = klo;
                if (i < 0) break block0;
            }
        }
        block3: for (i = center; i < index.length; ++i) {
            if (!Double.isNaN(y[index[i]])) continue;
            hasChanged = true;
            j = i;
            while (++j < index.length) {
                if (Double.isNaN(y[index[j]])) continue;
                index[i++] = index[j];
            }
            int khi = index[index.length - 1];
            while (true) {
                if (++khi >= xlength || khi >= y.length) {
                    int remainder = index.length - i;
                    System.arraycopy(index, 0, index, remainder, i);
                    i = remainder;
                    int klo = index[0];
                    while (true) {
                        if (--klo < 0) {
                            this.throwArrayIndexOutOfBoundsException(index.length);
                        }
                        if (Double.isNaN(this.x[klo]) || Double.isNaN(y[klo])) continue;
                        index[--i] = klo;
                        if (i <= 0) break;
                    }
                    break block3;
                }
                if (Double.isNaN(this.x[khi]) || Double.isNaN(y[khi])) continue;
                index[i++] = khi;
                if (i >= index.length) break;
            }
            break;
        }
        return hasChanged;
    }

    protected final boolean validateIndex(double[] y) throws ExtrapolationException {
        boolean hasChanged = false;
        if (Double.isNaN(y[this.khi])) {
            hasChanged = true;
            do {
                if (++this.khi < y.length) continue;
                while (Double.isNaN(this.x[this.klo]) || Double.isNaN(y[this.klo])) {
                    if (--this.klo >= 0) continue;
                    throw new ExtrapolationException();
                }
                throw new ExtrapolationException(1, this.klo);
            } while (Double.isNaN(this.x[this.khi]) || Double.isNaN(y[this.khi]));
        }
        if (Double.isNaN(y[this.klo])) {
            hasChanged = true;
            do {
                if (--this.klo >= 0) continue;
                throw new ExtrapolationException(-1, this.khi);
            } while (Double.isNaN(this.x[this.klo]) || Double.isNaN(y[this.klo]));
        }
        return hasChanged;
    }

    private double getInterval(int lower, int upper) {
        int k1;
        int k0 = k1 = lower;
        int xlength = this.x.length;
        while (Double.isNaN(this.x[k0])) {
            if (++k0 < xlength) continue;
            return Double.NaN;
        }
        do {
            if (--k1 >= 0) continue;
            k1 = k0;
            do {
                if (++k0 < xlength) continue;
                return Double.NaN;
            } while (Double.isNaN(this.x[k0]));
            break;
        } while (Double.isNaN(this.x[k1]));
        double x0 = this.x[k0];
        double xlo = (this.x[k1] - x0) / (double)(k1 - k0) * ((double)(lower - k0) - 0.5) + x0;
        k0 = k1 = upper;
        while (Double.isNaN(this.x[k0])) {
            if (--k0 >= 0) continue;
            return Double.NaN;
        }
        do {
            if (++k1 < xlength) continue;
            k1 = k0;
            do {
                if (--k0 >= 0) continue;
                return Double.NaN;
            } while (Double.isNaN(this.x[k0]));
            break;
        } while (Double.isNaN(this.x[k1]));
        x0 = this.x[k0];
        return (this.x[k1] - x0) / (double)(k1 - k0) * ((double)(upper - k0) + 0.5) + x0 - xlo;
    }
}

