/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.jaxb;

import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.geometry.JTSLineString;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.primitive.JTSCurve;
import org.geotoolkit.internal.jaxb.LineStringPosListType;
import org.geotoolkit.internal.jaxb.ObjectFactory;
import org.opengis.geometry.primitive.CurveSegment;
import org.opengis.geometry.primitive.OrientableCurve;

public class CurveLineAdapter<T>
extends XmlAdapter<CurveLineAdapter, OrientableCurve> {
    private static ObjectFactory FACTORY = new ObjectFactory();
    @XmlElementRef(name="LineString", namespace="http://www.opengis.net/gml")
    private JAXBElement<LineStringPosListType> lineString;

    public CurveLineAdapter() {
    }

    public CurveLineAdapter(OrientableCurve curve) {
        if (curve instanceof JTSCurve) {
            JTSLineString line = (JTSLineString)((JTSCurve)curve).getSegments().get(0);
            this.lineString = FACTORY.createLineStringPosListType(new LineStringPosListType(line));
        } else if (curve != null) {
            System.out.println("unexpected curve:" + curve.getClass().getName());
        }
    }

    public OrientableCurve unmarshal(CurveLineAdapter v) throws Exception {
        if (v != null && v.lineString != null && v.lineString.getValue() != null) {
            LineStringPosListType posList = (LineStringPosListType)v.lineString.getValue();
            JTSLineString line = posList.getJTSLineString();
            JTSCurve curve = new JTSCurve(null);
            curve.getSegments().add((CurveSegment)line);
            return curve;
        }
        return null;
    }

    public CurveLineAdapter marshal(OrientableCurve v) throws Exception {
        return new CurveLineAdapter<T>(v);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[CurveLineAdapter]\n");
        if (this.lineString != null) {
            sb.append(this.lineString.getValue());
        }
        return sb.toString();
    }
}

