/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry.jts.transform;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import org.geotoolkit.geometry.jts.JTS;
import org.geotoolkit.geometry.jts.transform.CoordinateSequenceTransformer;
import org.geotoolkit.geometry.jts.transform.GeometryTransformer;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

public class GeometryCSTransformer
implements GeometryTransformer {
    private final CoordinateSequenceTransformer csTransformer;
    private CoordinateReferenceSystem crs;

    public GeometryCSTransformer(CoordinateSequenceTransformer transformer) {
        this.csTransformer = transformer;
    }

    public CoordinateSequenceTransformer getCSTransformer() {
        return this.csTransformer;
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem crs) {
        this.crs = crs;
    }

    @Override
    public Geometry transform(Geometry g) throws TransformException {
        Point transformed;
        GeometryFactory factory = g.getFactory();
        if (g instanceof Point) {
            transformed = this.transformPoint((Point)g, factory);
        } else if (g instanceof MultiPoint) {
            MultiPoint mp = (MultiPoint)g;
            Point[] points = new Point[mp.getNumGeometries()];
            for (int i = 0; i < points.length; ++i) {
                points[i] = this.transformPoint((Point)mp.getGeometryN(i), factory);
            }
            transformed = factory.createMultiPoint(points);
        } else if (g instanceof LineString) {
            transformed = this.transformLineString((LineString)g, factory);
        } else if (g instanceof MultiLineString) {
            MultiLineString mls = (MultiLineString)g;
            LineString[] lines = new LineString[mls.getNumGeometries()];
            for (int i = 0; i < lines.length; ++i) {
                lines[i] = this.transformLineString((LineString)mls.getGeometryN(i), factory);
            }
            transformed = factory.createMultiLineString(lines);
        } else if (g instanceof Polygon) {
            transformed = this.transformPolygon((Polygon)g, factory);
        } else if (g instanceof MultiPolygon) {
            MultiPolygon mp = (MultiPolygon)g;
            Polygon[] polygons = new Polygon[mp.getNumGeometries()];
            for (int i = 0; i < polygons.length; ++i) {
                polygons[i] = this.transformPolygon((Polygon)mp.getGeometryN(i), factory);
            }
            transformed = factory.createMultiPolygon(polygons);
        } else if (g instanceof GeometryCollection) {
            GeometryCollection gc = (GeometryCollection)g;
            Geometry[] geoms = new Geometry[gc.getNumGeometries()];
            for (int i = 0; i < geoms.length; ++i) {
                geoms[i] = this.transform(gc.getGeometryN(i));
            }
            transformed = factory.createGeometryCollection(geoms);
        } else {
            throw new IllegalArgumentException("Unsupported geometry type " + g.getClass());
        }
        transformed.setUserData(g.getUserData());
        if (this.crs != null) {
            JTS.setCRS((Geometry)transformed, this.crs);
        }
        return transformed;
    }

    public LineString transformLineString(LineString ls, GeometryFactory gf) throws TransformException {
        LineString transformed;
        CoordinateSequence cs = this.projectCoordinateSequence(ls.getCoordinateSequence());
        if (ls instanceof LinearRing) {
            cs = GeometryCSTransformer.ensureClosed(cs);
            transformed = gf.createLinearRing(cs);
        } else {
            transformed = gf.createLineString(cs);
        }
        transformed.setUserData(ls.getUserData());
        return transformed;
    }

    public Point transformPoint(Point point, GeometryFactory gf) throws TransformException {
        CoordinateSequence cs = this.projectCoordinateSequence(point.getCoordinateSequence());
        Point transformed = gf.createPoint(cs);
        transformed.setUserData(point.getUserData());
        return transformed;
    }

    public CoordinateSequence projectCoordinateSequence(CoordinateSequence cs) throws TransformException {
        return this.csTransformer.transform(cs, 1);
    }

    public Polygon transformPolygon(Polygon polygon, GeometryFactory gf) throws TransformException {
        LinearRing exterior = (LinearRing)this.transformLineString(polygon.getExteriorRing(), gf);
        LinearRing[] interiors = new LinearRing[polygon.getNumInteriorRing()];
        for (int i = 0; i < interiors.length; ++i) {
            interiors[i] = (LinearRing)this.transformLineString(polygon.getInteriorRingN(i), gf);
        }
        Polygon transformed = gf.createPolygon(exterior, interiors);
        transformed.setUserData(polygon.getUserData());
        return transformed;
    }

    @Override
    public CoordinateSequence transform(CoordinateSequence sequence, int minpoints) throws TransformException {
        return this.csTransformer.transform(sequence, minpoints);
    }

    public static CoordinateSequence ensureClosed(CoordinateSequence sequence) {
        int lastIndex;
        Coordinate first = sequence.getCoordinate(0);
        if (!first.equals2D(sequence.getCoordinate(lastIndex = sequence.size() - 1))) {
            sequence.setOrdinate(lastIndex, 0, first.x);
            sequence.setOrdinate(lastIndex, 1, first.y);
            if (sequence.getDimension() > 2) {
                sequence.setOrdinate(lastIndex, 2, first.z);
            }
        }
        return sequence;
    }
}

