/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.xml;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import net.jcip.annotations.Immutable;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.LenientComparable;
import org.geotoolkit.util.collection.WeakHashSet;
import org.geotoolkit.xml.NilObject;
import org.geotoolkit.xml.NilObjectHandler;

@Immutable
public final class NilReason
implements Serializable {
    private static final long serialVersionUID = -1302619137838086028L;
    public static final NilReason INAPPLICABLE = new NilReason("inapplicable");
    public static final NilReason MISSING = new NilReason("missing");
    public static final NilReason TEMPLATE = new NilReason("template");
    public static final NilReason UNKNOWN = new NilReason("unknown");
    public static final NilReason WITHHELD = new NilReason("withheld");
    public static final NilReason OTHER = new NilReason("other");
    private static final NilReason[] PREDEFINED = new NilReason[]{INAPPLICABLE, MISSING, TEMPLATE, UNKNOWN, WITHHELD, OTHER};
    private static final WeakHashSet<NilReason> POOL = WeakHashSet.newInstance(NilReason.class);
    private final Object reason;
    private transient InvocationHandler handler;

    private NilReason(Object object) {
        this.reason = object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NilReason[] values() {
        int n;
        NilReason[] nilReasonArray;
        int n2 = PREDEFINED.length;
        WeakHashSet<NilReason> weakHashSet = POOL;
        synchronized (weakHashSet) {
            nilReasonArray = POOL.toArray(new NilReason[n2 + POOL.size()]);
        }
        for (n = nilReasonArray.length; n != 0 && nilReasonArray[n - 1] == null; --n) {
        }
        NilReason[] nilReasonArray2 = nilReasonArray;
        if ((n += n2) != nilReasonArray.length) {
            nilReasonArray = new NilReason[n];
        }
        System.arraycopy(nilReasonArray2, 0, nilReasonArray, n2, n - n2);
        System.arraycopy(PREDEFINED, 0, nilReasonArray, 0, n2);
        return nilReasonArray;
    }

    public static NilReason valueOf(String string) throws URISyntaxException {
        int n = (string = string.trim()).indexOf(58);
        if (n < 0) {
            for (NilReason nilReason : PREDEFINED) {
                if (!string.equalsIgnoreCase((String)nilReason.reason)) continue;
                return nilReason;
            }
        } else if (string.substring(0, n).trim().equalsIgnoreCase("other")) {
            StringBuilder stringBuilder = new StringBuilder("other:");
            int n2 = string.length();
            while (++n < n2) {
                char c = string.charAt(n);
                if (!Character.isUnicodeIdentifierPart(c)) continue;
                stringBuilder.append(c);
            }
            String string2 = stringBuilder.toString();
            if (string2.isEmpty()) {
                return OTHER;
            }
            if (string2.equals(string)) {
                string2 = string;
            }
            return POOL.unique(new NilReason(string2));
        }
        return POOL.unique(new NilReason(new URI(string)));
    }

    private Object readResolve() {
        if (this.reason instanceof String) {
            for (NilReason nilReason : PREDEFINED) {
                if (!this.reason.equals(nilReason.reason)) continue;
                return nilReason;
            }
        }
        return POOL.unique(this);
    }

    public String getExplanation() {
        if (this.reason instanceof String) {
            String string = (String)this.reason;
            int n = string.indexOf(58);
            if (n >= 0) {
                return string.substring(n + 1);
            }
            if (string.equals("other")) {
                return "";
            }
        }
        return null;
    }

    public URI getURI() {
        return this.reason instanceof URI ? (URI)this.reason : null;
    }

    public String toString() {
        return this.reason.toString();
    }

    public int hashCode() {
        return this.reason.hashCode() ^ 0xB3890874;
    }

    public boolean equals(Object object) {
        if (object instanceof NilReason) {
            return this.reason.equals(((NilReason)object).reason);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T createNilObject(Class<T> clazz) {
        InvocationHandler invocationHandler;
        ArgumentChecks.ensureNonNull("type", clazz);
        if (NilObjectHandler.isIgnoredInterface(clazz)) {
            throw new IllegalArgumentException(Errors.format(73, "type", clazz));
        }
        NilReason nilReason = this;
        synchronized (nilReason) {
            invocationHandler = this.handler;
            if (invocationHandler == null) {
                this.handler = invocationHandler = new NilObjectHandler(this);
            }
        }
        return (T)Proxy.newProxyInstance(NilReason.class.getClassLoader(), new Class[]{clazz, NilObject.class, LenientComparable.class}, invocationHandler);
    }
}

