/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.io.wkt;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.text.Format;
import java.text.ParseException;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.geotoolkit.io.TableWriter;
import org.geotoolkit.io.X364;
import org.geotoolkit.io.wkt.WKTFormat;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Vocabulary;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.Strings;
import org.geotoolkit.util.converter.Classes;
import org.opengis.referencing.IdentifiedObject;

final class Definitions
extends AbstractMap<String, String>
implements Serializable {
    private static final long serialVersionUID = 2376345936250144764L;
    private final Format parser;
    private final Map<String, Parsed> definitions;
    private transient Set<Map.Entry<String, String>> entries;
    char quote = (char)34;
    private transient Replacement replacements;

    public Definitions(Format format) {
        this.parser = format;
        this.definitions = new TreeMap<String, Parsed>();
    }

    @Override
    public void clear() {
        this.definitions.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.definitions.isEmpty();
    }

    @Override
    public int size() {
        return this.definitions.size();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.definitions.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        if (object != null) {
            if (object instanceof String) {
                if (super.containsValue(object)) {
                    return true;
                }
                try {
                    object = this.parser.parseObject((String)object);
                }
                catch (ParseException parseException) {
                    return false;
                }
            }
            for (Parsed parsed : this.definitions.values()) {
                if (!object.equals(parsed.asObject)) continue;
                return true;
            }
        }
        return false;
    }

    final Object getParsed(String string) {
        Parsed parsed = this.definitions.get(string);
        return parsed != null ? parsed.asObject : null;
    }

    @Override
    public String get(Object object) {
        Parsed parsed = this.definitions.get(object);
        return parsed != null ? parsed.asString : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String put(String string, String string2) throws IllegalArgumentException {
        Parsed parsed;
        ArgumentChecks.ensureNonNull((String)"identifier", (Object)string);
        if (!Strings.isJavaIdentifier((CharSequence)string)) {
            throw new IllegalArgumentException(Errors.format((int)82, (Object)string));
        }
        if (string2 == null) throw new IllegalArgumentException(Errors.format((int)121));
        if (string2.trim().isEmpty()) {
            throw new IllegalArgumentException(Errors.format((int)121));
        }
        if (Strings.isJavaIdentifier((CharSequence)string2)) {
            Parsed parsed2 = this.definitions.get(string);
            if (parsed2 == null) throw new IllegalArgumentException(Errors.format((int)73, (Object)string, (Object)string2));
            parsed = this.definitions.put(string, parsed2);
        } else {
            Object object;
            string2 = this.substitute(string2);
            try {
                object = this.parser.parseObject(string2);
            }
            catch (ParseException parseException) {
                throw new IllegalArgumentException(Errors.format((int)72, (Object)string), parseException);
            }
            parsed = this.definitions.put(string, new Parsed(string2, object));
        }
        if (parsed == null) return null;
        String string3 = parsed.asString;
        return string3;
    }

    @Override
    public String remove(Object object) {
        Parsed parsed = this.definitions.remove(object);
        return parsed != null ? parsed.asString : null;
    }

    @Override
    public Set<String> keySet() {
        return this.definitions.keySet();
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        if (this.entries == null) {
            this.entries = new Entries(this.definitions);
        }
        return this.entries;
    }

    final String substitute(String string) {
        Replacement replacement;
        char c = this.quote;
        String string2 = null;
        this.replacements = replacement = new Replacement();
        StringBuilder stringBuilder = null;
        for (Map.Entry<String, Parsed> entry : this.definitions.entrySet()) {
            int n;
            String string3 = entry.getKey();
            Parsed parsed = entry.getValue();
            int n2 = n = stringBuilder != null ? stringBuilder.indexOf(string3) : string.indexOf(string3);
            while (n >= 0) {
                CharSequence charSequence;
                int n3 = n + string3.length();
                CharSequence charSequence2 = charSequence = stringBuilder != null ? stringBuilder : string;
                if (!(n != 0 && Character.isJavaIdentifierPart(charSequence.charAt(n - 1)) || n3 != charSequence.length() && Character.isJavaIdentifierPart(charSequence.charAt(n3)))) {
                    int n4 = 0;
                    int n5 = n;
                    while (--n5 >= 0) {
                        int n6 = n5 = stringBuilder != null ? stringBuilder.lastIndexOf(string2, n5) : string.lastIndexOf(c, n5);
                        if (n5 < 0) break;
                        ++n4;
                    }
                    if (!(n4 & true)) {
                        if (stringBuilder == null) {
                            stringBuilder = new StringBuilder(string);
                            string2 = String.valueOf(c);
                            assert (stringBuilder.indexOf(string3, n) == n);
                        }
                        String string4 = parsed.asString;
                        stringBuilder.replace(n, n3, string4);
                        int n7 = string4.length() - string3.length();
                        replacement = replacement.next = new Replacement(n, n + string4.length(), n7);
                        n = stringBuilder.indexOf(string3, n + n7);
                        continue;
                    }
                }
                n = stringBuilder != null ? stringBuilder.indexOf(string3, n) : string.indexOf(string3, n += string3.length());
            }
        }
        return stringBuilder != null ? stringBuilder.toString() : string;
    }

    final ParseException adjustErrorOffset(ParseException parseException, int n) {
        int n2 = 0;
        int n3 = parseException.getErrorOffset();
        Object object = this.replacements;
        while (object != null && n3 >= ((Replacement)object).lower) {
            if (n3 < ((Replacement)object).upper) {
                n3 = ((Replacement)object).lower;
                break;
            }
            n2 += ((Replacement)object).shift;
            object = ((Replacement)object).next;
        }
        n3 -= n2;
        if ((n3 += n) == parseException.getErrorOffset()) {
            return parseException;
        }
        object = new ParseException(parseException.getLocalizedMessage(), n3);
        ((Throwable)object).setStackTrace(parseException.getStackTrace());
        ((Throwable)object).initCause(parseException.getCause());
        return object;
    }

    final void print(Writer writer, boolean bl) throws IOException {
        Locale locale = null;
        Vocabulary vocabulary = Vocabulary.getResources(locale);
        TableWriter tableWriter = new TableWriter(writer, " \u2502 ");
        tableWriter.setMultiLinesCells(true);
        tableWriter.writeHorizontalSeparator();
        int[] nArray = new int[]{75, 28, 306, 200};
        int n = nArray.length;
        while (--n >= 0) {
            if (bl) {
                tableWriter.write(X364.BOLD.sequence());
            }
            tableWriter.write(vocabulary.getString(nArray[n]));
            if (bl) {
                tableWriter.write(X364.NORMAL.sequence());
            }
            if (n != 0) {
                tableWriter.nextColumn();
                continue;
            }
            tableWriter.nextLine();
        }
        tableWriter.writeHorizontalSeparator();
        for (Map.Entry<String, Parsed> entry : this.definitions.entrySet()) {
            Object object = entry.getValue().asObject;
            tableWriter.write(entry.getKey());
            tableWriter.nextColumn();
            Class<?> clazz = Classes.getClass((Object)object);
            String string = WKTFormat.getNameOf(clazz);
            if (string != null) {
                clazz = WKTFormat.getClassOf(string);
            } else {
                string = vocabulary.getString(309);
            }
            tableWriter.write(string);
            tableWriter.nextColumn();
            tableWriter.write(Classes.getShortName(clazz));
            tableWriter.nextColumn();
            if (object instanceof IdentifiedObject) {
                tableWriter.write(((IdentifiedObject)object).getName().getCode());
            }
            tableWriter.nextLine();
        }
        tableWriter.writeHorizontalSeparator();
        tableWriter.flush();
    }

    private static final class Iter
    implements Iterator<Map.Entry<String, String>> {
        private final Iterator<Map.Entry<String, Parsed>> iterator;

        Iter(Iterator<Map.Entry<String, Parsed>> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Map.Entry<String, String> next() {
            Map.Entry<String, Parsed> entry = this.iterator.next();
            return new AbstractMap.SimpleEntry<String, String>(entry.getKey(), entry.getValue().asString);
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    private static final class Entries
    extends AbstractSet<Map.Entry<String, String>> {
        private final Map<String, Parsed> definitions;

        Entries(Map<String, Parsed> map) {
            this.definitions = map;
        }

        @Override
        public int size() {
            return this.definitions.size();
        }

        @Override
        public Iterator<Map.Entry<String, String>> iterator() {
            return new Iter(this.definitions.entrySet().iterator());
        }
    }

    private static final class Replacement {
        public final int lower;
        public final int upper;
        public final int shift;
        public Replacement next;

        Replacement() {
            this.shift = 0;
            this.upper = 0;
            this.lower = 0;
        }

        Replacement(int n, int n2, int n3) {
            this.lower = n;
            this.upper = n2;
            this.shift = n3;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            Replacement replacement = this;
            while (replacement != null) {
                if (replacement != this) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append('[').append(replacement.lower).append("..").append(replacement.upper).append("] \u2192 ").append(replacement.shift);
                replacement = replacement.next;
            }
            return stringBuilder.toString();
        }
    }

    private static final class Parsed
    implements Serializable {
        private static final long serialVersionUID = -6622917637459216208L;
        final String asString;
        final Object asObject;

        Parsed(String string, Object object) {
            this.asString = string;
            this.asObject = object;
        }
    }
}

