/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.io.wkt;

import java.lang.reflect.Array;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Set;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Length;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import javax.measure.unit.UnitFormat;
import org.geotoolkit.internal.Citations;
import org.geotoolkit.internal.InternalUtilities;
import org.geotoolkit.io.X364;
import org.geotoolkit.io.wkt.Colors;
import org.geotoolkit.io.wkt.Convention;
import org.geotoolkit.io.wkt.Formattable;
import org.geotoolkit.io.wkt.FormattableObject;
import org.geotoolkit.io.wkt.Symbols;
import org.geotoolkit.io.wkt.UnformattableObjectException;
import org.geotoolkit.measure.Units;
import org.geotoolkit.referencing.IdentifiedObjects;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.Strings;
import org.geotoolkit.util.converter.Numbers;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.CodeList;

public class Formatter {
    private static final Class<? extends IdentifiedObject>[] AUTHORITY_EXCLUDES = new Class[]{CoordinateSystemAxis.class};
    private final Symbols symbols;
    Colors colors;
    private Convention convention = Convention.OGC;
    private Citation authority;
    private Unit<Length> linearUnit;
    private Unit<Angle> angularUnit;
    private final NumberFormat numberFormat;
    private final UnitFormat unitFormat;
    private final FieldPosition dummy = new FieldPosition(0);
    StringBuffer buffer;
    int bufferBase;
    int indentation;
    private int margin;
    private final String lineSeparator = System.getProperty("line.separator", "\n");
    private boolean lineChanged;
    private boolean invalidWKT;
    private Class<?> unformattable;
    String warning;

    public Formatter() {
        this(FormattableObject.defaultIndentation);
    }

    public Formatter(int n) {
        this(Symbols.DEFAULT, null, n);
    }

    public Formatter(Symbols symbols, Colors colors, int n) {
        ArgumentChecks.ensureNonNull((String)"symbols", (Object)symbols);
        if (n < -1) {
            throw new IllegalArgumentException(Errors.format((int)73, (Object)"indentation", (Object)n));
        }
        this.symbols = symbols;
        this.colors = colors;
        this.indentation = n;
        this.numberFormat = (NumberFormat)symbols.numberFormat.clone();
        this.unitFormat = UnitFormat.getInstance((Locale)symbols.locale);
        this.buffer = new StringBuffer();
    }

    Formatter(Symbols symbols, NumberFormat numberFormat) {
        this.symbols = symbols;
        this.indentation = FormattableObject.defaultIndentation;
        this.numberFormat = numberFormat;
        this.unitFormat = UnitFormat.getInstance((Locale)symbols.locale);
    }

    final void setConvention(Convention convention, Citation citation) {
        if (convention == null) {
            convention = Convention.forCitation(citation, Convention.OGC);
        }
        this.convention = convention;
        this.authority = citation;
    }

    private void setColor(Colors.Element element) {
        X364 x364;
        if (this.colors != null && (x364 = this.colors.get(element)) != null) {
            this.buffer.append(x364.sequence());
        }
    }

    private void resetColor() {
        if (this.colors != null) {
            this.buffer.append(X364.FOREGROUND_DEFAULT.sequence());
        }
    }

    private static Colors.Element getNameColor(IdentifiedObject identifiedObject) {
        if (identifiedObject instanceof Datum) {
            return Colors.Element.DATUM;
        }
        if (identifiedObject instanceof OperationMethod) {
            return Colors.Element.METHOD;
        }
        if (identifiedObject instanceof CoordinateSystemAxis) {
            return Colors.Element.AXIS;
        }
        return null;
    }

    private void appendSeparator(boolean bl) {
        char c;
        Symbols symbols = this.symbols;
        StringBuffer stringBuffer = this.buffer;
        int n = stringBuffer.length();
        do {
            if (n == this.bufferBase) {
                return;
            }
            if ((c = stringBuffer.charAt(--n)) != symbols.open && c != symbols.openArray) continue;
            return;
        } while (Character.isWhitespace(c) || c == symbols.space);
        stringBuffer.append(symbols.separator).append(symbols.space);
        if (bl && this.indentation > -1) {
            stringBuffer.append(this.lineSeparator).append(Strings.spaces((int)this.margin));
            this.lineChanged = true;
        }
    }

    public void append(Formattable formattable) {
        String string;
        Object object;
        Identifier identifier;
        Object object2;
        IdentifiedObject identifiedObject;
        Symbols symbols = this.symbols;
        StringBuffer stringBuffer = this.buffer;
        this.appendSeparator(true);
        int n = stringBuffer.length();
        stringBuffer.append(symbols.open);
        IdentifiedObject identifiedObject2 = identifiedObject = formattable instanceof IdentifiedObject ? (IdentifiedObject)((Object)formattable) : null;
        if (identifiedObject != null) {
            object2 = Formatter.getNameColor(identifiedObject);
            if (object2 != null) {
                this.setColor((Colors.Element)((Object)object2));
            }
            stringBuffer.append(symbols.quote).append(this.getName(identifiedObject)).append(symbols.quote);
            if (object2 != null) {
                this.resetColor();
            }
        }
        this.indent(1);
        this.lineChanged = false;
        object2 = formattable.formatWKT(this);
        if (this.colors != null && this.invalidWKT) {
            this.invalidWKT = false;
            identifier = this.colors.get(Colors.Element.ERROR);
            if (identifier != null) {
                object = identifier.sequence();
                stringBuffer.insert(n, (String)object + X364.BACKGROUND_DEFAULT.sequence());
                n += ((String)object).length();
            }
        }
        stringBuffer.insert(n, (String)object2);
        identifier = this.getIdentifier(identifiedObject);
        if (identifier != null && Formatter.isAuthorityAllowed(identifiedObject) && (object = identifier.getAuthority()) != null && (string = Citations.getIdentifier((Citation)object)) != null) {
            this.appendSeparator(this.lineChanged);
            stringBuffer.append("AUTHORITY").append(symbols.open).append(symbols.quote).append(string).append(symbols.quote);
            String string2 = identifier.getCode();
            if (string2 != null) {
                stringBuffer.append(symbols.separator).append(symbols.quote).append(string2).append(symbols.quote);
            }
            stringBuffer.append(symbols.close);
        }
        stringBuffer.append(symbols.close);
        this.lineChanged = true;
        this.indent(-1);
    }

    public void append(IdentifiedObject identifiedObject) {
        if (!(identifiedObject instanceof Formattable)) {
            throw Formatter.unsupported(identifiedObject);
        }
        this.append((Formattable)((Object)identifiedObject));
    }

    public void append(MathTransform mathTransform) {
        if (!(mathTransform instanceof Formattable)) {
            throw Formatter.unsupported(mathTransform);
        }
        this.append((Formattable)((Object)mathTransform));
    }

    private static UnformattableObjectException unsupported(Object object) {
        Class<?> clazz = object.getClass();
        return new UnformattableObjectException(Errors.format((int)76, clazz, Formattable.class), clazz);
    }

    public void append(CodeList<?> codeList) {
        if (codeList != null) {
            this.appendSeparator(false);
            this.setColor(Colors.Element.CODE_LIST);
            String string = codeList.name();
            boolean bl = string.indexOf(32) >= 0;
            Symbols symbols = this.symbols;
            StringBuffer stringBuffer = this.buffer;
            if (bl) {
                stringBuffer.append(symbols.quote);
            }
            stringBuffer.append(string);
            if (bl) {
                stringBuffer.append(symbols.quote);
                this.setInvalidWKT(codeList.getClass());
            }
            this.resetColor();
        }
    }

    public void append(GeneralParameterValue generalParameterValue) {
        if (generalParameterValue instanceof ParameterValueGroup) {
            for (GeneralParameterValue parameterDescriptor : ((ParameterValueGroup)generalParameterValue).values()) {
                this.append(parameterDescriptor);
            }
        }
        if (generalParameterValue instanceof ParameterValue) {
            Unit<Length> unit;
            ParameterValue parameterValue = (ParameterValue)generalParameterValue;
            ParameterDescriptor parameterDescriptor = parameterValue.getDescriptor();
            Unit<?> unit2 = parameterDescriptor.getUnit();
            Object object = unit2;
            if (object != null && !Unit.ONE.equals(object)) {
                unit = this.linearUnit;
                if (unit != null && object.isCompatible(unit)) {
                    object = unit;
                } else {
                    unit = this.convention.forcedAngularUnit;
                    if (unit == null) {
                        unit = this.angularUnit;
                    }
                    if (unit != null && object.isCompatible(unit)) {
                        object = unit;
                    }
                }
            }
            this.appendSeparator(true);
            unit = this.symbols;
            StringBuffer stringBuffer = this.buffer;
            int n = stringBuffer.length();
            stringBuffer.append("PARAMETER");
            int n2 = stringBuffer.length();
            stringBuffer.append(unit.open);
            this.setColor(Colors.Element.PARAMETER);
            unit.getClass();
            StringBuffer stringBuffer2 = stringBuffer.append('\"').append(this.getName(parameterDescriptor));
            unit.getClass();
            stringBuffer2.append('\"');
            this.resetColor();
            StringBuffer stringBuffer3 = stringBuffer.append(unit.separator);
            unit.getClass();
            stringBuffer3.append(' ');
            if (object != null) {
                double d;
                try {
                    d = parameterValue.doubleValue((Unit<?>)object);
                }
                catch (IllegalStateException illegalStateException) {
                    X364 x364;
                    if (this.colors != null && (x364 = this.colors.get(Colors.Element.ERROR)) != null) {
                        stringBuffer.insert(n2, X364.BACKGROUND_DEFAULT.sequence()).insert(n, x364.sequence());
                    }
                    this.warning = illegalStateException.getLocalizedMessage();
                    d = Double.NaN;
                }
                if (!object.equals(unit2)) {
                    d = InternalUtilities.adjustForRoundingError((double)d, (double)360000.0, (int)9);
                }
                this.format(d);
            } else {
                this.appendObject(parameterValue.getValue());
            }
            stringBuffer.append(unit.close);
        }
    }

    private void appendObject(Object object) {
        StringBuffer stringBuffer = this.buffer;
        if (object == null) {
            stringBuffer.append("null");
            return;
        }
        Symbols symbols = this.symbols;
        if (object.getClass().isArray()) {
            stringBuffer.append(symbols.openArray);
            int n = Array.getLength(object);
            for (int i = 0; i < n; ++i) {
                if (i != 0) {
                    stringBuffer.append(symbols.separator).append(symbols.space);
                }
                this.appendObject(Array.get(object, i));
            }
            stringBuffer.append(symbols.closeArray);
            return;
        }
        if (object instanceof Number) {
            this.format((Number)object);
        } else if (object instanceof Boolean) {
            stringBuffer.append((Boolean)object != false ? "TRUE" : "FALSE");
        } else {
            stringBuffer.append(symbols.quote).append(object).append(symbols.quote);
        }
    }

    public void append(long l) {
        this.appendSeparator(false);
        this.format(l);
    }

    public void append(double d) {
        this.appendSeparator(false);
        this.format(d);
    }

    public void append(Unit<?> unit) {
        if (unit != null) {
            StringBuffer stringBuffer = this.buffer;
            Symbols symbols = this.symbols;
            this.appendSeparator(this.lineChanged);
            stringBuffer.append("UNIT").append(symbols.open);
            this.setColor(Colors.Element.UNIT);
            stringBuffer.append(symbols.quote);
            if (NonSI.DEGREE_ANGLE.equals(unit)) {
                stringBuffer.append("degree");
            } else if (SI.METRE.equals(unit)) {
                stringBuffer.append(this.convention.unitUS ? "meter" : "metre");
            } else {
                this.unitFormat.format(unit, stringBuffer, this.dummy);
            }
            stringBuffer.append(symbols.quote);
            this.resetColor();
            this.append(Units.toStandardUnit(unit));
            stringBuffer.append(symbols.close);
        }
    }

    public void append(String string) {
        this.appendSeparator(false);
        this.buffer.append(this.symbols.quote).append(string).append(this.symbols.quote);
    }

    private void format(Number number) {
        if (Numbers.isInteger(number.getClass())) {
            this.format(number.longValue());
        } else {
            this.format(number.doubleValue());
        }
    }

    private void format(long l) {
        this.setColor(Colors.Element.INTEGER);
        NumberFormat numberFormat = this.numberFormat;
        int n = numberFormat.getMinimumFractionDigits();
        numberFormat.setMinimumFractionDigits(0);
        numberFormat.format(l, this.buffer, this.dummy);
        numberFormat.setMinimumFractionDigits(n);
        this.resetColor();
    }

    private void format(double d) {
        d = InternalUtilities.adjustForRoundingError((double)d);
        this.setColor(Colors.Element.NUMBER);
        this.numberFormat.format(d, this.buffer, this.dummy);
        this.resetColor();
    }

    private void indent(int n) {
        this.margin = Math.max(0, this.margin + this.indentation * n);
    }

    private static boolean isAuthorityAllowed(IdentifiedObject identifiedObject) {
        for (int i = 0; i < AUTHORITY_EXCLUDES.length; ++i) {
            if (!AUTHORITY_EXCLUDES[i].isInstance(identifiedObject)) continue;
            return false;
        }
        return true;
    }

    public Identifier getIdentifier(IdentifiedObject identifiedObject) {
        Set<ReferenceIdentifier> set;
        Identifier identifier = null;
        if (identifiedObject != null && (set = identifiedObject.getIdentifiers()) != null) {
            for (Identifier identifier2 : set) {
                if (Citations.identifierMatches((Citation)this.getAuthority(), (Citation)identifier2.getAuthority())) {
                    return identifier2;
                }
                if (identifier != null) continue;
                identifier = identifier2;
            }
        }
        return identifier;
    }

    public String getName(IdentifiedObject identifiedObject) {
        String string = IdentifiedObjects.getName(identifiedObject, this.getAuthority());
        if (string == null) {
            string = IdentifiedObjects.getName(identifiedObject, null);
        }
        return string;
    }

    public Unit<Length> getLinearUnit() {
        return this.linearUnit;
    }

    public void setLinearUnit(Unit<Length> unit) throws IllegalArgumentException {
        if (unit != null && !Units.isLinear(unit)) {
            throw new IllegalArgumentException(Errors.format((int)135, unit));
        }
        this.linearUnit = unit;
    }

    public Unit<Angle> getAngularUnit() {
        return this.angularUnit;
    }

    public void setAngularUnit(Unit<Angle> unit) throws IllegalArgumentException {
        if (unit != null && !Units.isAngular(unit)) {
            throw new IllegalArgumentException(Errors.format((int)128, unit));
        }
        this.angularUnit = unit;
    }

    private Citation getAuthority() {
        Citation citation = this.authority;
        if (citation == null) {
            Convention convention = this.convention;
            if (convention == Convention.INTERNAL) {
                convention = Convention.OGC;
            }
            this.authority = citation = convention.getCitation();
        }
        return citation;
    }

    public Convention getConvention() {
        return this.convention;
    }

    public boolean isInvalidWKT() {
        return this.unformattable != null || this.buffer != null && this.buffer.length() == 0;
    }

    final Class<?> getUnformattableClass() {
        return this.unformattable;
    }

    public void setInvalidWKT(Class<?> clazz) {
        this.unformattable = clazz;
        this.invalidWKT = true;
    }

    public String toString() {
        return this.buffer.toString();
    }

    public void clear() {
        if (this.buffer != null) {
            this.buffer.setLength(0);
        }
        this.linearUnit = null;
        this.angularUnit = null;
        this.unformattable = null;
        this.warning = null;
        this.invalidWKT = false;
        this.lineChanged = false;
        this.margin = 0;
    }
}

