/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.metadata.iso.lineage;

import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.internal.jaxb.gmi.LE_Source;
import org.geotoolkit.metadata.iso.MetadataEntity;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.identification.RepresentativeFraction;
import org.opengis.metadata.lineage.NominalResolution;
import org.opengis.metadata.lineage.ProcessStep;
import org.opengis.metadata.lineage.Source;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.util.InternationalString;

@ThreadSafe
@XmlType(name="LI_Source_Type", propOrder={"description", "scaleDenominator", "sourceCitation", "sourceExtents", "sourceSteps", "processedLevel", "resolution"})
@XmlRootElement(name="LI_Source")
@XmlSeeAlso(value={LE_Source.class})
public class DefaultSource
extends MetadataEntity
implements Source {
    private static final long serialVersionUID = 6277132009549470021L;
    private InternationalString description;
    private RepresentativeFraction scaleDenominator;
    private ReferenceSystem sourceReferenceSystem;
    private Citation sourceCitation;
    private Collection<Extent> sourceExtents;
    private Collection<ProcessStep> sourceSteps;
    private Identifier processedLevel;
    private NominalResolution resolution;

    public DefaultSource() {
    }

    public DefaultSource(Source source) {
        super(source);
    }

    public DefaultSource(InternationalString internationalString) {
        this.setDescription(internationalString);
    }

    public static DefaultSource castOrCopy(Source source) {
        return source == null || source instanceof DefaultSource ? (DefaultSource)source : new DefaultSource(source);
    }

    @Override
    @XmlElement(name="description")
    public synchronized InternationalString getDescription() {
        return this.description;
    }

    public synchronized void setDescription(InternationalString internationalString) {
        this.checkWritePermission();
        this.description = internationalString;
    }

    @Override
    @XmlElement(name="scaleDenominator")
    public synchronized RepresentativeFraction getScaleDenominator() {
        return this.scaleDenominator;
    }

    public synchronized void setScaleDenominator(RepresentativeFraction representativeFraction) {
        this.checkWritePermission();
        this.scaleDenominator = representativeFraction;
    }

    @Override
    public synchronized ReferenceSystem getSourceReferenceSystem() {
        return this.sourceReferenceSystem;
    }

    public synchronized void setSourceReferenceSystem(ReferenceSystem referenceSystem) {
        this.checkWritePermission();
        this.sourceReferenceSystem = referenceSystem;
    }

    @Override
    @XmlElement(name="sourceCitation")
    public synchronized Citation getSourceCitation() {
        return this.sourceCitation;
    }

    public synchronized void setSourceCitation(Citation citation) {
        this.checkWritePermission();
        this.sourceCitation = citation;
    }

    @XmlElement(name="sourceExtent")
    public synchronized Collection<Extent> getSourceExtents() {
        this.sourceExtents = this.nonNullCollection(this.sourceExtents, Extent.class);
        return this.sourceExtents;
    }

    public synchronized void setSourceExtents(Collection<? extends Extent> collection) {
        this.sourceExtents = this.copyCollection(collection, this.sourceExtents, Extent.class);
    }

    @XmlElement(name="sourceStep")
    public synchronized Collection<ProcessStep> getSourceSteps() {
        this.sourceSteps = this.nonNullCollection(this.sourceSteps, ProcessStep.class);
        return this.sourceSteps;
    }

    public synchronized void setSourceSteps(Collection<? extends ProcessStep> collection) {
        this.sourceSteps = this.copyCollection(collection, this.sourceSteps, ProcessStep.class);
    }

    @Override
    @XmlElement(name="processedLevel", namespace="http://www.isotc211.org/2005/gmi")
    public synchronized Identifier getProcessedLevel() {
        return this.processedLevel;
    }

    public synchronized void setProcessedLevel(Identifier identifier) {
        this.checkWritePermission();
        this.processedLevel = identifier;
    }

    @Override
    @XmlElement(name="resolution", namespace="http://www.isotc211.org/2005/gmi")
    public synchronized NominalResolution getResolution() {
        return this.resolution;
    }

    public synchronized void setResolution(NominalResolution nominalResolution) {
        this.checkWritePermission();
        this.resolution = nominalResolution;
    }
}

