/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.factory;

import java.awt.RenderingHints;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.referencing.factory.AbstractAuthorityFactory;
import org.geotoolkit.referencing.factory.ReferencingFactoryContainer;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.ObjectFactory;

@ThreadSafe
public abstract class DirectAuthorityFactory
extends AbstractAuthorityFactory {
    protected final ReferencingFactoryContainer factories;
    private volatile boolean hintsInitialized;

    protected DirectAuthorityFactory(ReferencingFactoryContainer referencingFactoryContainer) {
        super(EMPTY_HINTS);
        this.factories = referencingFactoryContainer;
        DirectAuthorityFactory.ensureNonNull("factories", referencingFactoryContainer);
    }

    protected DirectAuthorityFactory(Hints hints) {
        super(hints);
        this.factories = ReferencingFactoryContainer.instance(hints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<RenderingHints.Key, ?> getImplementationHints() {
        if (!this.hintsInitialized) {
            Map<RenderingHints.Key, ?> map = this.factories.getImplementationHints();
            DirectAuthorityFactory directAuthorityFactory = this;
            synchronized (directAuthorityFactory) {
                if (!this.hintsInitialized) {
                    this.hintsInitialized = true;
                    this.hints.putAll(map);
                }
            }
        }
        return super.getImplementationHints();
    }

    @Override
    final Collection<? super AuthorityFactory> dependencies() {
        ReferencingFactoryContainer referencingFactoryContainer = this.factories;
        if (referencingFactoryContainer != null) {
            LinkedHashSet<ObjectFactory> linkedHashSet = new LinkedHashSet<ObjectFactory>(8);
            linkedHashSet.add(referencingFactoryContainer.getCRSFactory());
            linkedHashSet.add(referencingFactoryContainer.getCSFactory());
            linkedHashSet.add(referencingFactoryContainer.getDatumFactory());
            return linkedHashSet;
        }
        return super.dependencies();
    }
}

