/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.factory.web;

import java.util.Collections;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import net.jcip.annotations.Immutable;
import org.geotoolkit.measure.Units;
import org.geotoolkit.referencing.crs.DefaultGeographicCRS;
import org.geotoolkit.referencing.cs.DefaultAffineCS;
import org.geotoolkit.referencing.cs.DefaultCartesianCS;
import org.geotoolkit.referencing.factory.ReferencingFactoryContainer;
import org.geotoolkit.referencing.factory.web.Code;
import org.geotoolkit.referencing.operation.DefiningConversion;
import org.geotoolkit.resources.Errors;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.util.FactoryException;

@Immutable
abstract class Factlet {
    Factlet() {
    }

    public abstract int code();

    public abstract String getName();

    public abstract String getClassification();

    public final ProjectedCRS create(Code code, ReferencingFactoryContainer referencingFactoryContainer) throws FactoryException {
        DefaultAffineCS defaultAffineCS = DefaultCartesianCS.PROJECTED;
        Unit<?> unit = code.unit;
        if (!SI.METRE.equals(unit)) {
            if (!Units.isLinear(unit)) {
                throw new NoSuchAuthorityCodeException(Errors.format((int)135, unit), code.authority, String.valueOf(code.code), code.toString());
            }
            defaultAffineCS = defaultAffineCS.usingUnit((Unit)unit);
        }
        String string = this.getClassification();
        ParameterValueGroup parameterValueGroup = referencingFactoryContainer.getMathTransformFactory().getDefaultParameters(string);
        this.setProjectionParameters(parameterValueGroup, code);
        String string2 = this.getName();
        DefiningConversion definingConversion = new DefiningConversion(string2, parameterValueGroup);
        return referencingFactoryContainer.getCRSFactory().createProjectedCRS(Collections.singletonMap("name", string2), DefaultGeographicCRS.WGS84, definingConversion, (CartesianCS)((Object)defaultAffineCS));
    }

    protected abstract void setProjectionParameters(ParameterValueGroup var1, Code var2);
}

