/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.factory;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import javax.imageio.spi.ServiceRegistry;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.factory.AuthorityFactoryFinder;
import org.geotoolkit.factory.DynamicFactoryRegistry;
import org.geotoolkit.factory.Factories;
import org.geotoolkit.factory.FactoryPrinter;
import org.geotoolkit.factory.FactoryRegistry;
import org.geotoolkit.factory.FactoryRegistryException;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.factory.ShutdownHook;
import org.geotoolkit.internal.Citations;
import org.geotoolkit.internal.LazySet;
import org.geotoolkit.lang.Static;
import org.opengis.feature.FeatureFactory;
import org.opengis.feature.type.FeatureTypeFactory;
import org.opengis.filter.FilterFactory;
import org.opengis.geometry.PositionFactory;
import org.opengis.geometry.aggregate.AggregateFactory;
import org.opengis.geometry.complex.ComplexFactory;
import org.opengis.geometry.coordinate.GeometryFactory;
import org.opengis.geometry.primitive.PrimitiveFactory;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.CitationFactory;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.style.StyleFactory;
import org.opengis.temporal.TemporalFactory;
import org.opengis.util.Factory;
import org.opengis.util.NameFactory;

@ThreadSafe
public class FactoryFinder
extends Static {
    public static final Hints.Key FILTER_KEY = new Hints.Key(ServiceRegistry.Filter.class);
    static FactoryRegistry registry;

    FactoryFinder() {
    }

    static Hints mergeSystemHints(Hints hints) {
        if (hints == null) {
            hints = new Hints();
        } else if (hints.containsKey(FILTER_KEY) || hints.getClass() != Hints.class) {
            hints = hints.clone();
        }
        return hints;
    }

    static FactoryRegistry getServiceRegistry() {
        assert (Thread.holdsLock(FactoryFinder.class));
        FactoryRegistry factoryRegistry = registry;
        if (factoryRegistry == null) {
            factoryRegistry = new DynamicFactoryRegistry(new Class[]{NameFactory.class, CitationFactory.class, DatumFactory.class, CSFactory.class, CRSFactory.class, MathTransformFactory.class, CoordinateOperationFactory.class, TemporalFactory.class, PositionFactory.class, PrimitiveFactory.class, GeometryFactory.class, ComplexFactory.class, AggregateFactory.class, FeatureTypeFactory.class, FeatureFactory.class, FilterFactory.class, StyleFactory.class, DatumAuthorityFactory.class, CSAuthorityFactory.class, CRSAuthorityFactory.class, CoordinateOperationAuthorityFactory.class}){

                @Override
                void pluginScanned(Class<?> clazz) {
                    VendorFilter vendorFilter = new VendorFilter("org.geotoolkit.", true, true);
                    VendorFilter vendorFilter2 = new VendorFilter("org.geotools.", true, false);
                    this.setOrdering(clazz, vendorFilter, vendorFilter2);
                }
            };
            ShutdownHook.register(factoryRegistry);
            registry = factoryRegistry;
        }
        return factoryRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> Set<T> getFactories(Class<T> clazz, Hints hints, Hints.ClassKey classKey) {
        hints = FactoryFinder.mergeSystemHints(hints);
        ServiceRegistry.Filter filter = (ServiceRegistry.Filter)hints.remove(FILTER_KEY);
        Class<FactoryFinder> clazz2 = FactoryFinder.class;
        synchronized (FactoryFinder.class) {
            Iterator<T> iterator = FactoryFinder.getServiceRegistry().getServiceProviders(clazz, filter, hints, classKey);
            // ** MonitorExit[var5_4] (shouldn't be in output)
            return new LazySet<T>(iterator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T getFactory(Class<T> clazz, Hints hints, Hints.ClassKey classKey) throws FactoryRegistryException {
        hints = FactoryFinder.mergeSystemHints(hints);
        ServiceRegistry.Filter filter = (ServiceRegistry.Filter)hints.remove(FILTER_KEY);
        Class<FactoryFinder> clazz2 = FactoryFinder.class;
        synchronized (FactoryFinder.class) {
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return FactoryFinder.getServiceRegistry().getServiceProvider(clazz, filter, hints, classKey);
        }
    }

    public static NameFactory getNameFactory(Hints hints) throws FactoryRegistryException {
        return FactoryFinder.getFactory(NameFactory.class, hints, Hints.NAME_FACTORY);
    }

    public static Set<NameFactory> getNameFactories(Hints hints) {
        return FactoryFinder.getFactories(NameFactory.class, hints, Hints.NAME_FACTORY);
    }

    public static CitationFactory getCitationFactory(Hints hints) throws FactoryRegistryException {
        return FactoryFinder.getFactory(CitationFactory.class, hints, Hints.CITATION_FACTORY);
    }

    public static Set<CitationFactory> getCitationFactories(Hints hints) {
        return FactoryFinder.getFactories(CitationFactory.class, hints, Hints.CITATION_FACTORY);
    }

    public static DatumFactory getDatumFactory(Hints hints) throws FactoryRegistryException {
        return FactoryFinder.getFactory(DatumFactory.class, hints, Hints.DATUM_FACTORY);
    }

    public static Set<DatumFactory> getDatumFactories(Hints hints) {
        return FactoryFinder.getFactories(DatumFactory.class, hints, Hints.DATUM_FACTORY);
    }

    public static CSFactory getCSFactory(Hints hints) throws FactoryRegistryException {
        return FactoryFinder.getFactory(CSFactory.class, hints, Hints.CS_FACTORY);
    }

    public static Set<CSFactory> getCSFactories(Hints hints) {
        return FactoryFinder.getFactories(CSFactory.class, hints, Hints.CS_FACTORY);
    }

    public static CRSFactory getCRSFactory(Hints hints) throws FactoryRegistryException {
        return FactoryFinder.getFactory(CRSFactory.class, hints, Hints.CRS_FACTORY);
    }

    public static Set<CRSFactory> getCRSFactories(Hints hints) {
        return FactoryFinder.getFactories(CRSFactory.class, hints, Hints.CRS_FACTORY);
    }

    public static CoordinateOperationFactory getCoordinateOperationFactory(Hints hints) throws FactoryRegistryException {
        return FactoryFinder.getFactory(CoordinateOperationFactory.class, hints, Hints.COORDINATE_OPERATION_FACTORY);
    }

    public static Set<CoordinateOperationFactory> getCoordinateOperationFactories(Hints hints) {
        return FactoryFinder.getFactories(CoordinateOperationFactory.class, hints, Hints.COORDINATE_OPERATION_FACTORY);
    }

    public static MathTransformFactory getMathTransformFactory(Hints hints) throws FactoryRegistryException {
        return FactoryFinder.getFactory(MathTransformFactory.class, hints, Hints.MATH_TRANSFORM_FACTORY);
    }

    public static Set<MathTransformFactory> getMathTransformFactories(Hints hints) {
        return FactoryFinder.getFactories(MathTransformFactory.class, hints, Hints.MATH_TRANSFORM_FACTORY);
    }

    public static TemporalFactory getTemporalFactory(Hints hints) throws FactoryRegistryException {
        return FactoryFinder.getFactory(TemporalFactory.class, hints, Hints.TEMPORAL_FACTORY);
    }

    public static Set<TemporalFactory> getTemporalFactories(Hints hints) {
        return FactoryFinder.getFactories(TemporalFactory.class, hints, Hints.TEMPORAL_FACTORY);
    }

    public static PositionFactory getPositionFactory(Hints hints) throws FactoryRegistryException {
        return FactoryFinder.getFactory(PositionFactory.class, hints, Hints.POSITION_FACTORY);
    }

    public static Set<PositionFactory> getPositionFactories(Hints hints) {
        return FactoryFinder.getFactories(PositionFactory.class, hints, Hints.POSITION_FACTORY);
    }

    public static PrimitiveFactory getPrimitiveFactory(Hints hints) throws FactoryRegistryException {
        return FactoryFinder.getFactory(PrimitiveFactory.class, hints, Hints.PRIMITIVE_FACTORY);
    }

    public static Set<PrimitiveFactory> getPrimitiveFactories(Hints hints) {
        return FactoryFinder.getFactories(PrimitiveFactory.class, hints, Hints.PRIMITIVE_FACTORY);
    }

    public static GeometryFactory getGeometryFactory(Hints hints) throws FactoryRegistryException {
        return FactoryFinder.getFactory(GeometryFactory.class, hints, Hints.GEOMETRY_FACTORY);
    }

    public static Set<GeometryFactory> getGeometryFactories(Hints hints) {
        return FactoryFinder.getFactories(GeometryFactory.class, hints, Hints.GEOMETRY_FACTORY);
    }

    public static ComplexFactory getComplexFactory(Hints hints) throws FactoryRegistryException {
        return FactoryFinder.getFactory(ComplexFactory.class, hints, Hints.COMPLEX_FACTORY);
    }

    public static Set<ComplexFactory> getComplexFactories(Hints hints) {
        return FactoryFinder.getFactories(ComplexFactory.class, hints, Hints.COMPLEX_FACTORY);
    }

    public static AggregateFactory getAggregateFactory(Hints hints) throws FactoryRegistryException {
        return FactoryFinder.getFactory(AggregateFactory.class, hints, Hints.AGGREGATE_FACTORY);
    }

    public static Set<AggregateFactory> getAggregateFactories(Hints hints) {
        return FactoryFinder.getFactories(AggregateFactory.class, hints, Hints.AGGREGATE_FACTORY);
    }

    public static FeatureTypeFactory getFeatureTypeFactory(Hints hints) throws FactoryRegistryException {
        return FactoryFinder.getFactory(FeatureTypeFactory.class, hints, Hints.FEATURE_TYPE_FACTORY);
    }

    public static Set<FeatureTypeFactory> getFeatureTypeFactories(Hints hints) {
        return FactoryFinder.getFactories(FeatureTypeFactory.class, hints, Hints.FEATURE_TYPE_FACTORY);
    }

    public static FeatureFactory getFeatureFactory(Hints hints) throws FactoryRegistryException {
        return FactoryFinder.getFactory(FeatureFactory.class, hints, Hints.FEATURE_FACTORY);
    }

    public static Set<FeatureFactory> getFeatureFactories(Hints hints) {
        return FactoryFinder.getFactories(FeatureFactory.class, hints, Hints.FEATURE_FACTORY);
    }

    public static FilterFactory getFilterFactory(Hints hints) throws FactoryRegistryException {
        return FactoryFinder.getFactory(FilterFactory.class, hints, Hints.FILTER_FACTORY);
    }

    public static Set<FilterFactory> getFilterFactories(Hints hints) {
        return FactoryFinder.getFactories(FilterFactory.class, hints, Hints.FILTER_FACTORY);
    }

    public static StyleFactory getStyleFactory(Hints hints) throws FactoryRegistryException {
        return FactoryFinder.getFactory(StyleFactory.class, hints, Hints.STYLE_FACTORY);
    }

    public static Set<StyleFactory> getStyleFactories(Hints hints) {
        return FactoryFinder.getFactories(StyleFactory.class, hints, Hints.STYLE_FACTORY);
    }

    public static boolean setVendorOrdering(String string, String string2) {
        return FactoryFinder.setOrUnsetOrdering(string, string2, false, true);
    }

    public static boolean unsetVendorOrdering(String string, String string2) {
        return FactoryFinder.setOrUnsetOrdering(string, string2, false, false);
    }

    public static boolean setImplementationOrdering(String string, String string2) {
        return FactoryFinder.setOrUnsetOrdering(string, string2, true, true);
    }

    public static boolean unsetImplementationOrdering(String string, String string2) {
        return FactoryFinder.setOrUnsetOrdering(string, string2, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean setOrUnsetOrdering(String string, String string2, boolean bl, boolean bl2) {
        VendorFilter vendorFilter = new VendorFilter(string, bl, true);
        VendorFilter vendorFilter2 = new VendorFilter(string2, bl, false);
        Class<FactoryFinder> clazz = FactoryFinder.class;
        synchronized (FactoryFinder.class) {
            boolean bl3 = FactoryFinder.getServiceRegistry().setOrUnsetOrdering(Factory.class, vendorFilter, (ServiceRegistry.Filter)vendorFilter2, bl2);
            // ** MonitorExit[var7_6] (shouldn't be in output)
            if (bl3) {
                Factories.fireConfigurationChanged(AuthorityFactoryFinder.class);
            }
            return bl3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRegistered(Object object) {
        Class<FactoryFinder> clazz = FactoryFinder.class;
        synchronized (FactoryFinder.class) {
            Object obj = FactoryFinder.getServiceRegistry().getServiceProviderByClass(object.getClass());
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return object.equals(obj);
        }
    }

    public static synchronized void listProviders(Writer writer, Locale locale) throws IOException {
        new FactoryPrinter(Collections.singleton(FactoryFinder.getServiceRegistry())).list(writer, locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scanForPlugins() {
        Class<AuthorityFactoryFinder> clazz = AuthorityFactoryFinder.class;
        synchronized (AuthorityFactoryFinder.class) {
            AuthorityFactoryFinder.authorityNames = null;
            Class<FactoryFinder> clazz2 = FactoryFinder.class;
            synchronized (FactoryFinder.class) {
                if (registry != null) {
                    registry.scanForPlugins();
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
            {
                Factories.fireConfigurationChanged(FactoryFinder.class);
                return;
            }
        }
    }

    private static final class VendorFilter
    implements ServiceRegistry.Filter {
        private final String vendor;
        private final boolean byPackageName;
        private final boolean defaultValue;

        public VendorFilter(String string, boolean bl, boolean bl2) {
            this.vendor = string;
            this.byPackageName = bl;
            this.defaultValue = bl2;
        }

        @Override
        public boolean filter(Object object) {
            Citation citation;
            if (this.byPackageName) {
                return object.getClass().getName().startsWith(this.vendor);
            }
            if (object instanceof Factory && (citation = ((Factory)object).getVendor()) != null) {
                return Citations.titleMatches(citation, this.vendor);
            }
            return this.defaultValue;
        }
    }
}

