/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.simple;

import java.io.Serializable;
import java.net.URI;
import javax.measure.unit.Unit;
import org.geotoolkit.util.Cloneable;
import org.opengis.parameter.InvalidParameterTypeException;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;

public class SimpleParameterValue<T>
implements ParameterValue<T>,
Cloneable,
Serializable {
    private static final long serialVersionUID = -8445712722603023516L;
    protected final ParameterDescriptor<T> descriptor;
    protected T value;

    public SimpleParameterValue(ParameterDescriptor<T> parameterDescriptor) {
        this.descriptor = parameterDescriptor;
    }

    @Override
    public void setValue(Object object) throws IllegalArgumentException {
        try {
            this.value = this.descriptor.getValueClass().cast(object);
        }
        catch (ClassCastException classCastException) {
            IllegalArgumentException illegalArgumentException = this.invalidValue(object);
            illegalArgumentException.initCause(classCastException);
            throw illegalArgumentException;
        }
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public Unit<?> getUnit() {
        return null;
    }

    @Override
    public double doubleValue(Unit<?> unit) {
        throw this.invalidType();
    }

    @Override
    public double doubleValue() {
        throw this.invalidType();
    }

    @Override
    public int intValue() {
        throw this.invalidType();
    }

    @Override
    public boolean booleanValue() {
        throw this.invalidType();
    }

    @Override
    public String stringValue() {
        throw this.invalidType();
    }

    @Override
    public double[] doubleValueList(Unit<?> unit) {
        throw this.invalidType();
    }

    @Override
    public double[] doubleValueList() {
        throw this.invalidType();
    }

    @Override
    public int[] intValueList() {
        throw this.invalidType();
    }

    @Override
    public URI valueFile() {
        throw this.invalidType();
    }

    @Override
    public void setValue(double d, Unit<?> unit) {
        throw this.invalidValue(d);
    }

    @Override
    public void setValue(double d) {
        throw this.invalidValue(d);
    }

    @Override
    public void setValue(int n) {
        throw this.invalidValue(n);
    }

    @Override
    public void setValue(boolean bl) {
        throw this.invalidValue(bl);
    }

    @Override
    public void setValue(double[] dArray, Unit<?> unit) {
        throw this.invalidValue(dArray);
    }

    @Override
    public ParameterDescriptor<T> getDescriptor() {
        return this.descriptor;
    }

    private String getParameterName() {
        return this.descriptor.getName().getCode();
    }

    private IllegalStateException invalidType() {
        return new InvalidParameterTypeException(null, this.getParameterName());
    }

    private IllegalArgumentException invalidValue(Object object) {
        throw new InvalidParameterValueException(null, this.getParameterName(), object);
    }

    @Override
    public ParameterValue<T> clone() {
        try {
            return (ParameterValue)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }

    public String toString() {
        return "ParameterValue<" + this.descriptor.getValueClass().getSimpleName() + ">[\"" + this.getParameterName() + "\"]";
    }
}

