/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry.jts.coordinatesequence;

import org.geotoolkit.geometry.jts.coordinatesequence.CSBuilder;
import org.geotoolkit.geometry.jts.coordinatesequence.DefaultCSBuilder;

public class CSBuilderFactory {
    private static Class defaultBuilderClass;

    public static CSBuilder getDefaultBuilder() {
        try {
            return (CSBuilder)CSBuilderFactory.getDefaultBuilderClass().newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create a coordinate sequence builder", e);
        }
    }

    private static Class getDefaultBuilderClass() {
        if (defaultBuilderClass == null) {
            defaultBuilderClass = DefaultCSBuilder.class;
        }
        return defaultBuilderClass;
    }

    public static void setDefaultBuilderClass(Class builderClass) {
        if (!CSBuilder.class.isAssignableFrom(builderClass)) {
            throw new RuntimeException(builderClass.getName() + " does not implement the CSBuilder interface");
        }
        defaultBuilderClass = builderClass;
    }
}

