/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry.jts;

import java.util.Set;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.opengis.metadata.Identifier;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.FactoryException;

public final class SRIDGenerator {
    private static final String AUTHORITY_CRS = "CRS";
    private static final String AUTHORITY_EPSG = "EPSG";

    private SRIDGenerator() {
    }

    public static int toSRID(CoordinateReferenceSystem crs, Version version) {
        Set ids = crs.getIdentifiers();
        if (ids.isEmpty()) {
            return 0;
        }
        Identifier id = (Identifier)ids.iterator().next();
        String authority = id.getCodeSpace();
        int code = Integer.valueOf(id.getCode());
        if (version == Version.V1) {
            int authorityCode;
            if (AUTHORITY_EPSG.equalsIgnoreCase(authority)) {
                authorityCode = 0;
            } else if (AUTHORITY_CRS.equalsIgnoreCase(authority)) {
                authorityCode = 1;
            } else {
                throw new IllegalArgumentException("unknowed authority : " + authority);
            }
            int compact = authorityCode << 28 | code;
            return compact;
        }
        throw new IllegalArgumentException("unknowed compact version : " + version);
    }

    public static int toSRID(String srs, Version version) {
        int index = srs.lastIndexOf(58);
        if (index <= 0) {
            throw new IllegalArgumentException("CRS code doesnt match pattern Authority:Code : " + srs);
        }
        String authority = srs.substring(0, index);
        int code = Integer.parseInt(srs.substring(index + 1, srs.length()));
        if (version == Version.V1) {
            int authorityCode;
            if (AUTHORITY_EPSG.equalsIgnoreCase(authority)) {
                authorityCode = 0;
            } else if (AUTHORITY_CRS.equalsIgnoreCase(authority)) {
                authorityCode = 1;
            } else {
                try {
                    CoordinateReferenceSystem crs = CRS.forCode((String)srs);
                    Integer epsgCode = IdentifiedObjects.lookupEPSG((IdentifiedObject)crs);
                    if (epsgCode == null) {
                        throw new IllegalArgumentException("unknowed authority : " + authority);
                    }
                    authorityCode = 0;
                    code = epsgCode;
                }
                catch (NoSuchAuthorityCodeException ex) {
                    throw new IllegalArgumentException("unknowed authority : " + srs);
                }
                catch (FactoryException ex) {
                    throw new IllegalArgumentException("unknowed authority : " + srs);
                }
            }
            int compact = authorityCode << 28 | code;
            return compact;
        }
        throw new IllegalArgumentException("unknowed compact version : " + version);
    }

    public static int toSRID(byte[] buffer, int offset) {
        if (buffer[offset] == Version.V1.code) {
            return SRIDGenerator.toInt(buffer, offset + 1);
        }
        throw new IllegalArgumentException("unknowed compact version : " + buffer[offset]);
    }

    public static int toInt(byte[] buffer, int offset) {
        int compact = (buffer[offset] & 0xFF) << 24;
        compact |= (buffer[offset + 1] & 0xFF) << 16;
        compact |= (buffer[offset + 2] & 0xFF) << 8;
        return compact |= buffer[offset + 3] & 0xFF;
    }

    public static String toSRS(int srid, Version version) {
        if (version == Version.V1) {
            String authority;
            int authorityCode = srid >>> 28;
            if (authorityCode == 0) {
                authority = AUTHORITY_EPSG;
            } else if (authorityCode == 1) {
                authority = AUTHORITY_CRS;
            } else {
                throw new IllegalArgumentException("unknown authority : " + authorityCode);
            }
            int code = srid & 0xFFFFFFF;
            return authority + ':' + code;
        }
        throw new IllegalArgumentException("unknowed compact version : " + version);
    }

    public static String toSRS(byte[] buffer, int offset) {
        if (buffer[offset] == Version.V1.code) {
            int srid = SRIDGenerator.toInt(buffer, offset + 1);
            return SRIDGenerator.toSRS(srid, Version.V1);
        }
        throw new IllegalArgumentException("unknowed compact version : " + buffer[0]);
    }

    public static byte[] toBytes(CoordinateReferenceSystem crs, Version version) {
        int srid = SRIDGenerator.toSRID(crs, version);
        return SRIDGenerator.toBytes(srid, version);
    }

    public static byte[] toBytes(int srid, Version version) {
        byte[] buffer = new byte[5];
        buffer[0] = version.code;
        SRIDGenerator.toBytes(srid, buffer, 1);
        return buffer;
    }

    public static byte[] toBytes(int compact, byte[] buffer, int offset) {
        buffer[offset] = (byte)(compact >>> 24);
        buffer[offset + 1] = (byte)(compact >>> 16);
        buffer[offset + 2] = (byte)(compact >>> 8);
        buffer[offset + 3] = (byte)compact;
        return buffer;
    }

    public static enum Version {
        V1(1);

        final byte code;

        private Version(byte code) {
            this.code = code;
        }
    }
}

