/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry.math;

import org.geotoolkit.geometry.math.Tuple;
import org.geotoolkit.geometry.math.Vectors;

public interface Vector
extends Tuple {
    public double length();

    public double lengthSquare();

    public void normalize();

    public void add(Tuple var1);

    public void subtract(Tuple var1);

    public void scale(double var1);

    default public Vector cross(Tuple other) {
        double[] v1 = this.toArrayDouble();
        double[] v2 = other.toArrayDouble();
        double[] buffer = new double[v1.length];
        Vectors.cross(v1, v2, buffer);
        Vector res = Vectors.createDouble(buffer.length);
        res.set(buffer);
        return res;
    }

    default public double dot(Tuple other) {
        double dot = 0.0;
        int n = this.getDimension();
        for (int i = 0; i < n; ++i) {
            dot += this.get(i) * other.get(i);
        }
        return dot;
    }
}

