/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.RenderedImage;
import java.util.Arrays;
import org.apache.sis.coverage.grid.CoordinateOperationFinder;
import org.apache.sis.coverage.grid.DerivedGridCoverage;
import org.apache.sis.coverage.grid.GridClippingMode;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridCoverage2D;
import org.apache.sis.coverage.grid.GridCoverageProcessor;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.GridRoundingMode;
import org.apache.sis.coverage.grid.TranslatedGridCoverage;
import org.apache.sis.geometry.AbstractEnvelope;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.image.ImageProcessor;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.internal.referencing.DirectPositionView;
import org.apache.sis.internal.referencing.ExtendedPrecisionMatrix;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.operation.transform.TransformSeparator;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.opengis.coverage.CannotEvaluateException;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

final class ResampledGridCoverage
extends DerivedGridCoverage {
    private static final int BIDIMENSIONAL = 2;
    private final MathTransform toSourceCorner;
    private final MathTransform toSourceCenter;
    private final long[] toSourceDimensions;
    private final ImageProcessor imageProcessor;
    private final int supportSizeX;
    private final int supportSizeY;

    private ResampledGridCoverage(GridCoverage source, GridGeometry domain, MathTransform toSourceCorner, MathTransform toSourceCenter, CoordinateOperationFinder changeOfCRS, ImageProcessor processor) {
        super(source, domain);
        this.toSourceCorner = toSourceCorner;
        this.toSourceCenter = toSourceCenter;
        this.toSourceDimensions = ResampledGridCoverage.findDependentDimensions(toSourceCenter, domain);
        processor = processor.clone();
        processor.setFillValues(this.getBackground());
        changeOfCRS.setAccuracyOf(processor);
        this.imageProcessor = GridCoverageProcessor.unique(processor);
        Dimension s = this.imageProcessor.getInterpolation().getSupportSize();
        this.supportSizeX = s.width;
        this.supportSizeY = s.height;
    }

    private static long[] findDependentDimensions(MathTransform mt, GridGeometry domain) {
        int srcDim = mt.getSourceDimensions();
        if (srcDim <= 2) {
            return null;
        }
        Matrix derivative = MathTransforms.getMatrix((MathTransform)mt);
        if (derivative == null) {
            try {
                derivative = mt.derivative((DirectPosition)new DirectPositionView.Double(domain.getExtent().getPointOfInterest(PixelInCell.CELL_CENTER)));
            }
            catch (TransformException e) {
                GridCoverageProcessor.recoverableException("resample", (Exception)((Object)e));
                return null;
            }
        }
        int tgtDim = mt.getTargetDimensions();
        long[] usage = new long[srcDim];
        for (int i = 0; i < srcDim; ++i) {
            for (int j = 0; j < tgtDim; ++j) {
                if (derivative.getElement(j, i) == 0.0) continue;
                if (j >= 64) {
                    throw GridGeometry.excessiveDimension(mt);
                }
                int n = i;
                usage[n] = usage[n] | 1L << j;
            }
        }
        return usage;
    }

    private static long[] getIntegerTranslation(MathTransform toSource) {
        Matrix m = MathTransforms.getMatrix((MathTransform)toSource);
        if (m == null || !Matrices.isTranslation((Matrix)m)) {
            return null;
        }
        int tc = m.getNumCol() - 1;
        long[] translation = new long[m.getNumRow() - 1];
        int j = translation.length;
        while (--j >= 0) {
            double v = m.getElement(j, tc);
            translation[j] = Math.round(v);
            if ((double)translation[j] == v) continue;
            return null;
        }
        return translation;
    }

    private GridCoverage specialize(boolean allowGeometryReplacement, boolean allowOperationReplacement) throws TransformException {
        MathTransform gridToCRS;
        GridCoverage c;
        long[] translation;
        if (allowOperationReplacement && ((translation = ResampledGridCoverage.getIntegerTranslation(this.toSourceCenter)) != null || (translation = ResampledGridCoverage.getIntegerTranslation(this.toSourceCorner)) != null) && (c = TranslatedGridCoverage.create(this.source, this.gridGeometry, translation, false)) != null) {
            return c;
        }
        GridExtent extent = this.gridGeometry.getExtent();
        if (extent.getDimension() < 2 || extent.getSubDimension() > 2) {
            return this;
        }
        if (allowGeometryReplacement && this.toSourceCorner instanceof LinearTransform && (gridToCRS = this.gridGeometry.getGridToCRS(PixelInCell.CELL_CORNER)) instanceof LinearTransform) {
            GridGeometry targetGG;
            GridGeometry sourceGG = this.source.getGridGeometry();
            if (sourceGG.equals(targetGG = new GridGeometry(extent = sourceGG.getExtent(), PixelInCell.CELL_CORNER, gridToCRS = MathTransforms.concatenate((MathTransform)this.toSourceCorner.inverse(), (MathTransform)gridToCRS), this.getCoordinateReferenceSystem()), ComparisonMode.APPROXIMATE)) {
                return this.source;
            }
            return new GridCoverage2D(this.source, targetGG, extent, this.source.render(null));
        }
        return new GridCoverage2D(this.source, this.gridGeometry, extent, this.render(null));
    }

    static boolean equivalent(GridGeometry sourceGG, GridGeometry targetGG) {
        return !(ResampledGridCoverage.isDefined(sourceGG, targetGG, 4) && !Utilities.equalsIgnoreMetadata(sourceGG.getExtent(), targetGG.getExtent()) || ResampledGridCoverage.isDefined(sourceGG, targetGG, 1) && !Utilities.equalsIgnoreMetadata(sourceGG.getCoordinateReferenceSystem(), targetGG.getCoordinateReferenceSystem()) || ResampledGridCoverage.isDefined(sourceGG, targetGG, 8) && !Utilities.equalsIgnoreMetadata(sourceGG.getGridToCRS(PixelInCell.CELL_CORNER), targetGG.getGridToCRS(PixelInCell.CELL_CORNER)) && !Utilities.equalsIgnoreMetadata(sourceGG.getGridToCRS(PixelInCell.CELL_CENTER), targetGG.getGridToCRS(PixelInCell.CELL_CENTER)) || ResampledGridCoverage.isDefined(sourceGG, targetGG, 2) && !ResampledGridCoverage.isDefined(sourceGG, targetGG, 12) && !sourceGG.equalsApproximately(targetGG.envelope));
    }

    private static boolean isDefined(GridGeometry sourceGG, GridGeometry targetGG, int property) {
        return targetGG.isDefined(property) && sourceGG.isDefined(property);
    }

    static GridCoverage create(GridCoverage source, GridGeometry target, ImageProcessor processor, boolean allowOperationReplacement) throws FactoryException, TransformException {
        MathTransform targetCenterToCRS;
        GridExtent targetExtent;
        GridGeometry sourceGG = source.getGridGeometry();
        CoordinateOperationFinder changeOfCRS = new CoordinateOperationFinder(sourceGG, target);
        changeOfCRS.verifyPresenceOfCRS(true);
        MathTransform sourceCornerToCRS = changeOfCRS.gridToCRS();
        MathTransform crsToSourceCorner = changeOfCRS.inverse();
        changeOfCRS.setAnchor(PixelInCell.CELL_CENTER);
        MathTransform sourceCenterToCRS = changeOfCRS.gridToCRS();
        MathTransform crsToSourceCenter = changeOfCRS.inverse();
        boolean isGeometryExplicit = target.isDefined(4);
        GridExtent gridExtent = targetExtent = isGeometryExplicit ? target.getExtent() : null;
        if (target.isDefined(8)) {
            isGeometryExplicit = true;
            targetCenterToCRS = target.getGridToCRS(PixelInCell.CELL_CENTER);
            if (targetExtent == null) {
                targetExtent = ResampledGridCoverage.targetExtent(sourceGG.getExtent(), sourceCornerToCRS, target.getGridToCRS(PixelInCell.CELL_CORNER).inverse(), false);
            }
        } else {
            GridExtent sourceExtent = sourceGG.getExtent();
            double[] sourcePOI = sourceExtent.getPointOfInterest(PixelInCell.CELL_CENTER);
            double[] targetPOI = new double[sourceCenterToCRS.getTargetDimensions()];
            MatrixSIS vectors = MatrixSIS.castOrCopy((Matrix)MathTransforms.derivativeAndTransform((MathTransform)sourceCenterToCRS, (double[])sourcePOI, (int)0, (double[])targetPOI, (int)0));
            double[] originToPOI = vectors.multiply(sourcePOI);
            MatrixSIS magnitudes = vectors.normalizeColumns();
            int crsDim = vectors.getNumRow();
            int gridDim = target.getDimension();
            int mappedDim = Math.min(magnitudes.getNumCol(), Math.min(crsDim, gridDim));
            MatrixSIS crsToGrid = Matrices.create((int)(gridDim + 1), (int)(crsDim + 1), (Number[])ExtendedPrecisionMatrix.CREATE_ZERO);
            int[] dimSelect = gridDim > crsDim && targetExtent != null ? targetExtent.getSubspaceDimensions(crsDim) : null;
            while (true) {
                int i;
                double max = -1.0;
                int sign = 1;
                int tgDim = -1;
                int tcDim = -1;
                for (i = 0; i < mappedDim; ++i) {
                    int ci = dimSelect != null ? dimSelect[i] : i;
                    for (int j = 0; j < crsDim; ++j) {
                        double v = vectors.getElement(j, ci);
                        double m = Math.abs(v);
                        if (!(m > max)) continue;
                        max = m;
                        sign = v < 0.0 ? -1 : 1;
                        tcDim = j;
                        tgDim = ci;
                    }
                }
                if (tgDim < 0) break;
                for (int j = 0; j < crsDim; ++j) {
                    vectors.setElement(j, tgDim, Double.NaN);
                }
                for (i = 0; i < gridDim; ++i) {
                    vectors.setElement(tcDim, i, Double.NaN);
                }
                DoubleDouble m = DoubleDouble.of(sign);
                m = m.divide(magnitudes.getNumber(0, tgDim), false);
                crsToGrid.setNumber(tgDim, tcDim, (Number)m);
                m = m.multiply(DoubleDouble.sum(originToPOI[tcDim], -targetPOI[tcDim]));
                crsToGrid.setNumber(tgDim, crsDim, (Number)m);
            }
            crsToGrid.setElement(gridDim, crsDim, 1.0);
            GridExtent tentative = ResampledGridCoverage.targetExtent(sourceExtent, sourceCornerToCRS, (MathTransform)MathTransforms.linear((Matrix)crsToGrid), true);
            if (targetExtent == null) {
                if (tentative.startsAtZero()) {
                    targetExtent = tentative;
                } else {
                    long[] coordinates = new long[gridDim * 2];
                    for (int i = 0; i < gridDim; ++i) {
                        coordinates[i + gridDim] = tentative.getSize(i) - 1L;
                    }
                    targetExtent = new GridExtent(tentative, coordinates);
                }
            }
            for (int j = 0; j < gridDim; ++j) {
                DoubleDouble span = DoubleDouble.of(targetExtent.getSize(j));
                DoubleDouble scale = DoubleDouble.of(tentative.getSize(j));
                scale = span.divide(scale);
                DoubleDouble offset = DoubleDouble.of(targetExtent.getLow(j));
                offset = offset.subtract(scale.multiply(tentative.getLow(j)));
                crsToGrid.convertAfter(j, (Number)scale, (Number)offset);
            }
            targetCenterToCRS = MathTransforms.linear((Matrix)crsToGrid.inverse());
        }
        GridGeometry complete = target;
        ComparisonMode mode = ComparisonMode.IGNORE_METADATA;
        if (!target.isDefined(13)) {
            CoordinateReferenceSystem targetCRS = changeOfCRS.getTargetCRS();
            complete = new GridGeometry(targetExtent, PixelInCell.CELL_CENTER, targetCenterToCRS, targetCRS);
            mode = ComparisonMode.APPROXIMATE;
            if (target.isDefined(2)) {
                MathTransform targetCornerToCRS = complete.getGridToCRS(PixelInCell.CELL_CORNER);
                GeneralEnvelope bounds = new GeneralEnvelope(complete.getEnvelope());
                bounds.intersect(target.getEnvelope());
                bounds = Envelopes.transform((MathTransform)targetCornerToCRS.inverse(), (Envelope)bounds);
                targetExtent = new GridExtent((AbstractEnvelope)bounds, GridRoundingMode.NEAREST, GridClippingMode.STRICT, null, null, targetExtent, null);
                complete = new GridGeometry(targetExtent, PixelInCell.CELL_CENTER, targetCenterToCRS, targetCRS);
                isGeometryExplicit = true;
            }
        }
        if (sourceGG.equals(complete, mode)) {
            return source;
        }
        MathTransform targetCornerToCRS = complete.getGridToCRS(PixelInCell.CELL_CORNER);
        ResampledGridCoverage resampled = new ResampledGridCoverage(source, complete, MathTransforms.concatenate((MathTransform)targetCornerToCRS, (MathTransform)crsToSourceCorner), MathTransforms.concatenate((MathTransform)targetCenterToCRS, (MathTransform)crsToSourceCenter), changeOfCRS, processor);
        return resampled.specialize(!isGeometryExplicit, allowOperationReplacement);
    }

    private static GridExtent targetExtent(GridExtent source, MathTransform cornerToCRS, MathTransform crsToGrid, boolean center) throws TransformException {
        MathTransform sourceToTarget = MathTransforms.concatenate((MathTransform)cornerToCRS, (MathTransform)crsToGrid);
        GeneralEnvelope bounds = source.toEnvelope(sourceToTarget, sourceToTarget, null);
        if (center) {
            double[] vector = new double[bounds.getDimension()];
            Arrays.fill(vector, 0.5);
            bounds.translate(vector);
        }
        return new GridExtent((AbstractEnvelope)bounds, GridRoundingMode.NEAREST, GridClippingMode.STRICT, null, null, null, null);
    }

    @Override
    public RenderedImage render(GridExtent sliceExtent) {
        MathTransform toSource;
        GridExtent sourceExtent;
        int height;
        int width;
        if (sliceExtent == null) {
            sliceExtent = this.gridGeometry.getExtent();
        }
        try {
            int[] resampledDimensions = sliceExtent.getSubspaceDimensions(2);
            width = Math.toIntExact(sliceExtent.getSize(resampledDimensions[0]));
            height = Math.toIntExact(sliceExtent.getSize(resampledDimensions[1]));
            GeneralEnvelope sourceBounds = sliceExtent.toEnvelope(this.toSourceCorner, this.toSourceCenter, null);
            int dimension = sourceBounds.getDimension();
            if (sourceBounds.isEmpty()) {
                GridExtent se = this.source.gridGeometry.getExtent();
                for (int i = 0; i < dimension; ++i) {
                    double min = sourceBounds.getMinimum(i);
                    double max = sourceBounds.getMaximum(i);
                    if (Double.isNaN(min)) {
                        min = se.getLow(i);
                    }
                    if (Double.isNaN(max)) {
                        max = se.getHigh(i);
                    }
                    sourceBounds.setRange(i, min, max);
                }
            }
            int sourceDimX = 0;
            int sourceDimY = 1;
            if (this.toSourceDimensions != null) {
                int i;
                long mask = 0L;
                for (int i2 : resampledDimensions) {
                    mask |= this.toSourceDimensions[i2];
                }
                sourceDimX = Long.numberOfTrailingZeros(mask);
                sourceDimY = Long.numberOfTrailingZeros(mask & (1L << sourceDimX ^ 0xFFFFFFFFFFFFFFFFL));
                if (sourceDimY >= dimension) {
                    if (sourceDimX >= dimension) {
                        sourceDimX = 0;
                    }
                    sourceDimY = sourceDimX != 0 ? 0 : 1;
                    mask = 1L << sourceDimX | 1L << sourceDimY;
                }
                mask ^= 0xFFFFFFFFFFFFFFFFL;
                while ((i = Long.numberOfTrailingZeros(mask)) < dimension) {
                    double median = sourceBounds.getMedian(i);
                    if (Double.isFinite(median)) {
                        sourceBounds.setRange(i, median, median);
                    }
                    mask &= 1L << i ^ 0xFFFFFFFFFFFFFFFFL;
                }
            }
            int[] margin = new int[dimension];
            margin[sourceDimX] = this.supportSizeX;
            margin[sourceDimY] = this.supportSizeY;
            sourceExtent = new GridExtent((AbstractEnvelope)sourceBounds, GridRoundingMode.ENCLOSING, null, margin, null, null, null);
            TransformSeparator sep = new TransformSeparator(this.toSourceCenter);
            sep.addSourceDimensions(resampledDimensions);
            sep.addTargetDimensions(new int[]{sourceDimX, sourceDimY});
            sep.setSourceExpandable(true);
            MathTransform toSourceSlice = sep.separate();
            int[] requiredSources = sep.getSourceDimensions();
            if (requiredSources.length > 2) {
                MatrixSIS m = Matrices.createZero((int)(requiredSources.length + 1), (int)3);
                m.setElement(requiredSources.length, 2, 1.0);
                for (int j = 0; j < requiredSources.length; ++j) {
                    int r = requiredSources[j];
                    int i = Arrays.binarySearch(resampledDimensions, r);
                    if (i >= 0) {
                        m.setElement(j, i, 1.0);
                        continue;
                    }
                    long low = sliceExtent.getLow(r);
                    if (low == sliceExtent.getHigh(r)) {
                        m.setElement(j, 2, (double)low);
                        continue;
                    }
                    throw new CannotEvaluateException(Resources.format((short)63, sliceExtent.getAxisIdentification(r, r)));
                }
                toSourceSlice = MathTransforms.concatenate((MathTransform)MathTransforms.linear((Matrix)m), (MathTransform)toSourceSlice);
            }
            LinearTransform resampledToGrid = MathTransforms.translation((double[])new double[]{sliceExtent.getLow(resampledDimensions[0]), sliceExtent.getLow(resampledDimensions[1])});
            LinearTransform gridToSource = MathTransforms.translation((double[])new double[]{Math.negateExact(sourceExtent.getLow(sourceDimX)), Math.negateExact(sourceExtent.getLow(sourceDimY))});
            toSource = MathTransforms.concatenate((MathTransform)resampledToGrid, (MathTransform)toSourceSlice, (MathTransform)gridToSource);
        }
        catch (ArithmeticException | TransformException | FactoryException e) {
            throw new CannotEvaluateException(e.getLocalizedMessage(), e);
        }
        RenderedImage values = this.source.render(sourceExtent);
        return this.imageProcessor.resample(values, new Rectangle(width, height), toSource);
    }
}

