/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import org.apache.sis.feature.DefaultAssociationRole;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.Field;
import org.apache.sis.feature.FieldType;
import org.apache.sis.feature.MultiValuedAssociation;
import org.apache.sis.feature.SingletonAssociation;
import org.apache.sis.feature.Validator;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureAssociation;
import org.opengis.feature.FeatureAssociationRole;
import org.opengis.feature.FeatureType;
import org.opengis.feature.InvalidPropertyValueException;
import org.opengis.feature.MultiValuedPropertyException;
import org.opengis.feature.PropertyType;
import org.opengis.metadata.quality.DataQuality;
import org.opengis.util.GenericName;

public abstract class AbstractAssociation
extends Field<Feature>
implements FeatureAssociation,
Cloneable,
Serializable {
    private static final long serialVersionUID = 5992169056331267867L;
    final FeatureAssociationRole role;

    protected AbstractAssociation(FeatureAssociationRole role) {
        this.role = role;
    }

    public static AbstractAssociation create(FeatureAssociationRole role) {
        ArgumentChecks.ensureNonNull("role", role);
        return AbstractAssociation.isSingleton(role.getMaximumOccurs()) ? new SingletonAssociation(role) : new MultiValuedAssociation(role);
    }

    static AbstractAssociation create(FeatureAssociationRole role, Object value) {
        ArgumentChecks.ensureNonNull("role", role);
        return AbstractAssociation.isSingleton(role.getMaximumOccurs()) ? new SingletonAssociation(role, (Feature)value) : new MultiValuedAssociation(role, value);
    }

    public GenericName getName() {
        return this.role.getName();
    }

    public FeatureAssociationRole getRole() {
        return this.role;
    }

    @Override
    public abstract Feature getValue() throws MultiValuedPropertyException;

    @Override
    public Collection<Feature> getValues() {
        return super.getValues();
    }

    @Override
    public abstract void setValue(Feature var1) throws InvalidPropertyValueException;

    @Override
    public void setValues(Collection<? extends Feature> values) throws InvalidPropertyValueException {
        super.setValues(values);
    }

    final void ensureValid(FeatureType base, FeatureType type) {
        if (base != type && !DefaultFeatureType.maybeAssignableFrom(base, type)) {
            throw new InvalidPropertyValueException(Resources.format((short)26, this.getName(), base.getName(), type.getName()));
        }
    }

    public DataQuality quality() {
        Validator v = new Validator(null);
        v.validate(this.role, this.getValues());
        return v.quality;
    }

    public String toString() {
        final String pt = DefaultAssociationRole.getTitleProperty(this.role);
        final Iterator<Feature> it = this.getValues().iterator();
        return FieldType.toString(AbstractAssociation.isDeprecated((PropertyType)this.role), "FeatureAssociation", this.role.getName(), DefaultAssociationRole.getValueTypeName(this.role), new Iterator<Object>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public Object next() {
                return ((Feature)it.next()).getPropertyValue(pt);
            }
        }).toString();
    }

    public AbstractAssociation clone() throws CloneNotSupportedException {
        return (AbstractAssociation)super.clone();
    }
}

