/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.util.Classes;
import org.opengis.feature.AttributeType;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureOperationException;
import org.opengis.feature.IdentifiedType;
import org.opengis.feature.Operation;
import org.opengis.feature.Property;
import org.opengis.metadata.Identifier;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.util.GenericName;

public abstract class AbstractOperation
extends AbstractIdentifiedType
implements Operation,
BiFunction<Feature, ParameterValueGroup, Property> {
    private static final long serialVersionUID = -179930765502963170L;
    static final String RESULT_PREFIX = "result.";

    public AbstractOperation(Map<String, ?> identification) {
        super(identification);
    }

    final Map<String, Object> resultIdentification(Map<String, ?> identification) {
        HashMap<String, Object> properties = new HashMap<String, Object>(6);
        for (Map.Entry<String, ?> entry : identification.entrySet()) {
            String key = entry.getKey();
            if (key == null || !key.startsWith(RESULT_PREFIX)) continue;
            properties.put(key.substring(RESULT_PREFIX.length()), entry.getValue());
        }
        if (properties.isEmpty()) {
            properties.put("name", super.getName());
            properties.put("definition", super.getDefinition());
            properties.put("designation", super.getDesignation());
            properties.put("description", super.getDescription());
        }
        return properties;
    }

    public abstract ParameterDescriptorGroup getParameters();

    public abstract IdentifiedType getResult();

    @Override
    public abstract Property apply(Feature var1, ParameterValueGroup var2) throws FeatureOperationException;

    public Set<String> getDependencies() {
        return Collections.emptySet();
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Objects.hashCode(this.getParameters()) + Objects.hashCode(this.getResult());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (super.equals(obj)) {
            AbstractOperation that = (AbstractOperation)obj;
            return Objects.equals(this.getParameters(), that.getParameters()) && Objects.equals(this.getResult(), that.getResult());
        }
        return false;
    }

    public String toString() {
        IdentifiedType result;
        StringBuilder buffer = new StringBuilder(40).append(Classes.getShortClassName(this)).append('[');
        GenericName name = this.getName();
        if (name != null) {
            buffer.append('\u201c');
        }
        buffer.append(name);
        if (name != null) {
            buffer.append('\u201d');
        }
        if ((result = this.getResult()) != null) {
            Object type = result instanceof AttributeType ? Classes.getShortName(((AttributeType)result).getValueClass()) : result.getName();
            buffer.append(" : ").append(type);
        }
        try {
            this.formatResultFormula(buffer.append("] = "));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return buffer.toString();
    }

    void formatResultFormula(Appendable buffer) throws IOException {
        AbstractOperation.defaultFormula(this.getParameters(), buffer);
    }

    static void defaultFormula(ParameterDescriptorGroup parameters, Appendable buffer) throws IOException {
        buffer.append(parameters != null ? AbstractOperation.name(parameters.getName()) : "operation").append('(');
        if (parameters != null) {
            boolean hasMore = false;
            for (GeneralParameterDescriptor p : parameters.descriptors()) {
                if (p == null) continue;
                if (hasMore) {
                    buffer.append(", ");
                }
                buffer.append(AbstractOperation.name(p.getName()));
                hasMore = true;
            }
        }
        buffer.append(')');
    }

    private static String name(Identifier id) {
        return id != null ? id.getCode() : null;
    }
}

