/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter;

import java.util.List;
import javax.measure.IncommensurableException;
import javax.measure.Unit;
import org.apache.sis.filter.LeafExpression;
import org.apache.sis.filter.Optimization;
import org.apache.sis.internal.feature.AttributeConvention;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.internal.feature.GeometryWrapper;
import org.apache.sis.internal.feature.SpatialOperationContext;
import org.apache.sis.internal.filter.Node;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.feature.FeatureType;
import org.opengis.feature.PropertyNotFoundException;
import org.opengis.filter.Expression;
import org.opengis.filter.Filter;
import org.opengis.filter.InvalidFilterValueException;
import org.opengis.filter.Literal;
import org.opengis.filter.SpatialOperator;
import org.opengis.filter.ValueReference;
import org.opengis.geometry.Geometry;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

abstract class BinaryGeometryFilter<R, G>
extends Node
implements SpatialOperator<R>,
Optimization.OnFilter<R> {
    private static final long serialVersionUID = -7205680763469213064L;
    protected final Expression<R, GeometryWrapper<G>> expression1;
    protected final Expression<R, GeometryWrapper<G>> expression2;
    protected final SpatialOperationContext context;

    protected BinaryGeometryFilter(Geometries<G> library, Expression<R, ?> geometry1, Expression<R, ?> geometry2, Unit<?> systemUnit) {
        int index;
        GeometryWrapper value;
        Literal literal;
        ArgumentChecks.ensureNonNull("expression1", geometry1);
        ArgumentChecks.ensureNonNull("expression2", geometry2);
        Expression<R, GeometryWrapper<G>> expression1 = BinaryGeometryFilter.toGeometryWrapper(library, geometry1);
        Expression<R, GeometryWrapper<G>> expression2 = BinaryGeometryFilter.toGeometryWrapper(library, geometry2);
        if (geometry2 instanceof Literal) {
            literal = (Literal)geometry2;
            value = (GeometryWrapper)expression2.apply(null);
            index = 1;
        } else if (geometry1 instanceof Literal) {
            literal = (Literal)geometry1;
            value = (GeometryWrapper)expression1.apply(null);
            index = 0;
        } else {
            literal = null;
            value = null;
            index = -1;
        }
        try {
            GeometryWrapper gt;
            this.context = new SpatialOperationContext(null, value, systemUnit, index);
            if (value != null && (gt = this.context.transform(value)) != value) {
                LeafExpression.Transformed tr = new LeafExpression.Transformed(gt, literal);
                switch (index) {
                    case 0: {
                        expression1 = tr;
                        break;
                    }
                    case 1: {
                        expression2 = tr;
                        break;
                    }
                    default: {
                        throw new AssertionError(index);
                    }
                }
            }
        }
        catch (IncommensurableException | TransformException | FactoryException e) {
            throw new InvalidFilterValueException(e);
        }
        this.expression1 = expression1;
        this.expression2 = expression2;
    }

    protected abstract BinaryGeometryFilter<R, G> recreate(Expression<R, ?> var1, Expression<R, ?> var2);

    protected static <R, G> Expression<R, ?> original(Expression<R, GeometryWrapper<G>> expression) {
        Expression<R, ?> unwrapped = BinaryGeometryFilter.unwrap(expression);
        if (unwrapped instanceof LeafExpression.Transformed) {
            unwrapped = ((LeafExpression.Transformed)unwrapped).original;
        }
        return unwrapped;
    }

    public final Class<? super R> getResourceClass() {
        return BinaryGeometryFilter.specializedClass(this.expression1.getResourceClass(), this.expression2.getResourceClass());
    }

    public List<Expression<R, ?>> getExpressions() {
        return List.of(BinaryGeometryFilter.original(this.expression1), BinaryGeometryFilter.original(this.expression2));
    }

    @Override
    public final Filter<R> optimize(Optimization optimization) {
        boolean result;
        boolean literalIsNull;
        boolean immediate;
        Literal literal;
        Expression<R, GeometryWrapper<G>> wrapper;
        Expression<R, ?> other;
        Expression<R, ?> geometry1 = BinaryGeometryFilter.unwrap(this.expression1);
        Expression<R, ?> geometry2 = BinaryGeometryFilter.unwrap(this.expression2);
        Expression<R, ?> effective1 = optimization.apply(geometry1);
        Expression<R, ?> effective2 = optimization.apply(geometry2);
        if (effective2 instanceof Literal) {
            other = effective1;
            wrapper = this.expression2;
            literal = (Literal)effective2;
            immediate = effective1 instanceof Literal;
        } else if (effective1 instanceof Literal) {
            other = effective2;
            wrapper = this.expression1;
            literal = (Literal)effective1;
            immediate = false;
        } else {
            return this;
        }
        boolean bl = literalIsNull = literal.getValue() == null;
        if (literalIsNull) {
            result = this.negativeResult();
        } else {
            FeatureType featureType = optimization.getFeatureType();
            if (featureType != null && other instanceof ValueReference) {
                try {
                    Geometry transformed;
                    GeometryWrapper geometry;
                    CoordinateReferenceSystem targetCRS = AttributeConvention.getCRSCharacteristic(featureType, featureType.getProperty(((ValueReference)other).getXPath()));
                    if (targetCRS != null && (geometry = (GeometryWrapper)wrapper.apply(null)) != (transformed = geometry.transform(targetCRS))) {
                        literal = Optimization.literal(transformed);
                        if (literal == effective1) {
                            effective1 = literal;
                        } else {
                            effective2 = literal;
                        }
                    }
                }
                catch (PropertyNotFoundException | TransformException e) {
                    this.warning((Exception)e, true);
                }
            }
            BinaryGeometryFilter<R, G> filter = this;
            if (effective1 != geometry1 || effective2 != geometry2) {
                filter = this.recreate(effective1, effective2);
            }
            if (!immediate) {
                return filter;
            }
            result = filter.test(null);
        }
        return result ? Filter.include() : Filter.exclude();
    }

    protected abstract boolean negativeResult();
}

