/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter;

import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.sis.filter.LeafExpression;
import org.apache.sis.filter.Optimization;
import org.apache.sis.internal.filter.Node;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.filter.Expression;
import org.opengis.filter.Filter;
import org.opengis.filter.LikeOperator;

final class LikeFilter<R>
extends Node
implements LikeOperator<R>,
Optimization.OnFilter<R> {
    private static final long serialVersionUID = 4074943825474742252L;
    private final Expression<R, ?> expression;
    private final String pattern;
    private final char wildcard;
    private final char singleChar;
    private final char escape;
    private final boolean isMatchingCase;
    private final Pattern regex;

    LikeFilter(Expression<R, ?> expression, String pattern, char wildcard, char singleChar, char escape, boolean isMatchingCase) {
        ArgumentChecks.ensureNonNull("pattern", pattern);
        this.expression = expression;
        this.pattern = pattern;
        this.wildcard = wildcard;
        this.singleChar = singleChar;
        this.escape = escape;
        this.isMatchingCase = isMatchingCase;
        int n = pattern.length();
        StringBuilder sb = new StringBuilder(n * 2);
        for (int i = 0; i < n; ++i) {
            char c = pattern.charAt(i);
            if (c == wildcard) {
                sb.append(".*");
                continue;
            }
            if (c == singleChar) {
                sb.append('.');
                continue;
            }
            if (c == escape) {
                if (++i >= n) break;
                c = pattern.charAt(i);
            }
            if (LikeFilter.isMetaCharacter(c)) {
                sb.append('\\');
            }
            sb.append(c);
        }
        int flags = 448;
        if (!isMatchingCase) {
            flags |= 2;
        }
        this.regex = Pattern.compile(sb.toString(), flags);
    }

    private LikeFilter(LikeFilter<R> original, Expression<R, ?> expression) {
        this.expression = expression;
        this.pattern = original.pattern;
        this.wildcard = original.wildcard;
        this.singleChar = original.singleChar;
        this.escape = original.escape;
        this.isMatchingCase = original.isMatchingCase;
        this.regex = original.regex;
    }

    @Override
    public Filter<R> recreate(Expression<R, ?>[] effective) {
        return new LikeFilter<R>(this, effective[0]);
    }

    public Class<? super R> getResourceClass() {
        return this.expression.getResourceClass();
    }

    @Override
    protected Collection<?> getChildren() {
        return List.of(this.expression, this.pattern);
    }

    public List<Expression<R, ?>> getExpressions() {
        return List.of(this.expression, new LeafExpression.Literal(this.pattern));
    }

    public char getWildCard() {
        return this.wildcard;
    }

    public char getSingleChar() {
        return this.singleChar;
    }

    public char getEscapeChar() {
        return this.escape;
    }

    public boolean isMatchingCase() {
        return this.isMatchingCase;
    }

    public boolean test(R object) {
        Object value = this.expression.apply(object);
        return value != null && this.regex.matcher(value.toString()).matches();
    }

    static boolean isMetaCharacter(char c) {
        return c == '.' || c == '?' || c == '$' || c >= '[' && c <= '^' || c >= '(' && c <= '+' || c >= '{' && c <= '}';
    }
}

