/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.feature.esri;

import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.Line;
import com.esri.core.geometry.MultiPath;
import com.esri.core.geometry.MultiPoint;
import com.esri.core.geometry.OperatorCentroid2D;
import com.esri.core.geometry.OperatorImportFromWkb;
import com.esri.core.geometry.OperatorImportFromWkt;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.Polyline;
import com.esri.core.geometry.Segment;
import java.io.ObjectStreamException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.internal.feature.GeometryType;
import org.apache.sis.internal.feature.GeometryWrapper;
import org.apache.sis.internal.feature.esri.Wrapper;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.math.Vector;
import org.apache.sis.setup.GeometryLibrary;

public final class Factory
extends Geometries<Geometry> {
    private static final long serialVersionUID = 7832006589071845318L;
    public static final Factory INSTANCE = new Factory();

    protected Object readResolve() throws ObjectStreamException {
        return INSTANCE;
    }

    private Factory() {
        super(GeometryLibrary.ESRI, Geometry.class, Point.class, Polyline.class, Polygon.class);
    }

    @Override
    public GeometryWrapper<Geometry> castOrWrap(Object geometry) {
        return geometry == null || geometry instanceof Wrapper ? (Wrapper)geometry : new Wrapper((Geometry)geometry);
    }

    @Override
    protected GeometryWrapper<Geometry> createWrapper(Geometry geometry) {
        return new Wrapper(geometry);
    }

    @Override
    public Object createPoint(double x, double y) {
        return new Point(x, y);
    }

    @Override
    public Object createPoint(double x, double y, double z) {
        return new Point(x, y, z);
    }

    @Override
    public Geometry createPolyline(boolean polygon, int dimension, Vector ... coordinates) {
        if (dimension != 2) {
            throw new UnsupportedOperationException(Factory.unsupported(dimension));
        }
        boolean lineTo = false;
        Polyline path = new Polyline();
        for (Vector v : coordinates) {
            if (v == null) continue;
            int size = v.size();
            int i = 0;
            while (i < size) {
                double x = v.doubleValue(i++);
                double y = v.doubleValue(i++);
                if (Double.isNaN(x) || Double.isNaN(y)) {
                    lineTo = false;
                    continue;
                }
                if (lineTo) {
                    path.lineTo(x, y);
                    continue;
                }
                path.startPath(x, y);
                lineTo = true;
            }
        }
        if (polygon) {
            Polygon p = new Polygon();
            p.add((MultiPath)path, false);
            return p;
        }
        return path;
    }

    @Override
    public GeometryWrapper<Geometry> createMultiPolygon(Object[] geometries) {
        Polygon polygon = new Polygon();
        for (Object geometry : geometries) {
            polygon.add((MultiPath)Factory.unwrap(geometry), false);
        }
        return new Wrapper((Geometry)polygon);
    }

    @Override
    public GeometryWrapper<Geometry> createFromComponents(GeometryType type, Object components) {
        List<Object> data = components instanceof Collection ? (List<Object>)components : Arrays.asList((Object[])components);
        Geometry geometry = (Geometry)CollectionsExt.singletonOrNull(data);
        if (geometry == null) {
            boolean isPolygon = false;
            switch (type) {
                case MULTI_LINESTRING: 
                case LINESTRING: {
                    break;
                }
                case MULTI_POLYGON: 
                case POLYGON: {
                    isPolygon = true;
                    break;
                }
                case GEOMETRY_COLLECTION: {
                    Iterator component;
                    Iterator iterator = data.iterator();
                    while (iterator.hasNext() && (isPolygon = ((Geometry)(component = iterator.next())).getType() == Geometry.Type.Polygon)) {
                    }
                    break;
                }
                case GEOMETRY: 
                case POINT: 
                case MULTI_POINT: {
                    MultiPoint points = new MultiPoint();
                    for (Object e : data) {
                        points.add((Point)e);
                    }
                    geometry = points;
                    if (type != GeometryType.POINT) break;
                    geometry = new Point(OperatorCentroid2D.local().execute(geometry, null));
                    break;
                }
                default: {
                    throw new AssertionError((Object)type);
                }
            }
            if (geometry == null) {
                Polygon path;
                Object object = path = isPolygon ? new Polygon() : new Polyline();
                if (type.isCollection()) {
                    for (Object e : data) {
                        path.add((MultiPath)e, false);
                    }
                } else {
                    Iterator it = data.iterator();
                    if (it.hasNext()) {
                        Line line = new Line();
                        line.setEnd((Point)it.next());
                        while (it.hasNext()) {
                            line.setStartXY(line.getEndX(), line.getEndY());
                            line.setEnd((Point)it.next());
                            path.addSegment((Segment)line, false);
                        }
                    }
                }
                geometry = path;
            }
        }
        return new Wrapper(geometry);
    }

    @Override
    public GeometryWrapper<Geometry> parseWKT(String wkt) {
        return new Wrapper(OperatorImportFromWkt.local().execute(0, Geometry.Type.Unknown, wkt, null));
    }

    @Override
    public GeometryWrapper<Geometry> parseWKB(ByteBuffer data) {
        return new Wrapper(OperatorImportFromWkb.local().execute(0, Geometry.Type.Unknown, data, null));
    }
}

