/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.gml.xml;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.sis.util.NullArgumentException;
import org.geotoolkit.gml.xml.AbstractGeometricAggregate;
import org.geotoolkit.gml.xml.AbstractRing;
import org.geotoolkit.gml.xml.AbstractTimePosition;
import org.geotoolkit.gml.xml.BoundingShape;
import org.geotoolkit.gml.xml.Envelope;
import org.geotoolkit.gml.xml.FeatureCollection;
import org.geotoolkit.gml.xml.FeatureProperty;
import org.geotoolkit.gml.xml.LineString;
import org.geotoolkit.gml.xml.LinearRing;
import org.geotoolkit.gml.xml.MultiPoint;
import org.geotoolkit.gml.xml.Point;
import org.geotoolkit.gml.xml.Polygon;
import org.geotoolkit.gml.xml.TimeIndeterminateValueType;
import org.geotoolkit.gml.xml.v311.AbstractRingType;
import org.geotoolkit.gml.xml.v311.CoordinatesType;
import org.geotoolkit.gml.xml.v311.EnvelopeType;
import org.geotoolkit.gml.xml.v311.FeatureCollectionType;
import org.geotoolkit.gml.xml.v311.LineStringPropertyType;
import org.geotoolkit.gml.xml.v311.LineStringType;
import org.geotoolkit.gml.xml.v311.MultiLineStringType;
import org.geotoolkit.gml.xml.v311.MultiPolygonType;
import org.geotoolkit.gml.xml.v311.PointType;
import org.geotoolkit.gml.xml.v311.PolygonPropertyType;
import org.geotoolkit.gml.xml.v311.TimeInstantType;
import org.geotoolkit.gml.xml.v321.BoundingShapeType;
import org.geotoolkit.gml.xml.v321.CurvePropertyType;
import org.geotoolkit.gml.xml.v321.DirectPositionListType;
import org.geotoolkit.gml.xml.v321.DirectPositionType;
import org.geotoolkit.gml.xml.v321.FeaturePropertyType;
import org.geotoolkit.gml.xml.v321.LinearRingType;
import org.geotoolkit.gml.xml.v321.MultiCurveType;
import org.geotoolkit.gml.xml.v321.MultiPointType;
import org.geotoolkit.gml.xml.v321.MultiSurfaceType;
import org.geotoolkit.gml.xml.v321.PointPropertyType;
import org.geotoolkit.gml.xml.v321.PolygonType;
import org.geotoolkit.gml.xml.v321.SurfacePropertyType;
import org.geotoolkit.gml.xml.v321.TimePeriodType;
import org.geotoolkit.gml.xml.v321.TimePositionType;
import org.opengis.geometry.DirectPosition;
import org.opengis.temporal.Instant;
import org.opengis.temporal.Period;

public class GMLXmlFactory {
    public static Point buildPoint(String version, String id, String crsName, DirectPosition pos) {
        if ("3.2.1".equals(version)) {
            return new org.geotoolkit.gml.xml.v321.PointType(id, crsName, pos);
        }
        if ("3.1.1".equals(version)) {
            return new PointType(id, crsName, pos);
        }
        throw new IllegalArgumentException("unexpected gml version number:" + version);
    }

    public static Point buildPoint(String version, String id, DirectPosition pos) {
        if ("3.2.1".equals(version)) {
            return new org.geotoolkit.gml.xml.v321.PointType(id, pos, false);
        }
        if ("3.1.1".equals(version)) {
            return new PointType(id, pos);
        }
        throw new IllegalArgumentException("unexpected gml version number:" + version);
    }

    public static DirectPosition buildDirectPosition(String version, String srsName, Integer srsDimension, List<Double> value) {
        if ("3.2.1".equals(version)) {
            return new DirectPositionType(srsName, srsDimension, value);
        }
        if ("3.1.1".equals(version)) {
            return new org.geotoolkit.gml.xml.v311.DirectPositionType(srsName, srsDimension, value);
        }
        throw new IllegalArgumentException("unexpected gml version number:" + version);
    }

    public static MultiPoint buildMultiPoint(String version, List<Point> points, String srsName) {
        if ("3.2.1".equals(version)) {
            ArrayList<PointPropertyType> pointList = new ArrayList<PointPropertyType>();
            for (Point pt : points) {
                pointList.add(new PointPropertyType((org.geotoolkit.gml.xml.v321.PointType)pt));
            }
            return new MultiPointType(srsName, pointList);
        }
        if ("3.1.1".equals(version)) {
            ArrayList<org.geotoolkit.gml.xml.v311.PointPropertyType> pointList = new ArrayList<org.geotoolkit.gml.xml.v311.PointPropertyType>();
            for (Point pt : points) {
                pointList.add(new org.geotoolkit.gml.xml.v311.PointPropertyType((PointType)pt));
            }
            return new org.geotoolkit.gml.xml.v311.MultiPointType(srsName, pointList);
        }
        throw new IllegalArgumentException("unexpected gml version number:" + version);
    }

    public static LineString buildLineString(String version, List<Double> coordList, String srsName, Integer srsDimension) {
        if ("3.2.1".equals(version)) {
            DirectPositionListType dpList = new DirectPositionListType(coordList);
            org.geotoolkit.gml.xml.v321.LineStringType ls = new org.geotoolkit.gml.xml.v321.LineStringType((org.geotoolkit.gml.xml.v321.CoordinatesType)null);
            ls.setSrsName(srsName);
            ls.setSrsDimension(srsDimension);
            ls.setPosList(dpList);
            return ls;
        }
        if ("3.1.1".equals(version)) {
            org.geotoolkit.gml.xml.v311.DirectPositionListType dpList = new org.geotoolkit.gml.xml.v311.DirectPositionListType(coordList);
            LineStringType ls = new LineStringType((CoordinatesType)null);
            ls.setSrsName(srsName);
            ls.setSrsDimension(srsDimension);
            ls.setPosList(dpList);
            return ls;
        }
        throw new IllegalArgumentException("unexpected gml version number:" + version);
    }

    public static LineString buildLineString(String version, String id, String srsName, List<DirectPosition> pos) {
        if ("3.2.1".equals(version)) {
            return new org.geotoolkit.gml.xml.v321.LineStringType(id, srsName, pos);
        }
        if ("3.1.1".equals(version)) {
            return new LineStringType(id, srsName, pos);
        }
        throw new IllegalArgumentException("unexpected gml version number:" + version);
    }

    public static AbstractGeometricAggregate buildMultiLineString(String version, List<LineString> lines, String srsName) {
        if ("3.2.1".equals(version)) {
            ArrayList<CurvePropertyType> lineList = new ArrayList<CurvePropertyType>();
            for (LineString ls : lines) {
                lineList.add(new CurvePropertyType((org.geotoolkit.gml.xml.v321.LineStringType)ls));
            }
            return new MultiCurveType(srsName, lineList);
        }
        if ("3.1.1".equals(version)) {
            ArrayList<LineStringPropertyType> lineList = new ArrayList<LineStringPropertyType>();
            for (LineString ls : lines) {
                lineList.add(new LineStringPropertyType((LineStringType)ls));
            }
            return new MultiLineStringType(srsName, lineList);
        }
        throw new IllegalArgumentException("unexpected gml version number:" + version);
    }

    public static AbstractGeometricAggregate buildMultiPolygon(String version, List<Polygon> polygons, String srsName) {
        if ("3.2.1".equals(version)) {
            ArrayList<SurfacePropertyType> polyList = new ArrayList<SurfacePropertyType>();
            for (Polygon p : polygons) {
                polyList.add(new SurfacePropertyType((PolygonType)p));
            }
            return new MultiSurfaceType(srsName, polyList);
        }
        if ("3.1.1".equals(version)) {
            ArrayList<PolygonPropertyType> polyList = new ArrayList<PolygonPropertyType>();
            for (Polygon p : polygons) {
                polyList.add(new PolygonPropertyType((org.geotoolkit.gml.xml.v311.PolygonType)p));
            }
            return new MultiPolygonType(srsName, polyList);
        }
        throw new IllegalArgumentException("unexpected gml version number:" + version);
    }

    public static LinearRing buildLinearRing(String version, List<Double> coordList, String srsName) {
        return GMLXmlFactory.buildLinearRing(version, coordList, srsName, null);
    }

    public static LinearRing buildLinearRing(String version, List<Double> coordList, String srsName, Integer srsDimension) {
        if ("3.2.1".equals(version)) {
            DirectPositionListType dpList = new DirectPositionListType(coordList);
            LinearRingType lr = new LinearRingType(srsName, dpList);
            lr.setSrsDimension(srsDimension);
            lr.setSrsName(srsName);
            return lr;
        }
        if ("3.1.1".equals(version)) {
            org.geotoolkit.gml.xml.v311.DirectPositionListType dpList = new org.geotoolkit.gml.xml.v311.DirectPositionListType(coordList);
            org.geotoolkit.gml.xml.v311.LinearRingType lr = new org.geotoolkit.gml.xml.v311.LinearRingType(srsName, dpList);
            lr.setSrsDimension(srsDimension);
            lr.setSrsName(srsName);
            return lr;
        }
        throw new IllegalArgumentException("unexpected gml version number:" + version);
    }

    public static Polygon buildPolygon(String version, AbstractRing gmlExterior, List<AbstractRing> gmlInterior, String srsName) {
        return GMLXmlFactory.buildPolygon(version, gmlExterior, gmlInterior, srsName, null);
    }

    public static Polygon buildPolygon(String version, AbstractRing gmlExterior, List<AbstractRing> gmlInterior, String srsName, Integer srsDimension) {
        if ("3.2.1".equals(version)) {
            ArrayList<org.geotoolkit.gml.xml.v321.AbstractRingType> interiors = new ArrayList<org.geotoolkit.gml.xml.v321.AbstractRingType>();
            if (gmlInterior != null) {
                for (AbstractRing ar : gmlInterior) {
                    if (ar != null && !(ar instanceof org.geotoolkit.gml.xml.v321.AbstractRingType)) {
                        throw new IllegalArgumentException("unexpected gml version for interior ring.(" + ar.getClass().getName() + ")");
                    }
                    if (ar == null) continue;
                    interiors.add((org.geotoolkit.gml.xml.v321.AbstractRingType)ar);
                }
            }
            PolygonType po = new PolygonType(srsName, (org.geotoolkit.gml.xml.v321.AbstractRingType)gmlExterior, interiors);
            po.setSrsDimension(srsDimension);
            return po;
        }
        if ("3.1.1".equals(version)) {
            ArrayList<AbstractRingType> interiors = new ArrayList<AbstractRingType>();
            if (gmlInterior != null) {
                for (AbstractRing ar : gmlInterior) {
                    if (ar != null && !(ar instanceof AbstractRingType)) {
                        throw new IllegalArgumentException("unexpected gml version for interior ring.");
                    }
                    if (ar == null) continue;
                    interiors.add((AbstractRingType)ar);
                }
            }
            org.geotoolkit.gml.xml.v311.PolygonType po = new org.geotoolkit.gml.xml.v311.PolygonType(srsName, (AbstractRingType)gmlExterior, interiors);
            po.setSrsDimension(srsDimension);
            return po;
        }
        throw new IllegalArgumentException("unexpected gml version number:" + version);
    }

    public static Envelope buildEnvelope(String version, String id, double minx, double miny, double maxx, double maxy, String srs) {
        if ("3.2.1".equals(version)) {
            DirectPositionType lowerCorner = new DirectPositionType(minx, miny);
            DirectPositionType upperCorner = new DirectPositionType(maxx, maxy);
            return new org.geotoolkit.gml.xml.v321.EnvelopeType(lowerCorner, upperCorner, srs);
        }
        if ("3.1.1".equals(version)) {
            org.geotoolkit.gml.xml.v311.DirectPositionType lowerCorner = new org.geotoolkit.gml.xml.v311.DirectPositionType(minx, miny);
            org.geotoolkit.gml.xml.v311.DirectPositionType upperCorner = new org.geotoolkit.gml.xml.v311.DirectPositionType(maxx, maxy);
            return new EnvelopeType(id, lowerCorner, upperCorner, srs);
        }
        throw new IllegalArgumentException("unexpected gml version number:" + version);
    }

    public static Envelope buildEnvelope(String version, org.opengis.geometry.Envelope envelope) {
        if ("3.2.1".equals(version)) {
            return new org.geotoolkit.gml.xml.v321.EnvelopeType(envelope);
        }
        if ("3.1.1".equals(version)) {
            return new EnvelopeType(envelope);
        }
        throw new IllegalArgumentException("unexpected gml version number:" + version);
    }

    public static BoundingShape buildBoundingShape(String version, org.opengis.geometry.Envelope envelope) {
        if ("3.2.1".equals(version)) {
            return new BoundingShapeType(envelope);
        }
        if ("3.1.1".equals(version)) {
            return new org.geotoolkit.gml.xml.v311.BoundingShapeType(envelope);
        }
        throw new IllegalArgumentException("unexpected gml version number:" + version);
    }

    public static Period createTimePeriod(String version, String id, Period p) {
        if ("3.2.1".equals(version)) {
            return new TimePeriodType(id, p);
        }
        if ("3.1.1".equals(version)) {
            return new org.geotoolkit.gml.xml.v311.TimePeriodType(id, p);
        }
        throw new IllegalArgumentException("unexpected gml version number:" + version);
    }

    public static Period createTimePeriod(String version, String id, String dateBegin, String dateEnd) {
        if ("3.2.1".equals(version)) {
            if (dateEnd == null) {
                return new TimePeriodType(id, dateBegin);
            }
            return new TimePeriodType(id, dateBegin, dateEnd);
        }
        if ("3.1.1".equals(version)) {
            if (dateEnd == null) {
                return new org.geotoolkit.gml.xml.v311.TimePeriodType(id, dateBegin);
            }
            return new org.geotoolkit.gml.xml.v311.TimePeriodType(id, dateBegin, dateEnd);
        }
        throw new IllegalArgumentException("unexpected gml version number:" + version);
    }

    public static Period createTimePeriod(String version, Date dateBegin, Date dateEnd) {
        return GMLXmlFactory.createTimePeriod(version, null, dateBegin, dateEnd);
    }

    public static Period createTimePeriod(String version, String id, Date dateBegin, Date dateEnd) {
        if ("3.2.1".equals(version)) {
            if (dateEnd == null) {
                return new TimePeriodType(id, dateBegin);
            }
            return new TimePeriodType(id, dateBegin, dateEnd);
        }
        if ("3.1.1".equals(version)) {
            if (dateEnd == null) {
                return new org.geotoolkit.gml.xml.v311.TimePeriodType(id, dateBegin);
            }
            return new org.geotoolkit.gml.xml.v311.TimePeriodType(id, dateBegin, dateEnd);
        }
        throw new IllegalArgumentException("unexpected gml version number:" + version);
    }

    public static Period createTimePeriod(String version, AbstractTimePosition dateBegin, AbstractTimePosition dateEnd) {
        if ("3.2.1".equals(version)) {
            if (dateEnd != null && !(dateEnd instanceof TimePositionType)) {
                throw new IllegalArgumentException("unexpected gml version for date end.");
            }
            if (dateBegin != null && !(dateBegin instanceof TimePositionType)) {
                throw new IllegalArgumentException("unexpected gml version for date begin.");
            }
            if (dateEnd == null) {
                return new TimePeriodType((TimePositionType)dateBegin);
            }
            return new TimePeriodType((AbstractTimePosition)((TimePositionType)dateBegin), (AbstractTimePosition)((TimePositionType)dateEnd));
        }
        if ("3.1.1".equals(version)) {
            if (dateEnd != null && !(dateEnd instanceof org.geotoolkit.gml.xml.v311.TimePositionType)) {
                throw new IllegalArgumentException("unexpected gml version for date end.");
            }
            if (dateBegin != null && !(dateBegin instanceof org.geotoolkit.gml.xml.v311.TimePositionType)) {
                throw new IllegalArgumentException("unexpected gml version for date begin.");
            }
            if (dateEnd == null) {
                return new org.geotoolkit.gml.xml.v311.TimePeriodType((org.geotoolkit.gml.xml.v311.TimePositionType)dateBegin);
            }
            return new org.geotoolkit.gml.xml.v311.TimePeriodType(new TimeInstantType((org.geotoolkit.gml.xml.v311.TimePositionType)dateBegin), new TimeInstantType((org.geotoolkit.gml.xml.v311.TimePositionType)dateEnd));
        }
        throw new IllegalArgumentException("unexpected gml version number:" + version);
    }

    public static Instant createTimeInstant(String version, AbstractTimePosition date) {
        if ("3.2.1".equals(version)) {
            if (date != null && !(date instanceof TimePositionType)) {
                throw new IllegalArgumentException("unexpected gml version for date position.");
            }
            return new org.geotoolkit.gml.xml.v321.TimeInstantType((TimePositionType)date);
        }
        if ("3.1.1".equals(version)) {
            if (date != null && !(date instanceof org.geotoolkit.gml.xml.v311.TimePositionType)) {
                throw new IllegalArgumentException("unexpected gml version for date end.");
            }
            return new TimeInstantType((org.geotoolkit.gml.xml.v311.TimePositionType)date);
        }
        throw new IllegalArgumentException("unexpected gml version number:" + version);
    }

    public static Instant createTimeInstant(String version, String id, String date) {
        if ("3.2.1".equals(version)) {
            return new org.geotoolkit.gml.xml.v321.TimeInstantType(id, date);
        }
        if ("3.1.1".equals(version)) {
            return new TimeInstantType(id, date);
        }
        throw new IllegalArgumentException("unexpected gml version number:" + version);
    }

    public static Instant createTimeInstant(String version, Date date) {
        return GMLXmlFactory.createTimeInstant(version, null, date);
    }

    public static Instant createTimeInstant(String version, String id, Date date) {
        if ("3.2.1".equals(version)) {
            return new org.geotoolkit.gml.xml.v321.TimeInstantType(id, date);
        }
        if ("3.1.1".equals(version)) {
            return new TimeInstantType(id, date);
        }
        throw new IllegalArgumentException("unexpected gml version number:" + version);
    }

    public static Period createTimePeriod(String version, TimeIndeterminateValueType dateBegin, AbstractTimePosition dateEnd) {
        if ("3.2.1".equals(version)) {
            if (dateEnd != null && !(dateEnd instanceof TimePositionType)) {
                throw new IllegalArgumentException("unexpected gml version for date end.");
            }
            return new TimePeriodType(dateBegin, (TimePositionType)dateEnd);
        }
        if ("3.1.1".equals(version)) {
            if (dateEnd != null && !(dateEnd instanceof org.geotoolkit.gml.xml.v311.TimePositionType)) {
                throw new IllegalArgumentException("unexpected gml version for date end.");
            }
            return new org.geotoolkit.gml.xml.v311.TimePeriodType(dateBegin, (AbstractTimePosition)((org.geotoolkit.gml.xml.v311.TimePositionType)dateEnd));
        }
        throw new IllegalArgumentException("unexpected gml version number:" + version);
    }

    public static Period createTimePeriod(String version, AbstractTimePosition dateBegin, TimeIndeterminateValueType dateEnd) {
        if ("3.2.1".equals(version)) {
            if (dateBegin != null && !(dateBegin instanceof TimePositionType)) {
                throw new IllegalArgumentException("unexpected gml version for date begin.");
            }
            return new TimePeriodType((AbstractTimePosition)((TimePositionType)dateBegin), dateEnd);
        }
        if ("3.1.1".equals(version)) {
            if (dateBegin != null && !(dateBegin instanceof org.geotoolkit.gml.xml.v311.TimePositionType)) {
                throw new IllegalArgumentException("unexpected gml version for date end.");
            }
            return new org.geotoolkit.gml.xml.v311.TimePeriodType((AbstractTimePosition)((org.geotoolkit.gml.xml.v311.TimePositionType)dateBegin), dateEnd);
        }
        throw new IllegalArgumentException("unexpected gml version number:" + version);
    }

    public static Period createTimePeriod(String version, TimeIndeterminateValueType dateBegin, Date dateEnd) {
        if (dateEnd == null) {
            throw new NullArgumentException("dateEnd");
        }
        if ("3.2.1".equals(version)) {
            return new TimePeriodType(dateBegin, new TimePositionType(dateEnd));
        }
        if ("3.1.1".equals(version)) {
            return new org.geotoolkit.gml.xml.v311.TimePeriodType(dateBegin, (AbstractTimePosition)new org.geotoolkit.gml.xml.v311.TimePositionType(dateEnd));
        }
        throw new IllegalArgumentException("unexpected gml version number:" + version);
    }

    public static Period createTimePeriod(String version, Date dateBegin, TimeIndeterminateValueType dateEnd) {
        if (dateBegin == null) {
            throw new NullArgumentException("dateBegin");
        }
        if ("3.2.1".equals(version)) {
            return new TimePeriodType((AbstractTimePosition)new TimePositionType(dateBegin), dateEnd);
        }
        if ("3.1.1".equals(version)) {
            return new org.geotoolkit.gml.xml.v311.TimePeriodType((AbstractTimePosition)new org.geotoolkit.gml.xml.v311.TimePositionType(dateBegin), dateEnd);
        }
        throw new IllegalArgumentException("unexpected gml version number:" + version);
    }

    public static FeatureCollection createFeatureCollection(String version, String id, String name, String description, List<FeatureProperty> features) {
        if ("3.2.1".equals(version)) {
            ArrayList<FeaturePropertyType> features321 = new ArrayList<FeaturePropertyType>();
            if (features != null) {
                for (FeatureProperty fp : features) {
                    if (fp != null && !(fp instanceof FeaturePropertyType)) {
                        throw new IllegalArgumentException("unexpected gml version for feature property.");
                    }
                    if (fp == null) continue;
                    features321.add((FeaturePropertyType)fp);
                }
            }
            return new org.geotoolkit.gml.xml.v321.FeatureCollectionType(id, name, description, features321);
        }
        if ("3.1.1".equals(version)) {
            ArrayList<org.geotoolkit.gml.xml.v311.FeaturePropertyType> features311 = new ArrayList<org.geotoolkit.gml.xml.v311.FeaturePropertyType>();
            if (features != null) {
                for (FeatureProperty fp : features) {
                    if (fp != null && !(fp instanceof org.geotoolkit.gml.xml.v311.FeaturePropertyType)) {
                        throw new IllegalArgumentException("unexpected gml version for feature property.");
                    }
                    if (fp == null) continue;
                    features311.add((org.geotoolkit.gml.xml.v311.FeaturePropertyType)fp);
                }
            }
            return new FeatureCollectionType(id, name, description, features311);
        }
        throw new IllegalArgumentException("unexpected gml version number:" + version);
    }
}

