/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.gml.xml.v311;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.sis.util.ComparisonMode;
import org.geotoolkit.gml.xml.v311.AbstractReferenceSystemBaseType;
import org.geotoolkit.gml.xml.v311.ExtentType;
import org.geotoolkit.gml.xml.v311.IdentifierType;
import org.geotoolkit.gml.xml.v311.ImageCRSType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="AbstractReferenceSystemType", propOrder={"srsID", "validArea", "scope"})
@XmlSeeAlso(value={ImageCRSType.class})
public abstract class AbstractReferenceSystemType
extends AbstractReferenceSystemBaseType {
    private List<IdentifierType> srsID = new ArrayList<IdentifierType>();
    private ExtentType validArea;
    private String scope;

    public AbstractReferenceSystemType() {
    }

    public AbstractReferenceSystemType(String id, String name, String description, String srsName) {
        super(id, name, description, srsName);
    }

    public AbstractReferenceSystemType(List<IdentifierType> srsID, ExtentType validArea, String scope) {
        this.scope = scope;
        this.validArea = validArea;
        this.srsID = srsID;
    }

    public List<IdentifierType> getSrsID() {
        return Collections.unmodifiableList(this.srsID);
    }

    public ExtentType getValidArea() {
        return this.validArea;
    }

    public String getScope() {
        return this.scope;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString()).append("\n");
        if (this.srsID != null) {
            sb.append("srsID: ").append('\n');
            for (IdentifierType s : this.srsID) {
                sb.append(s).append('\n');
            }
        }
        if (this.scope != null) {
            sb.append("scope: ").append(this.scope).append('\n');
        }
        if (this.validArea != null) {
            sb.append("valid area: ").append(this.validArea).append('\n');
        }
        return sb.toString();
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        if (object instanceof AbstractReferenceSystemType && super.equals(object, mode)) {
            AbstractReferenceSystemType that = (AbstractReferenceSystemType)object;
            return Objects.equals(this.scope, that.scope) && Objects.equals(this.srsID, that.srsID) && Objects.equals(this.validArea, that.validArea);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 3;
        hash = 11 * hash + (this.srsID != null ? this.srsID.hashCode() : 0);
        hash = 11 * hash + (this.validArea != null ? this.validArea.hashCode() : 0);
        hash = 11 * hash + (this.scope != null ? this.scope.hashCode() : 0);
        return hash;
    }
}

