/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing;

import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import javax.measure.quantity.Time;
import org.apache.sis.internal.referencing.EllipsoidalHeightCombiner;
import org.apache.sis.internal.referencing.ReferencingFactoryContainer;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.referencing.provider.PolarStereographicA;
import org.apache.sis.internal.referencing.provider.TransverseMercator;
import org.apache.sis.metadata.iso.extent.DefaultExtent;
import org.apache.sis.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.Builder;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.Projection;
import org.opengis.util.FactoryException;

public class GeodeticObjectBuilder
extends Builder<GeodeticObjectBuilder> {
    private GeodeticDatum datum;
    private String conversionName;
    private OperationMethod method;
    private ParameterValueGroup parameters;
    private final ReferencingFactoryContainer factories;
    private final Locale locale;
    private boolean normalizedAxisOrder;

    public GeodeticObjectBuilder() {
        this(null, null);
    }

    public GeodeticObjectBuilder(ReferencingFactoryContainer factories, Locale locale) {
        this.factories = factories != null ? factories : new ReferencingFactoryContainer();
        this.locale = locale;
    }

    private static Map<String, Object> name(IdentifiedObject template) {
        return Map.of("name", template.getName());
    }

    public GeodeticObjectBuilder setNormalizedAxisOrder(boolean normalized) {
        this.normalizedAxisOrder = normalized;
        return this;
    }

    public GeodeticObjectBuilder setDomainOfValidity(CharSequence description, double westBoundLongitude, double eastBoundLongitude, double southBoundLatitude, double northBoundLatitude) {
        DefaultGeographicBoundingBox bbox = new DefaultGeographicBoundingBox(westBoundLongitude, eastBoundLongitude, southBoundLatitude, northBoundLatitude);
        if (bbox.isEmpty()) {
            bbox = null;
        }
        if (description != null || bbox != null) {
            DefaultExtent extent = new DefaultExtent(description, bbox, null, null);
            this.properties.put("domainOfValidity", extent);
        }
        return this;
    }

    public GeodeticObjectBuilder setFlattenedSphere(String name, double semiMajorAxis, double inverseFlattening, Unit<Length> units) throws FactoryException {
        DatumFactory factory = this.factories.getDatumFactory();
        Ellipsoid ellipsoid = factory.createFlattenedSphere(Map.of("name", name), semiMajorAxis, inverseFlattening, units);
        this.datum = factory.createGeodeticDatum(GeodeticObjectBuilder.name((IdentifiedObject)ellipsoid), ellipsoid, CommonCRS.WGS84.primeMeridian());
        return this;
    }

    public GeodeticObjectBuilder setConversionMethod(String name) throws FactoryException {
        if (this.method != null) {
            throw new IllegalStateException(Errors.getResources(this.locale).getString((short)27, "OperationMethod"));
        }
        this.method = this.factories.getCoordinateOperationFactory().getOperationMethod(name);
        this.parameters = this.method.getParameters().createValue();
        return this;
    }

    public GeodeticObjectBuilder setConversionName(String name) {
        this.conversionName = name;
        return this;
    }

    public GeodeticObjectBuilder setConversion(ParameterValueGroup parameters) throws FactoryException {
        ArgumentChecks.ensureNonNull("parameters", parameters);
        this.method = this.factories.getCoordinateOperationFactory().getOperationMethod(parameters.getDescriptor().getName().getCode());
        this.parameters = parameters;
        return this;
    }

    private void ensureConversionMethodSet() {
        if (this.parameters == null) {
            throw new IllegalStateException(Resources.forLocale(this.locale).getString((short)70));
        }
    }

    public GeodeticObjectBuilder setParameter(String name, double value, Unit<?> unit) throws IllegalStateException, ParameterNotFoundException, InvalidParameterValueException {
        this.ensureConversionMethodSet();
        this.parameters.parameter(name).setValue(value, unit);
        return this;
    }

    public GeodeticObjectBuilder changeConversion(String newMethod, BiConsumer<ParameterValue<?>, Parameters> mapper) throws FactoryException {
        this.ensureConversionMethodSet();
        if (mapper == null) {
            mapper = GeodeticObjectBuilder::copyParameterValue;
        }
        ParameterValueGroup source = this.parameters;
        if (newMethod != null) {
            this.method = null;
            this.setConversionMethod(newMethod);
        }
        Parameters target = Parameters.castOrWrap(this.parameters);
        for (GeneralParameterValue param : source.values()) {
            mapper.accept((ParameterValue)param, target);
        }
        return this;
    }

    private static void copyParameterValue(ParameterValue<?> source, Parameters target) {
        target.getOrCreate(source.getDescriptor()).setValue(source.getValue());
    }

    public GeodeticObjectBuilder apply(ProjectedCRS crs) {
        Projection c = crs.getConversionFromBase();
        this.conversionName = c.getName().getCode();
        this.method = c.getMethod();
        this.parameters = c.getParameterValues();
        this.datum = crs.getDatum();
        this.properties.putAll(IdentifiedObjects.getProperties((IdentifiedObject)crs, "identifiers"));
        return this;
    }

    public GeodeticObjectBuilder applyTransverseMercator(TransverseMercator.Zoner zoner, double latitude, double longitude) throws FactoryException {
        ArgumentChecks.ensureBetween("latitude", -90.0, 90.0, latitude);
        ArgumentChecks.ensureBetween("longitude", -4.052915431398935E8, 4.052915431398935E8, longitude);
        this.setConversionMethod("Transverse Mercator");
        this.setConversionName(zoner.setParameters(this.parameters, latitude, longitude));
        return this;
    }

    public GeodeticObjectBuilder applyPolarStereographic(boolean north) throws FactoryException {
        this.setConversionMethod("Polar Stereographic (variant A)");
        this.setConversionName(PolarStereographicA.setParameters(this.parameters, north));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectedCRS createProjectedCRS(GeographicCRS baseCRS, CartesianCS derivedCS) throws FactoryException {
        this.ensureConversionMethodSet();
        this.onCreate(false);
        try {
            String name = this.conversionName != null ? this.properties.put("name", this.conversionName) : null;
            Object alias = this.properties.put("alias", null);
            Object identifier = this.properties.put("identifiers", null);
            Conversion conversion = this.factories.getCoordinateOperationFactory().createDefiningConversion(this.properties, this.method, this.parameters);
            this.properties.put("identifiers", identifier);
            this.properties.put("alias", alias);
            if (name != null) {
                this.properties.put("name", name);
            }
            if (derivedCS == null) {
                derivedCS = this.factories.getStandardProjectedCS();
            }
            ProjectedCRS projectedCRS = this.factories.getCRSFactory().createProjectedCRS(this.properties, baseCRS, conversion, derivedCS);
            return projectedCRS;
        }
        finally {
            this.onCreate(true);
        }
    }

    public ProjectedCRS createProjectedCRS() throws FactoryException {
        GeographicCRS crs = this.getBaseCRS();
        if (this.datum != null) {
            crs = this.factories.getCRSFactory().createGeographicCRS(GeodeticObjectBuilder.name((IdentifiedObject)this.datum), this.datum, crs.getCoordinateSystem());
        }
        return this.createProjectedCRS(crs, this.factories.getStandardProjectedCS());
    }

    private GeographicCRS getBaseCRS() {
        return this.normalizedAxisOrder ? CommonCRS.defaultGeographic() : CommonCRS.WGS84.geographic();
    }

    public GeographicCRS createGeographicCRS() throws FactoryException {
        GeographicCRS crs = this.getBaseCRS();
        if (this.datum != null) {
            this.properties.putIfAbsent("name", this.datum.getName());
        }
        return this.factories.getCRSFactory().createGeographicCRS(this.properties, this.datum, crs.getCoordinateSystem());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TemporalCRS createTemporalCRS(Date origin, Unit<Time> unit) throws FactoryException {
        TimeCS cs = null;
        TemporalDatum datum = null;
        for (CommonCRS.Temporal c : CommonCRS.Temporal.values()) {
            TemporalCRS crs;
            TimeCS candidate;
            TemporalDatum candidate2;
            if (datum == null && origin.equals((candidate2 = c.datum()).getOrigin())) {
                datum = candidate2;
            }
            if (cs != null || !unit.equals((Object)(candidate = (crs = c.crs()).getCoordinateSystem()).getAxis(0).getUnit())) continue;
            if (datum == candidate && this.properties.isEmpty()) {
                return crs;
            }
            cs = candidate;
        }
        this.onCreate(false);
        try {
            if (cs == null) {
                CSFactory csFactory = this.factories.getCSFactory();
                cs = CommonCRS.Temporal.JAVA.crs().getCoordinateSystem();
                cs = csFactory.createTimeCS(GeodeticObjectBuilder.name((IdentifiedObject)cs), csFactory.createCoordinateSystemAxis(GeodeticObjectBuilder.name((IdentifiedObject)cs.getAxis(0)), "t", AxisDirection.FUTURE, unit));
            }
            if (this.properties.get("name") == null) {
                this.properties.putAll(GeodeticObjectBuilder.name((IdentifiedObject)cs));
            }
            if (datum == null) {
                Object remarks = this.properties.remove("remarks");
                Object identifier = this.properties.remove("identifiers");
                datum = this.factories.getDatumFactory().createTemporalDatum(this.properties, origin);
                this.properties.put("identifiers", identifier);
                this.properties.put("remarks", remarks);
                this.properties.put("name", datum.getName());
            }
            TemporalCRS temporalCRS = this.factories.getCRSFactory().createTemporalCRS(this.properties, datum, cs);
            return temporalCRS;
        }
        finally {
            this.onCreate(true);
        }
    }

    public CoordinateReferenceSystem createCompoundCRS(CoordinateReferenceSystem ... components) throws FactoryException {
        return new EllipsoidalHeightCombiner(this.factories).createCompoundCRS(this.properties, components);
    }

    public CoordinateReferenceSystem replaceComponent(CoordinateReferenceSystem source, int firstDimension, CoordinateReferenceSystem replacement) throws FactoryException {
        int srcDim = ReferencingUtilities.getDimension(source);
        int repDim = ReferencingUtilities.getDimension(replacement);
        if (firstDimension == 0 && srcDim == repDim) {
            return source.equals((Object)replacement) ? source : replacement;
        }
        ArgumentChecks.ensureValidIndex(srcDim - repDim, firstDimension);
        if (source instanceof CompoundCRS) {
            CoordinateReferenceSystem[] components = (CoordinateReferenceSystem[])((CompoundCRS)source).getComponents().toArray(CoordinateReferenceSystem[]::new);
            int lower = 0;
            for (int i = 0; i < components.length; ++i) {
                CoordinateReferenceSystem c = components[i];
                if (firstDimension >= lower) {
                    Object name = this.properties.remove("name");
                    Object alias = this.properties.remove("alias");
                    Object ids = this.properties.remove("identifiers");
                    CoordinateReferenceSystem nc = this.replaceComponent(c, firstDimension - lower, replacement);
                    if (name == null) {
                        name = source.getName();
                    }
                    this.properties.put("name", name);
                    this.properties.put("alias", alias);
                    this.properties.put("identifiers", ids);
                    if (nc == c) {
                        return source;
                    }
                    components[i] = nc;
                    return this.createCompoundCRS(components);
                }
                lower += ReferencingUtilities.getDimension(c);
            }
        }
        throw new IllegalArgumentException(Resources.forLocale(this.locale).getString((short)84, IdentifiedObjects.getDisplayName((IdentifiedObject)source, this.locale)));
    }
}

