/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.j2d;

import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.apache.sis.internal.util.Strings;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;

public class IntervalRectangle
extends Rectangle2D
implements Serializable {
    private static final long serialVersionUID = -5921513912411186629L;
    public double xmin;
    public double ymin;
    public double xmax;
    public double ymax;

    public IntervalRectangle() {
    }

    public IntervalRectangle(Envelope envelope) {
        this.xmin = envelope.getMinimum(0);
        this.xmax = envelope.getMaximum(0);
        this.ymin = envelope.getMinimum(1);
        this.ymax = envelope.getMaximum(1);
    }

    public IntervalRectangle(DirectPosition lower, DirectPosition upper) {
        this.xmin = lower.getOrdinate(0);
        this.xmax = upper.getOrdinate(0);
        this.ymin = lower.getOrdinate(1);
        this.ymax = upper.getOrdinate(1);
    }

    public IntervalRectangle(double xmin, double ymin, double xmax, double ymax) {
        this.xmin = xmin;
        this.ymin = ymin;
        this.xmax = xmax;
        this.ymax = ymax;
    }

    @Override
    public final boolean isEmpty() {
        return !(this.xmin < this.xmax) || !(this.ymin < this.ymax);
    }

    @Override
    public final double getX() {
        return this.xmin;
    }

    @Override
    public final double getY() {
        return this.ymin;
    }

    @Override
    public final double getWidth() {
        return this.xmax - this.xmin;
    }

    @Override
    public final double getHeight() {
        return this.ymax - this.ymin;
    }

    @Override
    public final double getMinX() {
        return this.xmin;
    }

    @Override
    public final double getMinY() {
        return this.ymin;
    }

    @Override
    public final double getMaxX() {
        return this.xmax;
    }

    @Override
    public final double getMaxY() {
        return this.ymax;
    }

    @Override
    public final double getCenterX() {
        return (this.xmin + this.xmax) * 0.5;
    }

    @Override
    public final double getCenterY() {
        return (this.ymin + this.ymax) * 0.5;
    }

    @Override
    public final void setRect(double x, double y, double width, double height) {
        this.xmin = x;
        this.ymin = y;
        this.xmax = x + width;
        this.ymax = y + height;
    }

    @Override
    public final void setRect(Rectangle2D r) {
        if (r != this) {
            this.xmin = r.getMinX();
            this.ymin = r.getMinY();
            this.xmax = r.getMaxX();
            this.ymax = r.getMaxY();
        }
    }

    @Override
    public final void setFrame(Rectangle2D r) {
        this.setRect(r);
    }

    @Override
    public final boolean intersects(double x, double y, double width, double height) {
        if (!(this.xmin < this.xmax && this.ymin < this.ymax && width > 0.0 && height > 0.0)) {
            return false;
        }
        return x < this.xmax && y < this.ymax && x + width > this.xmin && y + height > this.ymin;
    }

    @Override
    public final boolean intersects(Rectangle2D rect) {
        if (!(this.xmin < this.xmax) || !(this.ymin < this.ymax)) {
            return false;
        }
        double xmin2 = rect.getMinX();
        double xmax2 = rect.getMaxX();
        if (!(xmax2 > xmin2)) {
            return false;
        }
        double ymin2 = rect.getMinY();
        double ymax2 = rect.getMaxY();
        if (!(ymax2 > ymin2)) {
            return false;
        }
        return xmin2 < this.xmax && ymin2 < this.ymax && xmax2 > this.xmin && ymax2 > this.ymin;
    }

    @Override
    public final boolean contains(double x, double y, double width, double height) {
        if (!(this.xmin < this.xmax && this.ymin < this.ymax && width > 0.0 && height > 0.0)) {
            return false;
        }
        return x >= this.xmin && y >= this.ymin && x + width <= this.xmax && y + height <= this.ymax;
    }

    @Override
    public final boolean contains(Rectangle2D rect) {
        if (!(this.xmin < this.xmax) || !(this.ymin < this.ymax)) {
            return false;
        }
        double xmin2 = rect.getMinX();
        double xmax2 = rect.getMaxX();
        if (!(xmax2 > xmin2)) {
            return false;
        }
        double ymin2 = rect.getMinY();
        double ymax2 = rect.getMaxY();
        if (!(ymax2 > ymin2)) {
            return false;
        }
        return xmin2 >= this.xmin && ymin2 >= this.ymin && xmax2 <= this.xmax && ymax2 <= this.ymax;
    }

    @Override
    public final boolean contains(double x, double y) {
        return x >= this.xmin && y >= this.ymin && x < this.xmax && y < this.ymax;
    }

    public final boolean containsInclusive(double x, double y) {
        return x >= this.xmin && x <= this.xmax && y >= this.ymin && y <= this.ymax;
    }

    public final double distanceSquared(double x, double y) {
        double d;
        double d2;
        double d3;
        double d4;
        int outcode = 0;
        double dx = Double.POSITIVE_INFINITY;
        double dy = Double.POSITIVE_INFINITY;
        double d5 = x - this.xmax;
        if (d4 >= 0.0) {
            dx = d5;
            outcode = 1;
        }
        d5 = y - this.ymax;
        if (d3 >= 0.0) {
            dy = d5;
            outcode |= 2;
        }
        d5 = this.xmin - x;
        if (d2 >= 0.0 && d5 < dx) {
            dx = d5;
            outcode |= 1;
        }
        d5 = this.ymin - y;
        if (d >= 0.0 && d5 < dy) {
            dy = d5;
            outcode |= 2;
        }
        switch (outcode) {
            case 1: {
                return dx * dx;
            }
            case 2: {
                return dy * dy;
            }
            case 3: {
                return dx * dx + dy * dy;
            }
            case 0: {
                assert (this.containsInclusive(x, y));
                return 0.0;
            }
        }
        throw new AssertionError(outcode);
    }

    @Override
    public final int outcode(double x, double y) {
        int out = 0;
        if (!(this.xmax > this.xmin)) {
            out |= 5;
        } else if (x < this.xmin) {
            out |= 1;
        } else if (x > this.xmax) {
            out |= 4;
        }
        if (!(this.ymax > this.ymin)) {
            out |= 0xA;
        } else if (y < this.ymin) {
            out |= 2;
        } else if (y > this.ymax) {
            out |= 8;
        }
        return out;
    }

    public final void intersect(Rectangle2D rect) {
        double d;
        double d2;
        double d3;
        double d4;
        double t = rect.getMinX();
        if (d4 > this.xmin) {
            this.xmin = t;
        }
        t = rect.getMaxX();
        if (d3 < this.xmax) {
            this.xmax = t;
        }
        t = rect.getMinY();
        if (d2 > this.ymin) {
            this.ymin = t;
        }
        t = rect.getMaxY();
        if (d < this.ymax) {
            this.ymax = t;
        }
    }

    @Override
    public final Rectangle2D createIntersection(Rectangle2D rect) {
        IntervalRectangle r = new IntervalRectangle();
        r.xmin = Math.max(this.xmin, rect.getMinX());
        r.ymin = Math.max(this.ymin, rect.getMinY());
        r.xmax = Math.min(this.xmax, rect.getMaxX());
        r.ymax = Math.min(this.ymax, rect.getMaxY());
        return r;
    }

    @Override
    public final Rectangle2D createUnion(Rectangle2D rect) {
        IntervalRectangle r = new IntervalRectangle();
        r.xmin = Math.min(this.xmin, rect.getMinX());
        r.ymin = Math.min(this.ymin, rect.getMinY());
        r.xmax = Math.max(this.xmax, rect.getMaxX());
        r.ymax = Math.max(this.ymax, rect.getMaxY());
        return r;
    }

    @Override
    public final void add(double x, double y) {
        if (x < this.xmin) {
            this.xmin = x;
        }
        if (x > this.xmax) {
            this.xmax = x;
        }
        if (y < this.ymin) {
            this.ymin = y;
        }
        if (y > this.ymax) {
            this.ymax = y;
        }
    }

    @Override
    public final void add(Rectangle2D rect) {
        double d;
        double d2;
        double d3;
        double d4;
        double t = rect.getMinX();
        if (d4 < this.xmin) {
            this.xmin = t;
        }
        t = rect.getMaxX();
        if (d3 > this.xmax) {
            this.xmax = t;
        }
        t = rect.getMinY();
        if (d2 < this.ymin) {
            this.ymin = t;
        }
        t = rect.getMaxY();
        if (d > this.ymax) {
            this.ymax = t;
        }
    }

    public String toString() {
        return Strings.toString(this.getClass(), "xmin", this.xmin, "ymin", this.ymin, "xmax", this.xmax, "ymax", this.ymax);
    }
}

