/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import jakarta.xml.bind.annotation.XmlTransient;
import java.util.Map;
import javax.measure.Unit;
import org.apache.sis.internal.referencing.Formulas;
import org.apache.sis.internal.referencing.NilReferencingObject;
import org.apache.sis.internal.referencing.provider.AbstractProvider;
import org.apache.sis.internal.referencing.provider.GeocentricAffine;
import org.apache.sis.internal.referencing.provider.GeocentricAffineBetweenGeographic;
import org.apache.sis.internal.referencing.provider.GeodeticOperation;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.datum.DefaultEllipsoid;
import org.apache.sis.referencing.operation.transform.MolodenskyTransform;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.Identifier;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.util.FactoryException;

@XmlTransient
public final class Molodensky
extends GeocentricAffineBetweenGeographic {
    private static final long serialVersionUID = 8126525068450868912L;
    public static final ParameterDescriptor<Double> AXIS_LENGTH_DIFFERENCE;
    public static final ParameterDescriptor<Double> FLATTENING_DIFFERENCE;
    public static final ParameterDescriptorGroup PARAMETERS;

    public static ParameterDescriptorGroup internal() {
        ParameterBuilder builder = (ParameterBuilder)Molodensky.builder().setCodeSpace(Citations.SIS, "SIS");
        ParameterDescriptor<Object> abridged = ((ParameterBuilder)builder.addName("abridged")).create(Boolean.class, null);
        return ((ParameterBuilder)builder.addName("Molodensky (radians domain)")).createGroup(new GeneralParameterDescriptor[]{DIMENSION, SRC_SEMI_MAJOR, SRC_SEMI_MINOR, AXIS_LENGTH_DIFFERENCE, FLATTENING_DIFFERENCE, TX, TY, TZ, abridged});
    }

    public Molodensky() {
        this(3, 3, new Molodensky[4]);
        this.redimensioned[0] = new Molodensky(2, 2, this.redimensioned);
        this.redimensioned[1] = new Molodensky(2, 3, this.redimensioned);
        this.redimensioned[2] = new Molodensky(3, 2, this.redimensioned);
        this.redimensioned[3] = this;
    }

    private Molodensky(int sourceDimensions, int targetDimensions, GeodeticOperation[] redimensioned) {
        super(GeocentricAffine.Type.MOLODENSKY, PARAMETERS, sourceDimensions, targetDimensions, redimensioned);
    }

    @Override
    public MathTransform createMathTransform(MathTransformFactory factory, ParameterValueGroup values) throws FactoryException {
        return Molodensky.createMathTransform(factory, Parameters.castOrWrap(values), this.getSourceDimensions(), this.getTargetDimensions(), false);
    }

    static MathTransform createMathTransform(MathTransformFactory factory, Parameters values, int sourceDimensions, int targetDimensions, boolean isAbridged) throws FactoryException {
        Ellipsoid target;
        Integer dim = (Integer)values.getValue(DIMENSION);
        if (dim != null) {
            int n = dim;
            if (n != 2 && n != 3) {
                throw new InvalidParameterValueException(Errors.format((short)45, "dim", dim), "dim", (Object)dim);
            }
            sourceDimensions = targetDimensions = n;
        }
        double sa = values.doubleValue((ParameterDescriptor<? extends Number>)SRC_SEMI_MAJOR);
        double sb = values.doubleValue((ParameterDescriptor<? extends Number>)SRC_SEMI_MINOR);
        double ta = Molodensky.optional(values, (ParameterDescriptor<Double>)TGT_SEMI_MAJOR);
        double tb = Molodensky.optional(values, (ParameterDescriptor<Double>)TGT_SEMI_MINOR);
        double \u0394a = Molodensky.conditional(values, AXIS_LENGTH_DIFFERENCE, ta);
        double \u0394f = Molodensky.conditional(values, FLATTENING_DIFFERENCE, tb);
        if (Double.isNaN(ta)) {
            ta = sa + \u0394a;
        }
        if (Double.isNaN(tb)) {
            tb = ta * (sb / sa - \u0394f);
        }
        Map<String, Identifier> name = Map.of("name", NilReferencingObject.UNNAMED);
        Ellipsoid source = new Ellipsoid(name, sa, sb, \u0394a, \u0394f);
        source.other = target = new Ellipsoid(name, ta, tb, -\u0394a, -\u0394f);
        target.other = source;
        source.computeDifferences(values);
        return MolodenskyTransform.createGeodeticTransformation(factory, source, sourceDimensions >= 3, target, targetDimensions >= 3, values.doubleValue((ParameterDescriptor<? extends Number>)TX), values.doubleValue((ParameterDescriptor<? extends Number>)TY), values.doubleValue((ParameterDescriptor<? extends Number>)TZ), isAbridged);
    }

    private static double optional(Parameters values, ParameterDescriptor<Double> parameter) {
        Double value = values.getValue(parameter);
        return value != null ? value : Double.NaN;
    }

    private static double conditional(Parameters values, ParameterDescriptor<Double> parameter, double condition) {
        return Double.isNaN(condition) ? values.doubleValue(parameter) : Molodensky.optional(values, parameter);
    }

    static {
        ParameterBuilder builder = Molodensky.builder();
        AXIS_LENGTH_DIFFERENCE = ((ParameterBuilder)((ParameterBuilder)builder.addIdentifier("8654")).addName("Semi-major axis length difference")).create(Double.NaN, Units.METRE);
        FLATTENING_DIFFERENCE = ((ParameterBuilder)((ParameterBuilder)builder.addIdentifier("8655")).addName("Flattening difference")).createBounded(-1.0, 1.0, Double.NaN, Units.UNITY);
        PARAMETERS = ((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)builder.setRequired(true).addIdentifier("9604")).addName("Molodensky")).addName(Citations.OGC, "Molodenski")).createGroup(new GeneralParameterDescriptor[]{DIMENSION, SRC_SEMI_MAJOR, SRC_SEMI_MINOR, TGT_SEMI_MAJOR, TGT_SEMI_MINOR, TX, TY, TZ, AXIS_LENGTH_DIFFERENCE, FLATTENING_DIFFERENCE});
    }

    private static final class Ellipsoid
    extends DefaultEllipsoid {
        private double \u0394a;
        private double \u0394f;
        Ellipsoid other;

        Ellipsoid(Map<String, ?> name, double a, double b, double \u0394a, double \u0394f) {
            super(name, a, b, Formulas.getInverseFlattening(a, b), false, Units.METRE);
            this.\u0394a = \u0394a;
            this.\u0394f = \u0394f;
        }

        void computeDifferences(Parameters values) {
            if (Double.isNaN(this.\u0394a)) {
                this.\u0394a = super.semiMajorAxisDifference(this.other);
                Ellipsoid.setIfPresent(values, AXIS_LENGTH_DIFFERENCE, this.\u0394a, this.getAxisUnit());
            }
            if (Double.isNaN(this.\u0394f)) {
                this.\u0394f = super.flatteningDifference(this.other);
                Ellipsoid.setIfPresent(values, FLATTENING_DIFFERENCE, this.\u0394f, Units.UNITY);
            }
        }

        private static void setIfPresent(Parameters values, ParameterDescriptor<Double> parameter, double value, Unit<?> unit) {
            try {
                values.getOrCreate(parameter).setValue(value, unit);
            }
            catch (InvalidParameterValueException | ParameterNotFoundException e) {
                AbstractProvider.recoverableException(Molodensky.class, (Exception)e);
            }
        }

        @Override
        public double semiMajorAxisDifference(org.opengis.referencing.datum.Ellipsoid target) {
            return target == this.other && !Double.isNaN(this.\u0394a) ? this.\u0394a : super.semiMajorAxisDifference(target);
        }

        @Override
        public double flatteningDifference(org.opengis.referencing.datum.Ellipsoid target) {
            return target == this.other && !Double.isNaN(this.\u0394f) ? this.\u0394f : super.flatteningDifference(target);
        }
    }
}

