/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.matrix;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.sis.internal.referencing.Arithmetic;
import org.apache.sis.internal.referencing.ExtendedPrecisionMatrix;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.referencing.operation.matrix.GeneralMatrix;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MismatchedMatrixSizeException;
import org.apache.sis.referencing.operation.matrix.NonSquareMatrix;
import org.apache.sis.referencing.operation.matrix.NoninvertibleMatrixException;
import org.apache.sis.referencing.operation.matrix.Solver;
import org.apache.sis.referencing.operation.matrix.UnmodifiableMatrix;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.LenientComparable;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.operation.Matrix;

public abstract class MatrixSIS
implements Matrix,
LenientComparable,
Cloneable,
Serializable {
    private static final long serialVersionUID = 3075280376118406219L;

    protected MatrixSIS() {
    }

    static void ensureLengthMatch(int expected, double[] elements) throws IllegalArgumentException {
        if (elements.length != expected) {
            throw new IllegalArgumentException(Errors.format((short)133, expected, elements.length));
        }
    }

    static void ensureSizeMatch(int numRow, int numCol, Matrix matrix) throws MismatchedMatrixSizeException {
        int othRow = matrix.getNumRow();
        int othCol = matrix.getNumCol();
        if (numRow != othRow || numCol != othCol) {
            throw new MismatchedMatrixSizeException(Errors.format((short)83, numRow, numCol, othRow, othCol));
        }
    }

    static void ensureNumRowMatch(int expected, int actual, int numCol) {
        if (actual != expected) {
            throw new MismatchedMatrixSizeException(Errors.format((short)83, expected, "\u24a9", actual, numCol));
        }
    }

    static IndexOutOfBoundsException indexOutOfBounds(int row, int column) {
        return new IndexOutOfBoundsException(Errors.format((short)72, row, column));
    }

    public static MatrixSIS castOrCopy(Matrix matrix) {
        if (matrix == null || matrix instanceof MatrixSIS) {
            return (MatrixSIS)matrix;
        }
        return Matrices.copy(matrix);
    }

    static ExtendedPrecisionMatrix asExtendedPrecision(Matrix matrix) {
        if (matrix instanceof UnmodifiableMatrix) {
            return ((UnmodifiableMatrix)matrix).asExtendePrecision();
        }
        if (matrix instanceof ExtendedPrecisionMatrix) {
            return (ExtendedPrecisionMatrix)matrix;
        }
        return new UnmodifiableMatrix(matrix);
    }

    Number getElementOrNull(int row, int column) {
        double value = this.getElement(row, column);
        return value == 0.0 ? null : Double.valueOf(value);
    }

    @Deprecated(since="1.4", forRemoval=true)
    public long getInteger(int row, int column) {
        return Numbers.round(this.getNumber(row, column));
    }

    public Number getNumber(int row, int column) {
        return this.getElement(row, column);
    }

    public void setNumber(int row, int column, Number value) {
        this.setElement(row, column, value != null ? value.doubleValue() : 0.0);
    }

    public double[] getElements() {
        int numCol = this.getNumCol();
        double[] elements = new double[this.getNumRow() * numCol];
        for (int i = 0; i < elements.length; ++i) {
            elements[i] = this.getElement(i / numCol, i % numCol);
        }
        return elements;
    }

    public void setElements(double[] elements) {
        int numRow = this.getNumRow();
        int numCol = this.getNumCol();
        MatrixSIS.ensureLengthMatch(numRow * numCol, elements);
        int k = 0;
        for (int j = 0; j < numRow; ++j) {
            for (int i = 0; i < numCol; ++i) {
                this.setElement(j, i, elements[k++]);
            }
        }
    }

    final void setElements(Matrix source, int srcRow, int srcCol, int dstRow, int dstCol, int numRow, int numCol) {
        ExtendedPrecisionMatrix exp = MatrixSIS.asExtendedPrecision(source);
        while (--numRow >= 0) {
            for (int i = 0; i < numCol; ++i) {
                int s = srcCol + i;
                int t = dstCol + i;
                Number n = exp.getElementOrNull(srcRow, s);
                if (n != null) {
                    this.setNumber(dstRow, t, n);
                    continue;
                }
                this.setElement(dstRow, t, source.getElement(srcRow, s));
            }
            ++srcRow;
            ++dstRow;
        }
    }

    public void setMatrix(Matrix matrix) throws MismatchedMatrixSizeException {
        ArgumentChecks.ensureNonNull("matrix", matrix);
        int numRow = this.getNumRow();
        int numCol = this.getNumCol();
        MatrixSIS.ensureSizeMatch(numRow, numCol, matrix);
        this.setElements(matrix, 0, 0, 0, 0, numRow, numCol);
    }

    public boolean isAffine() {
        return MatrixSIS.isAffine(this);
    }

    static boolean isAffine(Matrix matrix) {
        int j = matrix.getNumRow();
        int i = matrix.getNumCol();
        if (i != j--) {
            return false;
        }
        double e = 1.0;
        while (--i >= 0) {
            if (matrix.getElement(j, i) != e) {
                return false;
            }
            e = 0.0;
        }
        return true;
    }

    public abstract boolean isIdentity();

    public abstract void transpose();

    public MatrixSIS normalizeColumns() {
        int numRow = this.getNumRow();
        int numCol = this.getNumCol();
        NonSquareMatrix magnitudes = new NonSquareMatrix(1, numCol, false);
        for (int i = 0; i < numCol; ++i) {
            int j;
            Number sum = null;
            for (int j2 = 0; j2 < numRow; ++j2) {
                Number element = this.getElementOrNull(j2, i);
                sum = Arithmetic.add(sum, Arithmetic.square(element));
            }
            if ((sum = Arithmetic.sqrt(sum)) == null) continue;
            int rowOfOne = -1;
            for (j = 0; j < numRow; ++j) {
                Number element = this.getElementOrNull(j, i);
                Number dot = Arithmetic.divide(element, sum);
                this.setNumber(j, i, dot);
                if (dot == null || !(Math.abs(dot.doubleValue()) >= 1.0)) continue;
                rowOfOne = j;
            }
            if (rowOfOne >= 0) {
                for (j = 0; j < numRow; ++j) {
                    double sign = this.getElement(j, i);
                    this.setElement(j, i, Math.copySign(j == rowOfOne ? 1.0 : 0.0, sign));
                }
            }
            ((MatrixSIS)magnitudes).setNumber(0, i, sum);
        }
        return magnitudes;
    }

    public void convertBefore(int srcDim, Number scale, Number offset) {
        int lastCol = this.getNumCol() - 1;
        ArgumentChecks.ensureValidIndex(lastCol, srcDim);
        int j = this.getNumRow();
        while (--j >= 0) {
            Number s;
            if (offset != null) {
                s = this.getElementOrNull(j, srcDim);
                Number t = this.getElementOrNull(j, lastCol);
                this.setNumber(j, lastCol, Arithmetic.add(t, Arithmetic.multiply(s, offset)));
            }
            if (scale == null) continue;
            s = this.getElementOrNull(j, srcDim);
            this.setNumber(j, srcDim, Arithmetic.multiply(s, scale));
        }
    }

    public void convertAfter(int tgtDim, Number scale, Number offset) {
        int lastRow = this.getNumRow() - 1;
        int lastCol = this.getNumCol() - 1;
        ArgumentChecks.ensureValidIndex(lastRow, tgtDim);
        if (scale != null) {
            for (int i = lastCol; i >= 0; --i) {
                Number s = this.getElementOrNull(tgtDim, i);
                this.setNumber(tgtDim, i, Arithmetic.multiply(s, scale));
            }
        }
        if (offset != null) {
            Number t = this.getElementOrNull(tgtDim, lastCol);
            this.setNumber(tgtDim, lastCol, Arithmetic.add(t, offset));
        }
    }

    public MatrixSIS multiply(Matrix matrix) throws MismatchedMatrixSizeException {
        int nc = matrix.getNumCol();
        MatrixSIS.ensureNumRowMatch(this.getNumCol(), matrix.getNumRow(), nc);
        GeneralMatrix result = GeneralMatrix.create(this.getNumRow(), nc, false);
        result.setToProduct(this, matrix);
        return result;
    }

    public double[] multiply(double[] vector) {
        int numCol = this.getNumCol();
        if (vector.length != numCol) {
            throw new MismatchedMatrixSizeException(Errors.format((short)133, numCol, vector.length));
        }
        double[] target = new double[this.getNumRow()];
        for (int j = 0; j < target.length; ++j) {
            Number sum = null;
            for (int i = 0; i < numCol; ++i) {
                Number element = this.getElementOrNull(j, i);
                sum = Arithmetic.add(sum, Arithmetic.multiply(element, vector[i]));
            }
            if (sum == null) continue;
            target[j] = sum.doubleValue();
        }
        return target;
    }

    public void translate(double[] vector) {
        int numCol = this.getNumCol();
        if (vector.length != numCol) {
            throw new MismatchedMatrixSizeException(Errors.format((short)133, numCol, vector.length));
        }
        int numRow = this.getNumRow();
        for (int j = 0; j < numRow; ++j) {
            Number sum = null;
            for (int i = 0; i < numCol; ++i) {
                Number element = this.getElementOrNull(j, i);
                sum = Arithmetic.add(sum, Arithmetic.multiply(element, vector[i]));
            }
            this.setNumber(j, numCol - 1, sum);
        }
    }

    public MatrixSIS solve(Matrix matrix) throws MismatchedMatrixSizeException, NoninvertibleMatrixException {
        return Solver.solve(this, matrix);
    }

    public MatrixSIS inverse() throws NoninvertibleMatrixException {
        return Solver.inverse(this);
    }

    public MatrixSIS removeRows(int lower, int upper) {
        int numRow = this.getNumRow();
        int numCol = this.getNumCol();
        ArgumentChecks.ensureValidIndexRange(numRow, lower, upper);
        MatrixSIS reduced = Matrices.createZero(numRow - (upper - lower), numCol, this);
        int dest = 0;
        for (int j = 0; j < numRow && (j != lower || (j = upper) != numRow); ++j) {
            for (int i = 0; i < numCol; ++i) {
                reduced.setNumber(dest, i, this.getNumber(j, i));
            }
            ++dest;
        }
        return reduced;
    }

    public MatrixSIS removeColumns(int lower, int upper) {
        int numRow = this.getNumRow();
        int numCol = this.getNumCol();
        ArgumentChecks.ensureValidIndexRange(numCol, lower, upper);
        MatrixSIS reduced = Matrices.createZero(numRow, numCol - (upper - lower), this);
        int dest = 0;
        for (int i = 0; i < numCol && (i != lower || (i = upper) != numCol); ++i) {
            for (int j = 0; j < numRow; ++j) {
                reduced.setNumber(j, dest, this.getNumber(j, i));
            }
            ++dest;
        }
        return reduced;
    }

    public int hashCode() {
        return Arrays.hashCode(this.getElements()) ^ 0x63446C4B;
    }

    @Override
    public boolean equals(Object object) {
        if (object != null && object.getClass() == this.getClass()) {
            int numRow = this.getNumRow();
            int numCol = this.getNumCol();
            MatrixSIS that = (MatrixSIS)object;
            if (that.getNumRow() == numRow && that.getNumCol() == numCol) {
                int j = numRow;
                while (--j >= 0) {
                    int i = numCol;
                    while (--i >= 0) {
                        if (Numerics.equals(that.getElement(j, i), this.getElement(j, i))) continue;
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }

    public boolean equals(Matrix matrix, double tolerance) {
        return Matrices.equals(this, matrix, tolerance, false);
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        return object instanceof Matrix && Matrices.equals(this, (Matrix)object, mode);
    }

    public MatrixSIS clone() {
        try {
            return (MatrixSIS)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public String toString() {
        return Matrices.toString(this);
    }
}

