/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.matrix;

import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.referencing.operation.matrix.GeneralMatrix;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.matrix.MismatchedMatrixSizeException;
import org.apache.sis.referencing.operation.matrix.NoninvertibleMatrixException;
import org.apache.sis.referencing.operation.matrix.Solver;
import org.apache.sis.util.Numbers;
import org.opengis.referencing.operation.Matrix;

final class NonSquareMatrix
extends GeneralMatrix {
    private static final long serialVersionUID = 5440465531101262966L;

    NonSquareMatrix(int numRow, int numCol, boolean setToIdentity) {
        super(numRow, numCol, setToIdentity);
    }

    NonSquareMatrix(int numRow, int numCol, Number[] elements) {
        super(numRow, numCol, elements);
    }

    private NonSquareMatrix(GeneralMatrix matrix) {
        super(matrix);
    }

    @Override
    public void transpose() {
        int numRow = this.numRow;
        int numCol = this.numCol;
        Number[] copy = (Number[])this.elements.clone();
        int k = 0;
        for (int j = 0; j < numRow; ++j) {
            for (int i = 0; i < numCol; ++i) {
                this.elements[i * numRow + j] = copy[k++];
            }
        }
        assert (k == this.elements.length);
        this.numRow = numCol;
        this.numCol = (short)numRow;
    }

    @Override
    public MatrixSIS solve(Matrix matrix) throws MismatchedMatrixSizeException, NoninvertibleMatrixException {
        MatrixSIS result = this.inverse();
        if (!matrix.isIdentity()) {
            result = result.multiply(matrix);
        }
        return result;
    }

    @Override
    public MatrixSIS inverse() throws NoninvertibleMatrixException {
        if (this.numRow < this.numCol) {
            return this.inverseDimensionReduction();
        }
        return this.inverseDimensionIncrease();
    }

    private MatrixSIS inverseDimensionReduction() throws NoninvertibleMatrixException {
        short numRow = this.numRow;
        int numCol = this.numCol;
        int length = numRow * numCol;
        int i = numCol;
        int oi = numCol - numRow;
        int[] omitted = new int[oi];
        block0: do {
            if (--i < 0) {
                throw this.nonInvertible();
            }
            int j = length + i;
            while ((j -= numCol) >= 0) {
                if (this.elements[j] == null) continue;
                continue block0;
            }
            omitted[--oi] = i;
        } while (oi != 0);
        GeneralMatrix squareMatrix = new GeneralMatrix((int)numRow, (int)numRow, false);
        int j = 0;
        for (i = 0; i < numCol; ++i) {
            if (oi != omitted.length && i == omitted[oi]) {
                ++oi;
                continue;
            }
            NonSquareMatrix.copyColumn(this, i, squareMatrix, j++);
        }
        squareMatrix = Solver.inverse(squareMatrix);
        NonSquareMatrix inverse = new NonSquareMatrix(numCol, (int)numRow, false);
        oi = 0;
        j = 0;
        for (i = 0; i < numCol; ++i) {
            if (oi != omitted.length && i == omitted[oi]) {
                inverse.setElement(i, numRow - 1, Double.NaN);
                ++oi;
                continue;
            }
            NonSquareMatrix.copyRow(squareMatrix, j++, inverse, i);
        }
        return inverse;
    }

    private MatrixSIS inverseDimensionIncrease() throws NoninvertibleMatrixException {
        int i;
        int numRow = this.numRow;
        short numCol = this.numCol;
        int j = numRow;
        int oi = numRow - numCol;
        int[] omitted = new int[oi];
        boolean ignoreTranslation = this.isAffine(false);
        if (ignoreTranslation) {
            --j;
        }
        block0: do {
            if (--j < 0) {
                throw this.nonInvertible();
            }
            int offset = j * numCol;
            i = offset + numCol;
            if (ignoreTranslation) {
                --i;
            }
            while (--i >= offset) {
                Number element = this.elements[i];
                if (element == null || Numbers.isNaN(element)) continue;
                continue block0;
            }
            omitted[--oi] = j;
        } while (oi != 0);
        GeneralMatrix squareMatrix = new GeneralMatrix((int)numCol, (int)numCol, false);
        i = 0;
        for (j = 0; j < numRow; ++j) {
            if (oi != omitted.length && j == omitted[oi]) {
                ++oi;
                continue;
            }
            NonSquareMatrix.copyRow(this, j, squareMatrix, i++);
        }
        squareMatrix = Solver.inverse(squareMatrix);
        NonSquareMatrix inverse = new NonSquareMatrix((int)numCol, numRow, false);
        oi = 0;
        i = 0;
        for (j = 0; j < numRow; ++j) {
            if (oi != omitted.length && j == omitted[oi]) {
                ++oi;
                continue;
            }
            NonSquareMatrix.copyColumn(squareMatrix, i++, inverse, j);
        }
        return inverse;
    }

    private static void copyColumn(GeneralMatrix source, int srcIndex, GeneralMatrix target, int dstIndex) {
        assert (target.numRow == source.numRow);
        while (srcIndex < source.elements.length) {
            target.elements[dstIndex] = source.elements[srcIndex];
            srcIndex += source.numCol;
            dstIndex += target.numCol;
        }
    }

    private static void copyRow(GeneralMatrix source, int srcIndex, GeneralMatrix target, int dstIndex) {
        short numCol = target.numCol;
        assert (numCol == source.numCol);
        System.arraycopy(source.elements, srcIndex *= numCol, target.elements, dstIndex *= numCol, numCol);
        if ((srcIndex += numCol * source.numRow) < source.elements.length) {
            System.arraycopy(source.elements, srcIndex, target.elements, dstIndex += numCol * target.numRow, numCol);
        }
    }

    private NoninvertibleMatrixException nonInvertible() {
        return new NoninvertibleMatrixException(Resources.format((short)51, this.numRow, this.numCol));
    }

    @Override
    public MatrixSIS clone() {
        return new NonSquareMatrix(this);
    }
}

