/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.projection;

import java.util.EnumMap;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.sis.geometry.Envelope2D;
import org.apache.sis.internal.referencing.provider.Mercator1SP;
import org.apache.sis.internal.referencing.provider.Mercator2SP;
import org.apache.sis.internal.referencing.provider.MercatorAuxiliarySphere;
import org.apache.sis.internal.referencing.provider.RegionalMercator;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.matrix.Matrix2;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.projection.AuthalicMercator;
import org.apache.sis.referencing.operation.projection.ConformalProjection;
import org.apache.sis.referencing.operation.projection.Initializer;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.apache.sis.referencing.operation.projection.ProjectionException;
import org.apache.sis.referencing.operation.projection.ProjectionVariant;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.referencing.operation.transform.DomainDefinition;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class Mercator
extends ConformalProjection {
    private static final long serialVersionUID = 8732555724521630563L;
    private final Variant variant;

    public Mercator(OperationMethod method, Parameters parameters) {
        this(Mercator.initializer(method, parameters));
    }

    private static Initializer initializer(OperationMethod method, Parameters parameters) {
        Variant variant = (Variant)Mercator.variant((OperationMethod)method, (ProjectionVariant[])Variant.values(), (ProjectionVariant)Variant.TWO_PARALLELS);
        EnumMap<NormalizedProjection.ParameterRole, Object> roles = new EnumMap<NormalizedProjection.ParameterRole, Object>(NormalizedProjection.ParameterRole.class);
        roles.put(NormalizedProjection.ParameterRole.SCALE_FACTOR, Mercator1SP.SCALE_FACTOR);
        roles.put(NormalizedProjection.ParameterRole.CENTRAL_MERIDIAN, Mercator1SP.LONGITUDE_OF_ORIGIN);
        switch (variant) {
            case REGIONAL: {
                roles.put(NormalizedProjection.ParameterRole.FALSE_EASTING, RegionalMercator.EASTING_AT_FALSE_ORIGIN);
                roles.put(NormalizedProjection.ParameterRole.FALSE_NORTHING, RegionalMercator.NORTHING_AT_FALSE_ORIGIN);
                break;
            }
            case SPHERICAL: {
                roles.put(NormalizedProjection.ParameterRole.LATITUDE_OF_CONFORMAL_SPHERE_RADIUS, Mercator1SP.LATITUDE_OF_ORIGIN);
            }
            default: {
                roles.put(NormalizedProjection.ParameterRole.FALSE_EASTING, Mercator1SP.FALSE_EASTING);
                roles.put(NormalizedProjection.ParameterRole.FALSE_NORTHING, Mercator1SP.FALSE_NORTHING);
            }
        }
        return new Initializer(method, parameters, roles, variant);
    }

    private Mercator(Initializer initializer) {
        super(initializer);
        this.variant = (Variant)initializer.variant;
        double \u03c60 = Math.toRadians(initializer.getAndStore(this.variant == Variant.REGIONAL ? RegionalMercator.LATITUDE_OF_FALSE_ORIGIN : Mercator1SP.LATITUDE_OF_ORIGIN));
        double \u03c61 = Math.toRadians(initializer.getAndStore(Mercator2SP.STANDARD_PARALLEL));
        Double k0 = initializer.scaleAt\u03c6(Math.sin(\u03c61), Math.cos(\u03c61));
        MatrixSIS normalize = this.context.getMatrix(ContextualParameters.MatrixRole.NORMALIZATION);
        MatrixSIS denormalize = this.context.getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION);
        denormalize.convertBefore(0, k0, null);
        denormalize.convertBefore(1, k0, null);
        if (\u03c60 != 0.0) {
            denormalize.convertBefore(1, null, -Math.log(this.exp\u03a8(\u03c60, this.eccentricity * Math.sin(\u03c60))));
        }
        if (this.variant == Variant.MILLER) {
            normalize.convertBefore(1, 0.8, null);
            denormalize.convertBefore(1, 1.25, null);
        } else if (this.variant == Variant.AUXILIARY) {
            Number ratio;
            int type = initializer.getAndStore(MercatorAuxiliarySphere.AUXILIARY_SPHERE_TYPE, 0);
            switch (type) {
                default: {
                    throw new IllegalArgumentException(Errors.format((short)45, MercatorAuxiliarySphere.AUXILIARY_SPHERE_TYPE.getName().getCode(), type));
                }
                case 2: 
                case 3: {
                    ratio = initializer.authalicRadius();
                    break;
                }
                case 1: {
                    ratio = initializer.axisLengthRatio();
                    break;
                }
                case 0: {
                    ratio = null;
                }
            }
            denormalize.convertAfter(0, ratio, null);
            denormalize.convertAfter(1, ratio, null);
        }
        if (\u03c60 == 0.0 && MathFunctions.isPositive(\u03c61 != 0.0 ? \u03c61 : \u03c60)) {
            DoubleDouble reverseSign = DoubleDouble.of(-1);
            normalize.convertBefore(1, reverseSign, null);
            denormalize.convertBefore(1, reverseSign, null);
        }
    }

    Mercator(Mercator other) {
        super(other);
        this.variant = other.variant;
    }

    @Override
    public MathTransform createMapProjection(MathTransformFactory factory) throws FactoryException {
        NormalizedProjection kernel = this;
        if (this.variant.spherical || this.eccentricity == 0.0 && this.getClass() == Mercator.class) {
            int type;
            kernel = this.variant == Variant.AUXILIARY && this.eccentricity != 0.0 && (type = this.context.getValue(MercatorAuxiliarySphere.AUXILIARY_SPHERE_TYPE).intValue()) == 3 ? new AuthalicMercator(this) : new Spherical(this);
        }
        return kernel.completeWithWraparound(factory);
    }

    @Override
    public Optional<Envelope> getDomain(DomainDefinition criteria) {
        double limit = this.variant == Variant.MILLER ? -1.5707963267948966 : -1.4660765716752369;
        return Optional.of(new Envelope2D(null, -314.1592653589793, limit, 628.3185307179587, -2.0 * limit));
    }

    @Override
    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws ProjectionException {
        double \u03c6 = srcPts[srcOff + 1];
        double sin\u03c6 = Math.sin(\u03c6);
        if (dstPts != null) {
            double a;
            double y = \u03c6 == 0.0 ? \u03c6 : ((a = Math.abs(\u03c6)) < 1.5707963267948966 ? Math.log(this.exp\u03a8(\u03c6, this.eccentricity * sin\u03c6)) : (a <= 1.5707963283655673 ? Math.copySign(Double.POSITIVE_INFINITY, \u03c6) : Double.NaN));
            dstPts[dstOff] = srcPts[srcOff];
            dstPts[dstOff + 1] = y;
        }
        return derivate ? new Matrix2(1.0, 0.0, 0.0, this.dy_d\u03c6(sin\u03c6, Math.cos(\u03c6))) : null;
    }

    @Override
    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        if (srcPts != dstPts || srcOff != dstOff || this.getClass() != Mercator.class) {
            super.transform(srcPts, srcOff, dstPts, dstOff, numPts);
        } else {
            --dstOff;
            while (--numPts >= 0) {
                double \u03c6 = dstPts[dstOff += 2];
                if (\u03c6 == 0.0) continue;
                double a = Math.abs(\u03c6);
                double y = a < 1.5707963267948966 ? Math.log(this.exp\u03a8(\u03c6, this.eccentricity * Math.sin(\u03c6))) : (a <= 1.5707963283655673 ? Math.copySign(Double.POSITIVE_INFINITY, \u03c6) : Double.NaN);
                dstPts[dstOff] = y;
            }
        }
    }

    @Override
    protected void inverseTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff) throws ProjectionException {
        double y = srcPts[srcOff + 1];
        dstPts[dstOff] = srcPts[srcOff];
        dstPts[dstOff + 1] = this.\u03c6(Math.exp(-y));
    }

    @Override
    final MathTransform tryConcatenate(boolean projectedSpace, Matrix affine, MathTransformFactory factory) throws FactoryException {
        if (affine.getElement(1, 0) == 0.0 && affine.getElement(1, 2) == 0.0 && Math.abs(affine.getElement(1, 1)) == 1.0) {
            if (factory != null) {
                return factory.createAffineTransform(affine);
            }
            return MathTransforms.linear(affine);
        }
        return super.tryConcatenate(projectedSpace, affine, factory);
    }

    private static enum Variant implements ProjectionVariant
    {
        ONE_PARALLEL(".*\\bvariant\\s*A\\b.*", "9804", false),
        TWO_PARALLELS(".*\\bvariant\\s*B\\b.*", "9805", false),
        REGIONAL(".*\\bvariant\\s*C\\b.*", "1044", false),
        SPHERICAL(".*\\bSpherical\\b.*", "1026", true),
        PSEUDO(".*\\bPseudo.*", "1024", true),
        AUXILIARY(".*\\bAuxiliary\\s*Sphere\\b.*", null, true),
        MILLER(".*\\bMiller.*", null, false);

        private final Pattern operationName;
        private final String identifier;
        final boolean spherical;

        private Variant(String operationName, String identifier, boolean spherical) {
            this.operationName = Pattern.compile(operationName, 2);
            this.identifier = identifier;
            this.spherical = spherical;
        }

        @Override
        public Pattern getOperationNamePattern() {
            return this.operationName;
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }
    }

    static final class Spherical
    extends Mercator {
        private static final long serialVersionUID = 2383414176395616561L;

        Spherical(Mercator other) {
            super(other);
        }

        @Override
        public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) {
            double \u03c6 = srcPts[srcOff + 1];
            if (dstPts != null) {
                double a;
                double y = \u03c6 == 0.0 ? \u03c6 : ((a = Math.abs(\u03c6)) < 1.5707963267948966 ? Math.log(Math.tan(0.7853981633974483 + 0.5 * \u03c6)) : (a <= 1.5707963283655673 ? Math.copySign(Double.POSITIVE_INFINITY, \u03c6) : Double.NaN));
                dstPts[dstOff] = srcPts[srcOff];
                dstPts[dstOff + 1] = y;
            }
            return derivate ? new Matrix2(1.0, 0.0, 0.0, 1.0 / Math.cos(\u03c6)) : null;
        }

        @Override
        public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
            if (srcPts != dstPts || srcOff != dstOff) {
                super.transform(srcPts, srcOff, dstPts, dstOff, numPts);
            } else {
                --dstOff;
                while (--numPts >= 0) {
                    double \u03c6 = dstPts[dstOff += 2];
                    if (\u03c6 == 0.0) continue;
                    double a = Math.abs(\u03c6);
                    double y = a < 1.5707963267948966 ? Math.log(Math.tan(0.7853981633974483 + 0.5 * \u03c6)) : (a <= 1.5707963283655673 ? Math.copySign(Double.POSITIVE_INFINITY, \u03c6) : Double.NaN);
                    dstPts[dstOff] = y;
                }
            }
        }

        @Override
        protected void inverseTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff) {
            double y = srcPts[srcOff + 1];
            dstPts[dstOff] = srcPts[srcOff];
            dstPts[dstOff + 1] = 1.5707963267948966 - 2.0 * Math.atan(Math.exp(-y));
        }
    }
}

