/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.apache.sis.util.logging.Logging;
import org.geotoolkit.internal.io.OS;

public enum Installation {
    ROOT_DIRECTORY("org/geotoolkit", "Root directory", null),
    TESTS(null, null, "Tests"),
    SIS("org/geotoolkit/metadata", "SIS", "Databases"),
    EPSG("org/geotoolkit/referencing/factory", "EPSG", "EPSG"),
    COVERAGES("org/geotoolkit/coverage/sql", "Database", "Coverages");

    public static final String DATASOURCE_FILE = "DataSource.properties";
    private final String node;
    private final String key;
    private final String directory;
    private static final Path DEFAULT_ROOT;

    private Installation(String node, String key, String directory) {
        this.node = node;
        this.key = key;
        this.directory = directory;
    }

    private Preferences preference() {
        return Preferences.userRoot();
    }

    public final void set(String value) {
        try {
            Preferences prefs = this.preference();
            if (value != null) {
                prefs.put(this.key, value);
            } else {
                prefs.remove(this.key);
            }
        }
        catch (SecurityException e) {
            Logging.recoverableException((Logger)Logger.getLogger("org.geotoolkit"), Installation.class, (String)"set", (Throwable)e);
        }
    }

    public final String get() {
        try {
            if (this.key != null) {
                return this.preference().get(this.key, null);
            }
        }
        catch (SecurityException e) {
            Logging.recoverableException((Logger)Logger.getLogger("org.geotoolkit"), Installation.class, (String)"set", (Throwable)e);
        }
        return null;
    }

    private static Path root() {
        try {
            Path file;
            String app;
            OS system = OS.current();
            if (system == OS.WINDOWS && (app = System.getenv("APPDATA")) != null && Files.isDirectory(file = Paths.get(app, new String[0]), new LinkOption[0])) {
                return file.resolve("Geotoolkit.org");
            }
            String directory = System.getProperty("user.home");
            if (directory != null) {
                file = Paths.get(directory, new String[0]);
                String name = ".geotoolkit.org";
                switch (system) {
                    case WINDOWS: {
                        file = file.resolve("Application Data");
                        name = "Geotoolkit.org";
                        break;
                    }
                    case MAC_OS: {
                        file = file.resolve("Library");
                        name = "Geotoolkit.org";
                    }
                }
                if (Files.isDirectory(file, new LinkOption[0]) && (!system.unix || Files.isWritable(file))) {
                    return file.resolve(name);
                }
            }
        }
        catch (SecurityException e) {
            Logger.getLogger("org.geotoolkit").warning(e.toString());
        }
        return Paths.get(System.getProperty("java.io.tmpdir"), "Geotoolkit.org");
    }

    public Path directory(boolean usePreferences) {
        String candidate;
        if (usePreferences && (candidate = this.get()) != null) {
            return Paths.get(candidate, new String[0]);
        }
        if (this.directory != null) {
            return ROOT_DIRECTORY.directory(true).resolve(this.directory);
        }
        return DEFAULT_ROOT;
    }

    public Properties getDataSource() throws IOException {
        Path file = this.directory(true).resolve(DATASOURCE_FILE);
        if (Files.isRegularFile(file, new LinkOption[0])) {
            Properties properties;
            try (InputStream in = Files.newInputStream(file, new OpenOption[0]);){
                properties = new Properties();
                properties.load(in);
            }
            return properties;
        }
        return null;
    }

    static {
        DEFAULT_ROOT = Installation.root();
    }
}

