/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.sql;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;

public final class AuthenticatedDataSource
implements DataSource {
    public final DataSource wrapped;
    private final String username;
    private final String password;
    private final Boolean isReadOnly;

    public AuthenticatedDataSource(DataSource datasource, String username, String password, Boolean isReadOnly) {
        this.wrapped = datasource;
        this.username = username;
        this.password = password;
        this.isReadOnly = isReadOnly;
    }

    @Override
    public Connection getConnection() throws SQLException {
        Connection c = this.username != null && this.password != null ? this.wrapped.getConnection(this.username, this.password) : this.wrapped.getConnection();
        if (this.isReadOnly != null) {
            c.setReadOnly(this.isReadOnly);
        }
        return c;
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        Connection c = this.wrapped.getConnection(username, password);
        if (this.isReadOnly != null) {
            c.setReadOnly(this.isReadOnly);
        }
        return c;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.wrapped.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.wrapped.setLogWriter(out);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.wrapped.getLoginTimeout();
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.wrapped.setLoginTimeout(seconds);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.wrapped.isWrapperFor(iface);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.wrapped.unwrap(iface);
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.wrapped.getParentLogger();
    }
}

