/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.nio;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;

public class CopyFileVisitor
extends SimpleFileVisitor<Path> {
    private final Path targetPath;
    private final CopyOption[] copyOption;
    private Path sourcePath = null;

    public CopyFileVisitor(Path targetPath, CopyOption ... copyOption) {
        this.targetPath = targetPath;
        this.copyOption = copyOption;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        if (this.sourcePath == null) {
            this.sourcePath = dir;
            if (!Files.isDirectory(this.targetPath, new LinkOption[0])) {
                Files.createDirectories(this.targetPath, new FileAttribute[0]);
            }
        } else {
            Path relativize = this.sourcePath.relativize(dir);
            Path p = this.targetPath.resolve(relativize.toString());
            if (!Files.isDirectory(p, new LinkOption[0])) {
                Files.createDirectories(p, new FileAttribute[0]);
            }
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        if (this.sourcePath == null) {
            this.sourcePath = file.getParent();
        }
        Path relativize = this.sourcePath.relativize(file);
        Files.copy(file, this.targetPath.resolve(relativize.toString()), this.copyOption);
        return FileVisitResult.CONTINUE;
    }
}

