/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.parameter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.measure.Unit;
import org.apache.sis.metadata.iso.quality.DefaultConformanceResult;
import org.apache.sis.parameter.DefaultParameterDescriptorGroup;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ObjectConverters;
import org.apache.sis.util.UnconvertibleObjectException;
import org.apache.sis.util.logging.Logging;
import org.geotoolkit.lang.Static;
import org.geotoolkit.parameter.AbstractParameter;
import org.geotoolkit.resources.Descriptions;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Vocabulary;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.quality.ConformanceResult;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;

public final class Parameters
extends Static {
    private static final double EPS = 1.0E-8;
    private static final InternationalString EXPLAIN = Descriptions.formatInternational(7);
    @Deprecated
    public static final ParameterDescriptorGroup EMPTY_GROUP = new DefaultParameterDescriptorGroup(Collections.singletonMap("name", Vocabulary.format((short)81)), 1, 1, new GeneralParameterDescriptor[0]);

    private Parameters() {
    }

    public static boolean isValid(ParameterValue<?> value) {
        return Parameters.isValidValue(value.getDescriptor(), value.getValue(), false) == null;
    }

    private static <T> InternationalString isValidValue(ParameterDescriptor<T> descriptor, Object value, boolean localized) {
        if (value == null) {
            if (descriptor.getMinimumOccurs() == 0) {
                return null;
            }
            return localized ? Errors.formatInternational((short)115, (Object)AbstractParameter.getName(descriptor)) : EXPLAIN;
        }
        Class<?> type = value.getClass();
        Class expected = descriptor.getValueClass();
        if (!expected.isAssignableFrom(type)) {
            return localized ? Errors.formatInternational((short)55, type, expected) : EXPLAIN;
        }
        Object typedValue = expected.cast(value);
        Comparable minimum = descriptor.getMinimumValue();
        Comparable maximum = descriptor.getMaximumValue();
        if (minimum != null && minimum.compareTo(typedValue) > 0 || maximum != null && maximum.compareTo(typedValue) < 0) {
            return localized ? Errors.formatInternational((short)212, value, minimum, maximum) : EXPLAIN;
        }
        Set validValues = descriptor.getValidValues();
        if (validValues != null && !validValues.contains(value)) {
            return localized ? Errors.formatInternational((short)53, AbstractParameter.getName(descriptor), value) : EXPLAIN;
        }
        return null;
    }

    public static ConformanceResult isValid(GeneralParameterValue value, GeneralParameterDescriptor descriptor) {
        DefaultConformanceResult result = new DefaultConformanceResult(descriptor.getName().getAuthority(), (CharSequence)EXPLAIN, true);
        GeneralParameterValue failure = Parameters.isValid(value, descriptor, result);
        if (failure != null) {
            Identifier name = failure.getDescriptor().getName();
            result.setExplanation(Descriptions.formatInternational((short)11, name, result.getExplanation()));
            result.setSpecification(name.getAuthority());
            result.setPass(Boolean.FALSE);
        }
        return result;
    }

    private static GeneralParameterValue isValid(GeneralParameterValue value, GeneralParameterDescriptor descriptor, DefaultConformanceResult result) {
        if (descriptor instanceof ParameterDescriptor) {
            if (value instanceof ParameterValue) {
                InternationalString failure = Parameters.isValidValue((ParameterDescriptor)descriptor, ((ParameterValue)value).getValue(), true);
                if (failure != null) {
                    result.setExplanation(failure);
                    return value;
                }
                return null;
            }
        } else if (descriptor instanceof ParameterDescriptorGroup && value instanceof ParameterValueGroup) {
            HashMap<GeneralParameterDescriptor, Integer> count = new HashMap<GeneralParameterDescriptor, Integer>();
            ParameterDescriptorGroup group = (ParameterDescriptorGroup)descriptor;
            for (GeneralParameterValue element : ((ParameterValueGroup)value).values()) {
                GeneralParameterDescriptor desc;
                String name = Parameters.getName(element.getDescriptor(), group);
                try {
                    desc = group.descriptor(name);
                }
                catch (ParameterNotFoundException e) {
                    result.setExplanation(Errors.formatInternational((short)176, (Object)name));
                    return value;
                }
                GeneralParameterValue failure = Parameters.isValid(element, desc, result);
                if (failure != null) {
                    return failure;
                }
                Integer old = count.put(desc, 1);
                if (old == null) continue;
                count.put(desc, old + 1);
            }
            for (GeneralParameterDescriptor desc : group.descriptors()) {
                Object[] param;
                short key;
                Integer nw = (Integer)count.get(desc);
                int n = nw != null ? nw : 0;
                int min = desc.getMinimumOccurs();
                int max = desc.getMaximumOccurs();
                if (n >= min && n <= max) continue;
                String name = desc.getName().getCode();
                if (n == 0) {
                    key = 115;
                    param = new Object[]{name};
                } else {
                    key = 68;
                    param = new Object[]{name, nw, min, max};
                }
                result.setExplanation(Errors.formatInternational(key, param));
                return value;
            }
            return null;
        }
        Class type = value instanceof ParameterValue ? ParameterValue.class : (value instanceof ParameterValueGroup ? ParameterValueGroup.class : GeneralParameterValue.class);
        result.setExplanation(Errors.formatInternational((short)69, type));
        return value;
    }

    private static String getName(GeneralParameterDescriptor parameter, ParameterDescriptorGroup group) {
        String name = IdentifiedObjects.getName((IdentifiedObject)parameter, (Citation)group.getName().getAuthority());
        if (name == null) {
            name = parameter.getName().getCode();
        }
        return name;
    }

    @Deprecated
    public static ParameterValue<?> getOrCreate(ParameterDescriptor<?> parameter, ParameterValueGroup group) throws ParameterNotFoundException {
        return org.apache.sis.parameter.Parameters.castOrWrap((ParameterValueGroup)group).getOrCreate(parameter);
    }

    public static List<GeneralParameterValue> search(GeneralParameterValue parameter, String name, int maxDepth) {
        ArrayList<GeneralParameterValue> list = new ArrayList<GeneralParameterValue>();
        Parameters.search(parameter, name, maxDepth, list);
        return list;
    }

    private static void search(GeneralParameterValue parameter, String name, int maxDepth, Collection<GeneralParameterValue> list) {
        if (maxDepth >= 0) {
            if (IdentifiedObjects.isHeuristicMatchForName((IdentifiedObject)parameter.getDescriptor(), (String)name)) {
                list.add(parameter);
            }
            if (maxDepth != 0 && parameter instanceof ParameterValueGroup) {
                for (GeneralParameterValue value : ((ParameterValueGroup)parameter).values()) {
                    Parameters.search(value, name, maxDepth - 1, list);
                }
            }
        }
    }

    public static void copy(GeneralParameterValue parameters, Map<? super String, Object> destination) {
        Parameters.copy(parameters, destination, null, 0, true);
    }

    private static StringBuilder copy(GeneralParameterValue parameters, Map<? super String, Object> destination, StringBuilder buffer, int base, boolean isRoot) {
        String name = parameters.getDescriptor().getName().getCode();
        if (parameters instanceof ParameterValue) {
            Object old;
            Object value = ((ParameterValue)parameters).getValue();
            String key = name;
            if (base > 0) {
                buffer.setLength(base);
                key = buffer.append(name).toString();
            }
            if ((old = destination.put(key, value)) != null && !old.equals(value)) {
                throw new IllegalArgumentException(Errors.format((short)80));
            }
        }
        if (parameters instanceof ParameterValueGroup) {
            if (!isRoot) {
                if (buffer == null) {
                    buffer = new StringBuilder(32);
                }
                buffer.setLength(base);
                base = buffer.append(name).append(':').length();
            }
            for (GeneralParameterValue value : ((ParameterValueGroup)parameters).values()) {
                buffer = Parameters.copy(value, destination, buffer, base, false);
            }
        }
        return buffer;
    }

    @Deprecated
    private static void copy(ParameterValueGroup source, ParameterValueGroup target) {
        for (GeneralParameterValue param : source.values()) {
            String name = param.getDescriptor().getName().getCode();
            if (param instanceof ParameterValueGroup) {
                Parameters.copy((ParameterValueGroup)param, target.addGroup(name));
                continue;
            }
            target.parameter(name).setValue(((ParameterValue)param).getValue());
        }
    }

    @Deprecated
    public static boolean ensureSet(ParameterValueGroup parameters, String name, double value, Unit<?> unit, boolean force) throws ParameterNotFoundException {
        ParameterValue parameter = parameters.parameter(name);
        try {
            double current = parameter.doubleValue(unit);
            if (Math.abs(current / value - 1.0) <= 1.0E-8) {
                return false;
            }
            if (Double.isNaN(current)) {
                force = true;
            }
        }
        catch (IllegalStateException exception) {
            force = true;
        }
        if (force) {
            parameter.setValue(value, unit);
        } else {
            Logging.log(Parameters.class, (String)"ensureSet", (LogRecord)new LogRecord(Level.FINE, Errors.format((short)211, name)));
        }
        return true;
    }

    public static Map<String, Object> toMap(ParameterValueGroup source) {
        ArgumentChecks.ensureNonNull((String)"source", (Object)source);
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (GeneralParameterValue value : source.values()) {
            String parameterName = value.getDescriptor().getName().getCode();
            if (value instanceof ParameterValue) {
                result.put(parameterName, ((ParameterValue)value).getValue());
                continue;
            }
            if (!(value instanceof ParameterValueGroup)) continue;
            ArrayList<Map<String, Object>> subGroup = (ArrayList<Map<String, Object>>)result.get(parameterName);
            if (subGroup == null) {
                subGroup = new ArrayList<Map<String, Object>>();
                result.put(parameterName, subGroup);
            }
            subGroup.add(Parameters.toMap((ParameterValueGroup)value));
        }
        return result;
    }

    public static ParameterValueGroup toParameter(Map<String, ?> params, ParameterDescriptorGroup desc) {
        ArgumentChecks.ensureNonNull((String)"params", params);
        ArgumentChecks.ensureNonNull((String)"desc", (Object)desc);
        return Parameters.toParameter(params, desc, true);
    }

    public static ParameterValueGroup toParameter(Map<String, ?> params, ParameterDescriptorGroup desc, boolean checkMandatory) throws ParameterNotFoundException, UnconvertibleObjectException {
        ArgumentChecks.ensureNonNull((String)"params", params);
        ArgumentChecks.ensureNonNull((String)"desc", (Object)desc);
        if (checkMandatory) {
            for (GeneralParameterDescriptor de : desc.descriptors()) {
                if (de.getMinimumOccurs() <= 0 || Parameters.containsKey(params, de) || !(de instanceof ParameterDescriptor) || ((ParameterDescriptor)de).getDefaultValue() != null) continue;
                throw new ParameterNotFoundException("A mandatory parameter " + de.getName() + " was not found in the input parameters.", de.getName().getCode());
            }
        }
        ParameterValueGroup parameter = desc.createValue();
        for (Map.Entry<String, ?> entry : params.entrySet()) {
            GeneralParameterDescriptor subDesc;
            try {
                subDesc = desc.descriptor(entry.getKey());
            }
            catch (ParameterNotFoundException ex) {
                continue;
            }
            if (subDesc instanceof ParameterDescriptorGroup) {
                if (entry.getValue() instanceof Map) {
                    parameter.values().add(Parameters.toParameter((Map)entry.getValue(), (ParameterDescriptorGroup)subDesc, checkMandatory));
                    continue;
                }
                if (entry.getValue() instanceof Collection) {
                    int i;
                    int nbParamGroups;
                    ArrayList values = new ArrayList((Collection)entry.getValue());
                    int nbGroups = values.size();
                    if (nbGroups > (nbParamGroups = parameter.groups(entry.getKey()).size())) {
                        int toAdd = nbGroups - nbParamGroups;
                        for (i = 0; i < toAdd; ++i) {
                            parameter.addGroup(entry.getKey());
                        }
                    }
                    List paramGroups = parameter.groups(entry.getKey());
                    for (i = 0; i < nbGroups; ++i) {
                        Object valObj = values.get(i);
                        if (!(valObj instanceof Map)) {
                            throw new IllegalArgumentException("Illegal value for parameter " + entry.getKey() + ". It's a parameter group, so we should have a nested map as input.");
                        }
                        ParameterValueGroup newGroup = Parameters.toParameter((Map)valObj, (ParameterDescriptorGroup)subDesc, checkMandatory);
                        Parameters.copy(newGroup, (ParameterValueGroup)paramGroups.get(i));
                    }
                    continue;
                }
                throw new IllegalArgumentException("Illegal value for parameter " + entry.getKey() + ". It's a parameter group, so we should have a nested map as input.");
            }
            if (subDesc instanceof ParameterDescriptor) {
                ParameterDescriptor pdesc = (ParameterDescriptor)subDesc;
                try {
                    ParameterValue<?> param = Parameters.getOrCreate(pdesc, parameter);
                    param.setValue(ObjectConverters.convert(entry.getValue(), (Class)pdesc.getValueClass()));
                }
                catch (ParameterNotFoundException e) {}
                continue;
            }
            throw new IllegalArgumentException("Unsupported parameter type.");
        }
        return parameter;
    }

    public static GeneralParameterValue getParameterOrGroup(ParameterValueGroup group, String name) {
        for (GeneralParameterValue p : group.values()) {
            if (!p.getDescriptor().getName().getCode().equalsIgnoreCase(name)) continue;
            return p;
        }
        return null;
    }

    private static boolean containsKey(Map<String, ?> params, GeneralParameterDescriptor desc) {
        if (params.containsKey(desc.getName().getCode())) {
            return true;
        }
        for (GenericName alias : desc.getAlias()) {
            if (!params.containsKey(alias.tip().toString())) continue;
            return true;
        }
        return false;
    }
}

