/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.geomatics.gml;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.geotoolkit.gml.xml.v321.AbstractRingPropertyType;
import org.geotoolkit.gml.xml.v321.AbstractRingType;
import org.geotoolkit.gml.xml.v321.AbstractSurfacePatchType;
import org.geotoolkit.gml.xml.v321.PolygonPatchType;
import org.geotoolkit.gml.xml.v321.RectangleType;
import org.geotoolkit.gml.xml.v321.TriangleType;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum SurfacePatchType {
    POLYGON{

        @Override
        public AbstractRingType getExteriorBoundary(AbstractSurfacePatchType patch) {
            PolygonPatchType polygon = (PolygonPatchType)PolygonPatchType.class.cast(patch);
            return polygon.getExterior().getAbstractRing();
        }

        @Override
        public Set<AbstractRingType> getInteriorBoundaries(AbstractSurfacePatchType patch) {
            PolygonPatchType polygon = (PolygonPatchType)PolygonPatchType.class.cast(patch);
            HashSet<AbstractRingType> set = new HashSet<AbstractRingType>();
            for (AbstractRingPropertyType ringProp : polygon.getInterior()) {
                set.add(ringProp.getAbstractRing());
            }
            return set;
        }
    }
    ,
    RECTANGLE{

        @Override
        public AbstractRingType getExteriorBoundary(AbstractSurfacePatchType patch) {
            RectangleType rectangle = (RectangleType)RectangleType.class.cast(patch);
            return rectangle.getExterior().getAbstractRing();
        }

        @Override
        public Set<AbstractRingType> getInteriorBoundaries(AbstractSurfacePatchType patch) {
            return Collections.emptySet();
        }
    }
    ,
    TRIANGLE{

        @Override
        public AbstractRingType getExteriorBoundary(AbstractSurfacePatchType patch) {
            TriangleType triangle = (TriangleType)TriangleType.class.cast(patch);
            return triangle.getExterior().getAbstractRing();
        }

        @Override
        public Set<AbstractRingType> getInteriorBoundaries(AbstractSurfacePatchType patch) {
            return Collections.emptySet();
        }
    };


    public abstract AbstractRingType getExteriorBoundary(AbstractSurfacePatchType var1);

    public abstract Set<AbstractRingType> getInteriorBoundaries(AbstractSurfacePatchType var1);
}

