/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb;

import java.lang.reflect.Modifier;
import java.util.IdentityHashMap;
import java.util.Map;

public final class PrimitiveTypeProperties {
    private static final Map<Object, Object> SENTINEL_VALUES = new IdentityHashMap<Object, Object>();

    private PrimitiveTypeProperties() {
    }

    private static boolean isValidKey(Object primitive) {
        return Modifier.isFinal(primitive.getClass().getModifiers());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void associate(Object primitive, Object property) {
        assert (PrimitiveTypeProperties.isValidKey(primitive)) : primitive;
        Map<Object, Object> map = SENTINEL_VALUES;
        synchronized (map) {
            Object old = SENTINEL_VALUES.put(primitive, property);
            if (old != null) {
                SENTINEL_VALUES.put(primitive, old);
                throw new AssertionError(primitive);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object property(Object primitive) {
        Map<Object, Object> map = SENTINEL_VALUES;
        synchronized (map) {
            return SENTINEL_VALUES.get(primitive);
        }
    }
}

