/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.gco;

import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.FilterByVersion;
import org.apache.sis.internal.jaxb.gco.GO_CharacterString;
import org.apache.sis.internal.jaxb.gcx.Anchor;
import org.apache.sis.internal.jaxb.lan.PT_FreeText;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.util.CharSequences;
import org.apache.sis.xml.XLink;
import org.opengis.util.InternationalString;

public class CharSequenceAdapter
extends XmlAdapter<GO_CharacterString, CharSequence> {
    @Override
    public final CharSequence unmarshal(GO_CharacterString value) {
        return value != null ? value.toCharSequence() : null;
    }

    @Override
    public GO_CharacterString marshal(CharSequence value) {
        return CharSequenceAdapter.wrap(value);
    }

    static GO_CharacterString wrap(CharSequence value) {
        Context context;
        XLink linkage;
        String key;
        PT_FreeText ft;
        if (value instanceof String) {
            return CharSequenceAdapter.wrap(Context.current(), value, (String)value);
        }
        if (value instanceof InternationalString && (ft = PT_FreeText.create((InternationalString)value)) != null) {
            return ft;
        }
        if ((value = CharSequences.trimWhitespaces((CharSequence)value)) == null || value.length() == 0) {
            return null;
        }
        if (!(value instanceof Anchor) && (key = Strings.trimOrNull(value.toString())) != null && (linkage = Context.resolver(context = Context.current()).anchor(context, value, key)) != null) {
            value = linkage instanceof Anchor ? (Anchor)linkage : new Anchor(linkage, key);
        }
        return new GO_CharacterString((CharSequence)value);
    }

    public static GO_CharacterString wrap(Context context, Object object, String string) {
        CharSequence text = CharSequenceAdapter.value(context, object, string);
        return text != null ? new GO_CharacterString(text) : null;
    }

    public static CharSequence value(Context context, Object object, String string) {
        XLink linkage;
        if ((string = Strings.trimOrNull(string)) != null && (linkage = Context.resolver(context).anchor(context, object, string)) != null) {
            if (linkage instanceof Anchor) {
                return (Anchor)linkage;
            }
            return new Anchor(linkage, string);
        }
        return string;
    }

    public static final class Since2014
    extends CharSequenceAdapter {
        @Override
        public GO_CharacterString marshal(CharSequence value) {
            return FilterByVersion.CURRENT_METADATA.accept() ? super.marshal(value) : null;
        }
    }
}

